@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="cashier-page">
        <div class="row justify-content-center">
            <div class="col">
                <div class="head-cashier pay-pop">
                    <div class="logo">
                        <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                    </div>

                    <div class="d-flex align-items-center mb-2">
                        @php
                            $warehouseName = userWarehouse();
                            $words = explode(' ', $warehouseName);
                            $firstWord = $words[0] ?? '';
                            $remainingWords = implode(' ', array_slice($words, 1));
                        @endphp

                        @admin
                            <a href="{{ route('select-warehouse') }}" class="text-decoration-none">
                                <div class="flex-grow-1">
                                    <h5 class="mb-0 head-cashier-2" style="font-weight: 300;">{{ $firstWord }}</h5>
                                    <h2 class="head-cashier-2" style="font-weight: 600;">{{ $remainingWords }}</h2>
                                </div>
                            </a>
                        @else
                            <a class="text-decoration-none">
                                <div class="flex-grow-1">
                                    <h5 class="mb-0 head-cashier-2" style="font-weight: 300;">{{ $firstWord }}</h5>
                                    <h2 class="head-cashier-2" style="font-weight: 600;">{{ $remainingWords }}</h2>
                                </div>
                            </a>
                        @endadmin
                    </div>


                    <div class="d-flex gap-3">
                        <div class="shadow-sm clock2">
                            <livewire:clock />
                        </div>
                    </div>

                </div>

                <div class="card-body" id="cashier1">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    <livewire:cashier.index />

                    
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#warehouseSelect').change(function() {
                var whs_code = $(this).val();

                $.ajax({
                    url: '/update-warehouse',
                    /
                    method: 'POST',
                    data: {
                        whs_code: whs_code,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {

                        var words = response.warehouseName.split(' ');
                        var firstWord = words[0] || '';
                        var remainingWords = words.slice(1).join(' ');

                        $('.head-cashier-2').eq(0).text(firstWord);
                        $('.head-cashier-2').eq(1).text(remainingWords);
                    },
                    error: function(xhr) {
                        console.error(xhr.responseText);
                    }
                });
            });
        });
    </script>
@endsection
