<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Your Account</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }

        .verification-container {
            max-width: 500px;
            margin: 50px auto;
            background-color: #ffffff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .verification-container h2 {
            margin-bottom: 20px;
        }

        .verification-container .btn {
            width: 100%;
        }

        .verification-container .alert {
            margin-top: 20px;
        }
    </style>
</head>

<body>

    <div class="container">
        <div class="verification-container">

            @if (session('success') || session('error'))
                <div class="alert {{ session('success') ? 'alert-success' : 'alert-danger' }} text-center">
                    {{ session('success') ?? session('error') }}
                </div>
                <h2 class="text-center">Your Account is Active</h2>

                <p class="text-center">Your account is already active. You can proceed to the Login.</p>
                <div class="text-center">
                    <a href="{{ route('login') }}" class="btn btn-primary">Go to Login</a>
                </div>
            @else
                <p class="text-center">Dear <strong>{{ $company->name }}</strong>,</p>
                <p class="text-center">To complete the verification of your account and company, please click the button
                    below.</p>

                <form action="{{ route('verif.post', $company->code) }}" method="POST">
                    @csrf
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary">Verify Now</button>
                    </div>
                </form>
            @endif


            <hr>

        </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
