<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Setup - Supplier Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
    @livewireStyles
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full">
        <div class="text-center mb-8">
            @if(config('app.logo'))
                <img src="{{ config('app.logo') }}" alt="Logo" class="h-12 mx-auto mb-6">
            @endif
            <h1 class="text-4xl font-bold text-gray-900 tracking-tight mb-3">Create New Password</h1>
            <p class="text-lg text-gray-600">Please create a password to access your supplier dashboard</p>
        </div>

        <div class="bg-white/80 backdrop-blur-lg rounded-2xl shadow-xl p-8 ring-1 ring-gray-900/5">
            @livewire('setup-password', ['token' => request()->token])
        </div>

        <div class="text-center mt-8">
            <p class="text-sm text-gray-600">
                &copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
            </p>
            <p class="text-sm text-gray-500 mt-2">
                Need help? Contact support
            </p>
        </div>
    </div>

    @livewireScripts
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <x-livewire-alert::scripts />
</body>
</html>
