@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bold">{{ __('Report Transaction Member') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                    </div>
                    @if ($members->isEmpty())
                        <nav class="page-breadcrumb">
                            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a wire:navigate href="/">{{ __('Main') }}</a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        {{ __('Transaction Member') }}
                                    </li>
                                </ol>

                            </div>
                        </nav>

                        <div class="card-body" id="cashier">

                            <table class="my-table table-striped mt-2" id="example" style="width:100%">
                                <thead>
                                    <tr>
                                        <th style="border-top-left-radius: .5rem">Member ID</th>
                                        <th>Member Name</th>
                                        <th>Member Phone</th>
                                        <th>Member Email</th>
                                        <th>Member Address</th>
                                        <th style="border-top-right-radius: .5rem">Invoice</th>

                                    </tr>
                                </thead>
                            </table>
                        </div>
                    @else
                        <livewire:report.transactionmember />
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
