<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <style>
        * {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            font-size: 13px;
            font-weight: 600;
        }

        td,
        th,
        tr,
        table {
            border-collapse: collapse;
            padding: 3px;
            font-size: 1em;
        }

        td.qty,
        th.qty {
            width: 30px;
            max-width: 30px;
        }

        td.keterangan,
        th.keterangan {
            width: 100px;
            max-width: 100px;
            word-break: break-all;
        }

        td.harga,
        th.harga {
            width: 80px;
            max-width: 80px;
            word-break: break-all;
        }

        td.jumlah,
        th.jumlah {
            width: 90px;
            max-width: 90px;
            word-break: break-all;
        }

        .centered {
            text-align: center;
            align-content: center;
        }

        .align-right {
            text-align: right;
        }

        .container {
            width: 76.2mm;
            max-width: 76.2mm;
        }

        .font {
            font-size: 1.2em;
            font-weight: bold;
        }

        .font-isi {
            font-size: 1em;
            font-weight: bold;
        }

        .flex {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            margin-right: 4%;
            margin-left: 2%;
            margin-top: 3%;
        }

        .size {
            font-size: 1.2em;
        }

        .total-label {
            font-family: monospace;
            width: 85px;
            text-align: left;
            margin-left: 25px;
        }

        .total-value {
            font-family: monospace;
            width: 80px;
            text-align: left;
            margin-left: 55px;
        }

        .colon {
            margin-left: 0px;
            margin-right: 5px;
        }

        @media print {

            @page {
                size: 3in auto;
                /* Set the page width to 3 inches and height to auto */
                margin: 0;
            }

            body {
                margin: 0;
                padding: 0;
                box-shadow: none;
            }
        }
    </style>
    <title> {{ env('APP_NAME') }} || {{ $invoice->no }}</title>
</head>

<body>
    <div class="container">
        {{-- <p class="centered font">Palm Lagoon TRANS STUDIO BALI</p> --}}
        <p class="centered" style="font-size: 1em;">{{ $warehouse->name }}<br>Telp: {{ $warehouse->phone }}</p>
        {{-- <p class="centered font">Invoice: 123123</p> --}}
        {{-- <p class="centered size">123</p> --}}
        <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>

        <div class="flex">
            @php
                $cashierName = $invoice->users_name;
                $atPosition = strpos($cashierName, '@');
                if ($atPosition !== false) {
                    $cashierName = substr($cashierName, 0, $atPosition);
                }
            @endphp
            <div>Cashier : {{ $cashierName }}

            </div>
        </div>
        <div class="flex" style="margin-top: 2px;">
            <div>Bill No : {{ $invoice->no }}</div>
        </div>
        <div class="flex" style="margin-top: 2px; margin-bottom:10px;">
            <div>Date&nbsp; &nbsp; : {{ \Carbon\Carbon::parse($invoice->created_at)->format('d/m/Y H:i:s') }}</div>
        </div>
        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <table style="margin-top:10px; width:100%;">
            <thead>
                <tr style="border-bottom: 1px dashed rgb(0, 0, 0);">
                    <td class="keterangan" style="text-align: left;">Item</td>
                    <td class="qty centered">Qty</td>
                    <td class="harga centered">Price</td>
                </tr>
            </thead>
            <tbody>
                @foreach ($detail as $dt)
                    <tr style="font-size: 0.75em;">
                        <td class="keteranga size">{{ $dt->name }}</td>
                        <td class="qty centered size">
                            @if ($dt->unit == 0)
                                {{ intval($dt->qty) }} pcs
                            @else
                                {{ intval($dt->qty_unit) }} {{ $dt->unit_name }}
                            @endif
                        </td>
                        <td class="harga centered size">
                            @if ($dt->unit == 0)
                                {{ number_format($dt->nprice, 0, ',', '.') }}
                                @if ($dt->price != $dt->nprice)
                                    <br>({{ number_format($dt->nprice - $dt->price, 0, ',', '.') }})
                                @endif
                            @else
                                {{ number_format($dt->pricesell, 0, ',', '.') }}
                            @endif
                        </td>
                    </tr>
                @endforeach

            </tbody>
        </table>
        @if ($invoice->payment == 'Multi' || $invoice->payment == 'Card')
            @php
                $note = json_decode($invoice->note, true);
            @endphp
            <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>
            <div class="flex" style="margin-top: 10px;">
                <div>Card Number : {{ $note['nomor_kartu'] }}</div>
            </div>
            <div class="flex" style="margin-top: 2px; margin-bottom:10px;">
                <div>Name&nbsp; &nbsp; &nbsp; &nbsp; : {{ $note['nama_pemegang_kartu'] }}</div>
            </div>
        @endif
        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <div>
            <div style="margin-left: 40px;" class="flex">
                <div class="total-label">Sub Total    </div>
                <div class="colon">:</div>
                <div class="total-value">{{ number_format($invoice->subtotal, 0, ',', '.') }}</div>
            </div>
            <div style="margin-left: 40px; margin-top:1px;" class="flex">
                <div class="total-label">Discount     </div>
                <div class="colon">:</div>
                <div class="total-value">{{ number_format($invoice->disc_total, 0, ',', '.') }}</div>
            </div>
            <div style="margin-left: 40px; margin-top:1px;" class="flex">
                <div class="total-label">GrandTotal   </div>
                <div class="colon">:</div>
                <div class="total-value">{{ number_format($invoice->must_paid, 0, ',', '.') }}</div>
            </div>
            @if ($invoice->payment == 'Multi' || $invoice->payment == 'Card')
                <div style="margin-left: 40px; margin-top:1px;" class="flex">
                    <div class="total-label">Card         </div>
                    <div class="colon">:</div>
                    <div class="total-value">{{ number_format($note['transfer'], 0, ',', '.') }}</div>
                </div>
                <div style="margin-left: 40px; margin-top:1px;" class="flex">
                    <div class="total-label">Cash         </div>
                    <div class="colon">:</div>
                    <div class="total-value">{{ number_format($note['cash'] ?? 0, 0, ',', '.') }}</div>
                </div>
            @else
                <div style="margin-left: 40px; margin-top:1px;" class="flex">
                    <div class="total-label">Card         </div>
                    <div class="colon">:</div>
                    <div class="total-value">0</div>
                </div>
                <div style="margin-left: 40px; margin-top:1px;" class="flex">
                    <div class="total-label">Cash         </div>
                    <div class="colon">:</div>
                    <div class="total-value">{{ number_format($invoice->paid, 0, ',', '.') }}</div>
                </div>
            @endif
            <div style="margin-left: 40px; margin-top:1px;" class="flex">
                <div class="total-label">Change       </div>
                <div class="colon">:</div>
                <div class="total-value">{{ number_format($invoice->change, 0, ',', '.') }}</div>
            </div>
        </div>
        <br>
        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        @if($voucher)
        <div class="flex" style="margin-top: 10px; margin-bottom:10px;">
            <div style="font-weight: 600;">Voucher (Rp {{ number_format($voucher->value, 0, ',', '.') }}) : {{ $voucher->voucher }}</div>
        </div>
        @endif
        <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin: 15px 0;"></div>

        <div class="flex" style="margin-top: 15px; margin-bottom:10px;">
           
            <div style="font-weight: 600;">Handled By : {{ $invoice->sales_name ?? 'N/A' }}</div>
        </div>

        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <p class="centered" style="font-size: 1.1em;">
            {!! $footer !!}
        </p>
        <br><br>
        <p style="text-align:center;">( _ _ _ _ _ _ _ _ _ _ _ )</p>
        &nbsp;
        <br>
        <div style="width: 100%; display: flex; justify-content: flex-end; align-items: flex-end;">
            <span style="color: #bbb; font-size: 11px; opacity: 0.7; user-select: none;">Powered by Softcomp.io</span>
        </div>
    </div>
    <script type="text/javascript">
        // Function to print the page
        window.onload = function() {
            window.print();
        };
    
        // Function to run before printing
        var beforePrint = function() {
        };
    
        // Function to run after printing with a 1-second delay before closing
        var afterPrint = function() {
            // Set a timeout of 1 second before closing the window or tab
            setTimeout(function() {
                window.close();
            }, 6000); 
        };
    
        // Listen for print events
        if (window.matchMedia) {
            var mediaQueryList = window.matchMedia('print');
            mediaQueryList.addListener(function(mql) {
                if (mql.matches) {
                    beforePrint();
                } else {
                    afterPrint();
                }
            });
        }
    
        // Attach before and after print event handlers
        window.onbeforeprint = beforePrint;
        window.onafterprint = afterPrint;
    </script>

</body>

</html>