@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="goods-receipt-page">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Goods receipt') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                        {{-- <a href="{{ route('welcome.dashboard') }}" class="btn badge btn-primary">POS</a> --}}
                    </div>
                    <div class="card-body">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif

                        <livewire:pos.purchase-order.index />

                    </div>
                </div>
            </div>
        </div>
    </div>
    @if ($istutorials)
        <script>
            const goodsReceiptsPopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver({
                    showProgress: true,
                    steps: [
                        {
                            element: '.create-new-goods-receipt-pop',
                            popover: {
                                description: 'Click this button to create a new goods receipt and record items received from the supplier.'
                            }
                        },
                        {
                            element: '.goodsReceipt-detail-pop',
                            popover: {
                                description: 'Click this button to view the details of the goods receipt.'
                            },
                            onDeselected: () => {
                                $.ajax({
                                    type: "POST",
                                    url: '/update-status-driver',
                                    data: {
                                        menu: "Goods Receipt",
                                        _token: '{{ csrf_token() }}'
                                    },
                                    success: function(data) {
                                    },
                                    error: function(data, textStatus, errorThrown) {
                                    },
                                });
                            }
                        },
                        {
                            element: '.go-sales-pop',
                            popover: {
                                description: 'Now proceed to the Sales menu.'
                            }
                        },
                    ]
                });

                driverObj.drive();
            }

        </script>
    @endif
@endsection
