@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }

        .card-header {
            border-bottom: none;
            padding-bottom: 0;
        }

        .pricing-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: -40px;
            left: 50%;
            transform: translateX(-50%);
        }

        .best-value {
            position: absolute;
            top: 10px;
            right: -5px;
            background: #ffd700;
            padding: 2px 8px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .feature-list {
            list-style: none;
            padding-left: 0;
        }

        .feature-list li::before {
            content: "✓";
            color: #28a745;
            margin-right: 0.5rem;
        }

        .premium .feature-list li::before {
            color: #0dcaf0;
        }

        .card {
            margin-top: 40px;
        }
    </style>

    <div class="container-fluid mt-5">
        <header class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <img src="{{ asset('assets/favicon/android-chrome-192x192.png') }}" alt="Company Logo" class="me-2" style="width: 30px; height: 30px;">
                <h1 class="h5 mb-0">{{ $company->name }}</h1>
            </div>

            <a href="{{ route('paymentrenew') }}" class="btn btn-secondary">Back</a>
        </header>
    </div>
    <livewire:payment.page-upgrade />

@endsection

<script>
    function setPaketId(paketId) {
        setTimeout(function() {
            $('#upgradeModal').modal('show');
        }, 500);
    }
</script>
