@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    {{-- <div class="subscription-page">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Subscription') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                    </div>
                    <nav class="page-breadcrumb">
                        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a livewire:navigate href="/">{{ __('Main') }}</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    {{ __('Subscription') }}
                                </li>
                            </ol>
                        </div>
                    </nav>
                    <div class="">

                        <div class="container mt-5">
                            <div class="card shadow">
                                <div class="card-header text-center">
                                    <h3>Renew Access</h3>
                                </div>
                                <div class="card-body text-center">
                                    <p class="lead">You need to renew your subscription to access this feature.</p>
                                    <p class="mb-4">Please click the button below to proceed.</p>
                                    @admin
                                        <button id="pay-button" class="btn btn-primary btn-lg" data-bs-toggle="modal"
                                            data-bs-target="#paymentModal">Pay</button>
                                    @else
                                        <button class="btn btn-primary btn-lg" disabled>Pay</button>
                                    @endadmin
                                </div>
                                <div class="card-footer text-muted text-center">
                                    &copy; {{ date('Y') }} Softcomp. All rights reserved.
                                </div>
                            </div>
                        </div>

                        <div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="paymentModalLabel">Payment Details</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p><strong>Account :</strong> <span>{{ $userCount }}</span></p>
                                        <p><strong>Amount :</strong> Rp.
                                            <span>{{ number_format($amount, 0, ',', '.') }}</span></p>

                                        <p><strong>Total Amount :</strong> Rp.
                                            <span>{{ number_format($totalAmount, 0, ',', '.') }}</span></p>

                                        <p>Please confirm to proceed with the payment.</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Cancel</button>
                                            <button id="create-payment-button" class="btn btn-primary">Create Payment</button>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}

    <div class="container-fluid mt-5">
        <header class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <img src="{{ asset('assets/favicon/android-chrome-192x192.png') }}" alt="Company Logo" class="me-2" style="width: 30px; height: 30px;">
                <h1 class="h5 mb-0">{{ $company->name }}</h1>
            </div>

        </header>

        <div class="row g-4">


            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-receipt text-primary"></i>
                                <span>My Bills</span>
                            </div>
                            <div>
                                <a href="{{ route('paymentupgrade') }}" class="btn btn-outline-secondary">Change Package</a>
                                <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#paymentModal">
                                    <i class="bi bi-plus-lg me-1"></i>
                                    Extend
                                </button>
                                <a href="{{ route('paymentable') }}" class="btn btn-outline-info me-2">History</a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-shop text-success me-2"></i>
                                <span>{{ $company->plan }}</span>
                            </div>
                            @if ($company->expired_at <= now())
                                <span class="badge bg-danger-subtle text-danger rounded-pill px-3">End</span>
                            @else
                                <span class="badge bg-success text-white rounded-pill px-3">{{ \Carbon\Carbon::parse($company->expired_at)->format('d F Y') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <livewire:payment.modal-renew />

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@endsection
