@extends('layouts.app')

@section('content')
<style>
    .container {
        max-width: 1775px;
    }
</style>
<div class="opname-page">
    <div class="row justify-content-center">
        <div class="col">
            <div class="">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="title-page mb-0" style="font-weight: bolder">{{ __('Stock Opname') }}</h5>
                    <div class="logo">
                        <img src="{{asset('assets/SoftComp - Logo-01.png')}}" alt="Image Description">
                    </div>
                    {{-- <a href="{{ route('welcome.dashboard') }}" class="btn badge btn-primary">POS</a> --}}
                </div>
                <div class="">
                    @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                    @endif
                    {{-- <livewire:pos.opname.opname-input /> --}}
                    <livewire:pos.opname.index-opname />

                </div>
            </div>
        </div>
    </div>
</div>
@if($istutorials)
<script>
    const opnamePopup = () => {
            const driver = window.driver.js.driver;
            const driverObj = driver();
            driverObj.highlight({
                element: '.detail-stock-pop',
                popover: {
                    description: 'Click this button to see details of each stock item',
                },
                onDeselected: () => {
                    $.ajax({
                        type: "POST",
                        url: '/update-status-driver',
                        data: {
                            menu: "Opname",
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                        },
                        error: function(data, textStatus, errorThrown) {
                        },
                    });

                }
            });
        }
</script>
@endif
@endsection