<div>
    <div wire:ignore.self class="modal fade " id="modalWarehouse" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Store</h5>
                    <button type="button" wire:click="resetForm" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <div class="form-group">
                            <label for="barcode">Code Store</label>
                            <input type="text" wire:model.live="code" id="code" class="form-control"
                                @if ($codewarehouse != '') disabled @endif>
                            @error('code')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" wire:model.live="name" id="name" class="form-control mb-2">
                        @error('name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="pricelist_code">Pricelist Code</label>
                        <select class="form-select mb-2" wire:model.live="pricelist_code">
                            <option value="">-- Select Pricelist --</option>
                            @foreach ($pricelist as $pl)
                                <option value="{{ $pl->code }}">{{ $pl->code }}</option>
                            @endforeach
                            @if (!$codewarehouse)
                                <option value="PricelistCN">
                                    {{ empty($pricelist_codenew) ? 'Create New' : $pricelist_codenew }}
                                </option>
                            @endif
                        </select>
                        @if ($isCreateNewPricelist)
                            <button data-bs-target="#modalCreatePricelist" data-bs-toggle="modal"
                                data-bs-dismiss="modal" class="btn badge bg-primary">Open Form Pricelist</button>
                        @endif
                        @error('pricelist_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="address">Address</label>
                        <input type="text" wire:model.live="address" id="address" class="form-control mb-2">
                        @error('address')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="phone">Phone</label>
                        <input type="text" wire:model.live="phone" id="phone" class="form-control mb-2">
                        @error('phone')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="text" wire:model.live="email" id="email" class="form-control mb-2">
                        @error('email')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="receipt_footer" class="form-label fs-6">Footer Receipt</label>
                        <textarea type="text" id="receipt_footer" class="form-control" style="border-radius: 1rem" placeholder="Footer"
                            wire:model.live="receipt_footer" rows="5"></textarea>
                    </div>
                    <div class="form-group mt-3">
                        <div class="form-check">
                            <input type="checkbox" wire:model.live="whs_central" id="whs_central" class="form-check-input" 
                                {{ $whs_central == 'Y' ? 'checked' : '' }}>
                            <label class="form-check-label" for="whs_central">Set as main warehouse</label>
                        </div>
                        @if($centralWarehouseExists && $whs_central == 'Y')
                            <div class="alert alert-warning mt-2">
                                <small>There is already a main warehouse ({{ $existingCentralWarehouse->name }}), if you continue this warehouse will become the main warehouse</small>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                        wire:click="resetForm">Close</button>
                    <button type="button" class="btn btn-primary" wire:click="saveWarehouse">Save</button>
                </div>

            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade " id="modalCreatePricelist" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Pricelist</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="code">Pricelist Code</label>
                        <input type="text" wire:model.live="pricelist_codenew" id="pricelist_codenew"
                            class="form-control mb-2">
                        @error('pricelist_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" wire:model.live="pricelist_name" id="pricelist_name"
                            class="form-control mb-2">
                        @error('pricelist_name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalWarehouse" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.getElementById('receipt_footer').addEventListener('keydown', function(event) {
        if (event.key === 'Enter') {
            event.preventDefault();
            const cursorPosition = this.selectionStart;
            const value = this.value;
            const textBefore = value.substring(0, cursorPosition);
            const textAfter = value.substring(cursorPosition);

            this.value = textBefore + "\n" + textAfter;
            this.selectionStart = this.selectionEnd = cursorPosition + 1;
        }
    });

    // Add event listener for modal reset
    document.addEventListener('livewire:initialized', () => {
        Livewire.on('refresh-modal', () => {
            // Get the modal element
            const modal = document.getElementById('modalWarehouse');
            
            // Hide the modal
            const bootstrapModal = bootstrap.Modal.getInstance(modal);
            if (bootstrapModal) {
                bootstrapModal.hide();
            }

            // Reset form fields
            modal.querySelectorAll('input, textarea, select').forEach(element => {
                if (element.type === 'checkbox') {
                    element.checked = false;
                } else {
                    element.value = '';
                }
            });

            // Remove any error messages
            modal.querySelectorAll('.text-danger').forEach(element => {
                element.remove();
            });

            // Remove any alert messages
            modal.querySelectorAll('.alert').forEach(element => {
                element.remove();
            });

            // Force Livewire to re-render the component
            Livewire.dispatch('refresh');
        });
    });
</script>
