<div>
    @if($valid)
    <form wire:submit="setupPassword" class="space-y-6">
        <div>
            <label for="password" class="block text-sm font-medium text-gray-900 mb-2">New Password</label>
            <div class="relative group">
                <input wire:model="password" type="password" id="password" 
                    class="block w-full px-4 py-3 rounded-xl border border-gray-300 text-gray-900 placeholder-gray-400
                    focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition duration-200
                    group-hover:border-gray-400"
                    placeholder="Enter new password">
                <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                    <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                </div>
                @error('password')
                    <p class="mt-2 text-sm text-red-600 flex items-center">
                        <svg class="w-4 h-4 mr-1 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                        </svg>
                        {{ $message }}
                    </p>
                @enderror
            </div>
        </div>

        <div>
            <label for="password_confirmation" class="block text-sm font-medium text-gray-900 mb-2">Confirm Password</label>
            <div class="relative group">
                <input wire:model="password_confirmation" type="password" id="password_confirmation"
                    class="block w-full px-4 py-3 rounded-xl border border-gray-300 text-gray-900 placeholder-gray-400
                    focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition duration-200
                    group-hover:border-gray-400"
                    placeholder="Masukkan ulang password baru">
                <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                    <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                </div>
                @error('password_confirmation')
                    <p class="mt-2 text-sm text-red-600 flex items-center">
                        <svg class="w-4 h-4 mr-1 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                        </svg>
                        {{ $message }}
                    </p>
                @enderror
            </div>
        </div>

        <div class="mt-8">
            <button type="submit"
                class="w-full flex justify-center items-center px-6 py-3.5 text-base font-medium text-white
                bg-gradient-to-r from-blue-600 to-blue-700 rounded-xl hover:from-blue-700 hover:to-blue-800
                focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 
                transform transition duration-200 ease-in-out hover:scale-[1.02] active:scale-[0.98]">
                Save Password
            </button>
        </div>

        <div class="mt-6">
            <p class="text-sm text-gray-500">
                Password requirements:
            </p>
            <ul class="mt-2 text-sm text-gray-500 space-y-1">
                <li class="flex items-center">
                    <svg class="w-4 h-4 mr-2 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                    </svg>
                    Minimum 8 characters
                </li>
                <li class="flex items-center">
                    <svg class="w-4 h-4 mr-2 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                    </svg>
                    Passwords must match
                </li>
            </ul>
        </div>
    </form>
    @else
    <div class="text-center">
        <h2 class="text-2xl font-bold text-gray-800 mb-4">Token is invalid or has expired</h2>
        <p class="text-gray-600">Please request a new password setup link.</p>
    </div>
    @endif
    <script>
        var url = '{{ config('app.url_supplier') }}';
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('redirect-to-login', () => {
                setTimeout(() => {
                    window.location.href = url;
                }, 2000);
            });
        });
    </script>
</div>