<div>
    <div class="container py-4">
        <div class="card shadow-sm">
            <div class="card-body p-4">
                <!-- Kasir Section -->
                <div class="mb-4">
                    <h5 class="card-title mb-3">Cashier Settings</h5>
                    <div class="row g-3">
                        <div class="col-md-4 col-sm-6">
                            <div class="card h-100 border-0 bg-light">
                                <div class="card-body">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="salesEmployee"
                                            wire:model.live="salesemployee">
                                        <label class="form-check-label" for="salesEmployee">Sales Employee</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6">
                            <div class="card h-100 border-0 bg-light">
                                <div class="card-body">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="editDiscount"
                                            wire:model.live="editdiscount">
                                        <label class="form-check-label" for="editDiscount">Edit Discount</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6">
                            <div class="card h-100 border-0 bg-light">
                                <div class="card-body">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="editPrice"
                                            wire:model.live="editprice">
                                        <label class="form-check-label" for="editPrice">Edit Price</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6">
                            <div class="card h-100 border-0 bg-light">
                                <div class="card-body">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="sandbox"
                                            wire:model.live="sandbox">
                                        <label class="form-check-label" for="sandbox">Sandbox</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6">
                            <div class="card h-100 border-0 bg-light">
                                <div class="card-body">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="minusTransaction"
                                            wire:model.live="minustransaction">
                                        <label class="form-check-label" for="minusTransaction">Negative Transaction</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6">
                            <div class="card h-100 border-0 bg-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="service"
                                                wire:model.live="service">
                                            <label class="form-check-label" for="service">Service</label>
                                        </div>
                                        <div x-data="{ show: @entangle('service') }" x-show="show" x-transition style="width: 100px;">
                                            <div class="input-group input-group-sm">
                                                <input type="number" class="form-control form-control-sm" id="nservice" 
                                                    placeholder="%" wire:model.live="nservice">
                                                <span class="input-group-text">%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Store Information -->
                <div class="mb-4">
                    <h5 class="card-title mb-3">Store Information</h5>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="warehousename"
                                    placeholder="Enter store name" wire:model.live="wh_name">
                                <label for="warehousename">Store Name</label>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="email" class="form-control" id="email" placeholder="Enter email"
                                    wire:model.live="email">
                                <label for="email">Email Address</label>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="phone"
                                    placeholder="Enter phone number" wire:model.live="phone">
                                <label for="phone">Phone Number</label>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="address"
                                    placeholder="Enter address" wire:model.live="address">
                                <label for="address">Address</label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Receipt Footer -->
                {{-- <div class="mb-4">
                    <h5 class="card-title mb-3">Pengaturan Struk</h5>
                    <div class="form-floating mb-3">
                        <textarea class="form-control" id="receipt_footer" placeholder="Masukkan teks footer" wire:model.live="footer"
                            style="height: 100px"></textarea>
                        <label for="receipt_footer">Teks Footer</label>
                    </div>

                    <div class="card bg-light">
                        <div class="card-body">
                            <label class="form-label fw-bold mb-2">Pratinjau</label>
                            <div class="text-center">{!! $displayforfooter !!}</div>
                        </div>
                    </div>
                </div> --}}

                <!-- Submit Button -->
                <div class="text-end">
                    <button type="button" wire:click="save" class="btn btn-primary btn-lg px-4">
                        <i class="bi bi-save me-2"></i>Save Changes
                    </button>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }

        .form-floating>.form-control:focus,
        .form-floating>.form-control:not(:placeholder-shown) {
            padding-top: 1.625rem;
            padding-bottom: .625rem;
        }

        .form-floating>.form-control:-webkit-autofill {
            padding-top: 1.625rem;
            padding-bottom: .625rem;
        }

        .form-floating>.form-control:focus~label,
        .form-floating>.form-control:not(:placeholder-shown)~label {
            opacity: .65;
            transform: scale(.85) translateY(-.5rem) translateX(.15rem);
        }
    </style>

    <script>
        document.getElementById('receipt_footer').addEventListener('keydown', function(event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                const cursorPosition = this.selectionStart;
                const value = this.value;
                const textBefore = value.substring(0, cursorPosition);
                const textAfter = value.substring(cursorPosition);

                this.value = textBefore + "\n" + textAfter;
                this.selectionStart = this.selectionEnd = cursorPosition + 1;
            }
        });
    </script>
</div>
