<div wire:ignore.self>
    <nav class="page-breadcrumb">
        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item">
                    <a wire:navigate href="/">{{ __('Main') }}</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    {{ __('Voucher') }}
                </li>
                <li class="breadcrumb-item d-flex align-items-center" aria-current="page">
                    @admin
                        <select class="form-select form-select-sm filter-it-pop" wire:model.live="whs_code"
                            style="width: auto;">
                            @foreach ($warehouse as $whs)
                                <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                            @endforeach
                        </select>
                    @else
                        <span class="me-2"> {{ __('Report') }} {{ userWarehouse() }}</span>
                    @endadmin
                </li>
            </ol>

        </div>
    </nav>

    <div class="pt-5" id="cashier">
        <div class="card-body">
            <table id="example" class="my-table" style="width:100%">
                <thead>
                    <tr>
                        <th style="border-top-left-radius: .5rem">#</th>
                        <th>No Promo</th>
                        <th>Code Voucher</th>
                        <th>Value</th>
                        <th>Created By Invoice</th>
                        <th>From</th>
                        <th>To</th>
                        <th style="border-top-right-radius: .5rem">Used By Invoice</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($data as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->no }}</td>
                            <td>{{ $item->voucher }}</td>
                            <td>{{ $item->value }}</td>
                            <td>{{ $item->createdBy ?? 'Admin' }}</td>
                            <td>{{ $item->voucher_from_date ?? '-' }}</td>
                            <td>{{ $item->voucher_to_date ?? '-' }}</td>
                            <td>
                                @if ($item->used != 'N')
                                    {{ $item->usedBy }}
                                @else
                                    Not Used
                                @endif
                            </td>

                        </tr>
                    @empty
                        <tr>
                            <td>Empty</td>

                        </tr>
                    @endforelse

                </tbody>
            </table>
        </div>
    </div>
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });
</script>
