<div class="">
    <nav class="page-breadcrumb">
        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item">
                    <a wire:navigate href="/">{{ __('Main') }}</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    {{ __('Transaction Member') }}
                </li>
                <li class="breadcrumb-item d-flex align-items-center" aria-current="page">
                    @admin
                        <select class="form-select form-select-sm filter-it-pop" wire:model.live="whs_code"
                            style="width: auto;">
                            @foreach ($warehouse as $whs)
                                <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                            @endforeach
                        </select>
                    @else
                        <span class="me-2"> {{ __('Report') }} {{ userWarehouse() }}</span>
                    @endadmin
                </li>
            </ol>

        </div>
    </nav>
    <div wire:ignore.self class="card-body" id="cashier">
        <div class="form-group row">
            <div class="col-md-4">
                <label for="startDate">Start Date</label>
                <input type="date" class="form-control" id="startDate" wire:model.live="startDate">
            </div>
            <div class="col-md-4">
                <label for="endDate">End Date</label>
                <input type="date" class="form-control" id="endDate" wire:model.live="endDate">
            </div>
            @if ($startDate != '')
                <div class="col-md-4 mt-4">
                    <button type="button" wire:click="filters" class="btn btn-primary mb-2">Filter</button>
                    <button type="button" wire:click="clearfilters" class="btn btn-danger mb-2">Clear Filter</button>
                </div>
            @else
                <div class="col-md-4 mt-4">
                    <button type="button" class="btn btn-primary mb-2" disabled>Filter</button>
                    <button type="button"class="btn btn-danger mb-2" disabled>Clear Filter</button>
                </div>
            @endif
        </div>
        <div class="col-md-4 mt-2">
            <button type="button" wire:click="exportExcel" class="btn btn-primary mb-2">Export Excel</button>
        </div>
        <table class="my-table mt-2" style="width:100%">
            <thead>
                <tr>
                    <th style="border-top-left-radius: .5rem">Member ID</th>
                    <th>Member Name</th>
                    <th>Member HP</th>
                    <th>Member Email</th>
                    <th>Member Address</th>
                    <th style="border-top-right-radius: .5rem">Invoice</th>

                </tr>
            </thead>
            <tbody>
                @forelse ($members as $member)
                    <tr>
                        <td>{{ $member->code }}</td>
                        <td>{{ $member->name }}</td>
                        <td>{{ $member->phone ?: '-' }}</td>
                        <td>{{ $member->email ?: '-' }}</td>
                        <td>{{ $member->address ?: '-' }}</td>
                        <td>
                            <button class="btn btn-badge bg-info text-black" data-bs-toggle="modal"
                                data-bs-target="#exampleModal"
                                wire:click="openModal('{{ $member->code }}')">{{ $member->invoices_count }}</button>
                        </td>

                    </tr>
                @empty
               
                <tr>
                    <td>Empty</td>

                </tr>
                @endforelse

            </tbody>
        </table>

        <!-- Modal -->
        <div wire:ignore.self class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Invoices</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        @if ($data)
                            @foreach ($data as $invoice)
                                <div class="card mt-2">
                                    <div wire:click="exportExcelDetail('{{ $invoice->no }}')" class="card-body"
                                        style="cursor: pointer;">
                                        <p>Invoice: {{ $invoice->no }}</p>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
