<div class="">
    <div class="form-group row">
        <div class="col-md-4">
            <label for="startDate">Period</label>
            <input type="date" class="form-control" id="startDate" wire:model="startDate">
        </div>
        @if ($startDate != '')
            <div class="col-md-4 mt-4">
                <button type="button" wire:click="filters" class="btn btn-primary mb-2">Filter</button>
                <button type="button" wire:click="clearfilters" class="btn btn-danger mb-2">Clear Filter</button>
            </div>
        @else
            <div class="col-md-4 mt-4">
                <button type="button" class="btn btn-primary mb-2" disabled>Filter</button>
                <button type="button" class="btn btn-danger mb-2" disabled>Clear Filter</button>
            </div>
        @endif
    </div>
    @admin
        <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
            <div class="form-group">
                <div class="d-flex" style="flex-direction: column">
                    <label for="searchItemInput">Store</label>
                    <input type="text" class="form-control rounded" wire:model.debounce.100ms.live="searchwarehouse"
                        id="searchWarehouseInput" placeholder="Search Store"
                        @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                        @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                        x-on:keydown.enter="    
    if(selectedIndexWarehouse == -1) {

    }else{
        $wire.selectWarehouse(selectedIndexWarehouse);
        selectedIndexWarehouse = -1;
    }"
                        autocomplete="off">
                </div>
                @if ($selectedWarehouse === null)
                    @if ($resultwarehouse)
                        <div class="dropdown-menu d-block py-0">
                            @foreach ($resultwarehouse as $index => $item)
                                <div class="px-2 py-1 border-bottom"
                                    :class="{ 'bg-primary': selectedIndexWarehouse === {{ $index }} }">
                                    <div class="d-flex flex-column ml-3">
                                        <button type="button" class="btn btn-link"
                                            :class="{ 'text-white': selectedIndexWarehouse === {{ $index }} }"
                                            wire:click="selectWarehouseByClick('{{ $item->code }}')">
                                            {{ $item->code }} || {{ $item->name }}
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                @endif
            </div>
        </div>
    @endadmin

    <div class="col-md-4
                mt-2">
        <button type="button" wire:click="exportExcel" class="btn btn-primary mb-2">Export Excel</button>
    </div>

    <table id="example" class="my-table mt-2" style="width:100%">
        <thead>
            <tr>
                <th scope="col" style="border-top-left-radius: 1rem">#</th>
                <th scope="col">{{ __('Store') }}</th>
                <th scope="col">{{ __('Brand') }}</th>
                <th scope="col">{{ __('Category') }}</th>
                <th scope="col">{{ __('Size') }}</th>
                <th scope="col">{{ __('Code') }}</th>
                <th scope="col">{{ __('Barcode') }}</th>
                <th scope="col">{{ __('Name') }}</th>
                <th scope="col">{{ __('OnHand') }}</th>
                <th scope="col">{{ __('Harga Jual') }}</th>
                <th scope="col" style="border-top-right-radius: 1rem">{{ __('Total') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($stock as $key => $item)
                <tr>
                    <td scope="col">{{ $loop->iteration }}</td>
                    <td>{{ $item->whs_name ?? '-' }}</td>
                    <td>{{ $item->brand }}</td>
                    <td>{{ $item->category }}</td>
                    <td>{{ $item->size }}</td>
                    <td>{{ $item->code }}</td>
                    <td>{{ $item->barcode }}</td>
                    <td>{{ $item->name }}</td>
                    <td>{{ $item->total_qty }}</td>
                    <td>{{ number_format($item->price) }} </td>
                    <td>{{ number_format($item->total_qty * $item->price) }}</td>

                </tr>
            @empty
                <span class="badge">-</span>
            @endforelse
        </tbody>
    </table>
</div>

@livewireScripts

<script>
   Livewire.on('refreshjs', (params) => {
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = 'none';
        new DataTable('#example', {
            order: [], // Disables initial sorting
        });
    });
});

</script>
