<div class="card">
    <div class="card-body">
        <div class="form-group row">
            <div class="col-md-4">
                <label for="startDate">Start Date</label>
                <input type="date" class="form-control" id="startDate" wire:model.live="startDate">
            </div>
            <div class="col-md-4">
                <label for="endDate">End Date</label>
                <input type="date" class="form-control" id="endDate" wire:model.live="endDate">
            </div>
            @if($startDate != '')
            <div class="col-md-4 mt-4">
                <button type="button" wire:click="filterInvoices" class="btn btn-primary mb-2">Filter</button>
                <button type="button" wire:click="clearFilter" class="btn btn-danger mb-2">Clear Filter</button>
            </div>
            @else
            <div class="col-md-4 mt-4">
                <button type="button" class="btn btn-primary mb-2" disabled>Filter</button>
                <button type="button" class="btn btn-danger mb-2" disabled>Clear Filter</button>
            </div>
            @endif
        </div>

        <div class="col-md-4 mt-2">
            <button type="button" wire:click="exportExcel" class="btn btn-primary mb-2">Export Excel</button>
        </div>
        <table>
            <thead>
                <tr></tr>
            </thead>
            <tbody>
                <td></td>
            </tbody>
        </table>
        <table class="table table-striped mt-2" style="width:100%">
            <thead>
                <tr>
                    <th>Invoice</th>
                    <th>Date</th>
                    <th>Time</th>
                    <th>User</th>
                    <th>Staff</th>
                    <th>Qty</th>
                    <th>Grand Total Return</th>
                    <th>Cash</th>
                    <th>Card</th>
                    <th>#</th>
                </tr>
            </thead>
            <tbody>
                @php
                $totalCash = 0;
                $totalTransfer = 0;
                $totalSubtotalQrisCash = 0;
                $totalSubtotalCard = 0;
                @endphp

                @foreach ($invoices as $invoice)
                <tr>

                    <td><button class="badge bg-info text-black" wire:click="exportExcelDetail('{{ $invoice->no }}')">{{ $invoice->no }}</button></td>
                    <td>{{ $invoice->created_at->format('d/m/y') }}</td>
                    <td>{{ $invoice->created_at->format('H:i') }}</td>
                    <td>{{ $invoice->user->name }}</td>
                    <td>{{ $invoice->sales_name }}</td>
                    <td>{{ $invoice->qty }}</td>
                    
                    <td>Rp. {{ number_format($invoice->must_paid, 0, ',', '.') }}</td>


                    @if ($invoice->payment === 'Multi')
                    @php
                    $totalCash += $invoice->cash;
                    $totalTransfer += $invoice->transfer;
                    @endphp
                    <td>Rp. {{ number_format($invoice->cash, 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format($invoice->transfer, 0, ',', '.') }}</td>
                    @elseif ($invoice->payment === 'Cash')
                    @php
                    $totalCash += $invoice->subtotal; // Add subtotal for Cash and Qris to totalCash
                    $totalSubtotalQrisCash += $invoice->subtotal;
                    @endphp
                    <td>Rp. {{ number_format($invoice->subtotal, 0, ',', '.') }}</td>
                    <td>Rp. 0</td>
                    @elseif ($invoice->payment === 'Qris')
                    @php
                    $totalSubtotalCard += $invoice->subtotal;
                    @endphp
                    <td>Rp. 0</td>
                    <td>Rp. {{ number_format($invoice->subtotal, 0, ',', '.') }}</td>
                    @elseif ($invoice->payment === 'Card')
                    @php
                    $totalSubtotalCard += $invoice->subtotal;
                    @endphp
                    <td>Rp. 0</td>
                    <td>Rp. {{ number_format($invoice->subtotal, 0, ',', '.') }}</td>
                    @else
                    {{-- mz --}}
                    <td>Rp. 0</td>
                    <td>Rp. 0</td>
                    @endif
                    <td>
                        <button class="btn btn-primary badge" data-bs-toggle="modal" data-bs-target="#modalPrint{{ $invoice->no }}">Print</button>
                    </td>
                </tr>
                <div wire:ignore.self class="modal fade" id="modalPrint{{ $invoice->no }}" tabindex="-1" aria-labelledby="modalPrintLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalPrintLabel">Print Invoice</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure want Print Receipt <span class="fw-bold"> {{ $invoice->no }} </span> ?</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
                                {{-- mz --}}
                                @if ($invoice->subtotal <= 0)
                                <button type="button" class="btn btn-primary" data-bs-dismiss="modal" wire:click="print('{{ $invoice->no }}')">Print</button>
                                @else
                                <button type="button" class="btn btn-primary" data-bs-dismiss="modal" wire:click="printwithmoney('{{ $invoice->no }}')">Print</button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach

                {{-- <tr>
                <td colspan="5">Total</td>
                <td>{{ $invoices->sum('qty') }}</td>
                <td>Rp. {{ number_format($invoices->sum('harusbayar'), 0, ',', '.') }}</td>
                <td>0</td>
                <td>Rp. {{ number_format($invoices->sum('harusbayar'), 0, ',', '.') }}</td>
                <td>Rp. {{ number_format($totalCash, 0, ',', '.') }}</td>
                <td>Rp. {{ number_format($totalSubtotalCard, 0, ',', '.') }}</td>
                </tr> --}}
                {{-- <table id="example" class="table table-striped mt-2" style="width:100%">
                    <thead>
                        <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th>Qty</th>
                            <th>Cash</th>
                            <th>Card</th>
                            <th>Sub Total</th>
                            <th>Discount</th>
                            <th>Grand Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td colspan="5">Total</td>
                            <td></td>
                            <td>{{ $invoices->sum('qty') }}</td>
                            <td>Rp. {{ number_format($totalCash, 0, ',', '.') }}</td>
                            <td>Rp. {{ number_format($totalSubtotalCard, 0, ',', '.') }}</td>
                            <td>Rp. {{ number_format($invoices->sum('subtotal'), 0, ',', '.') }}</td>
                            <td>Rp. {{ number_format($invoices->sum('discount'), 0, ',', '.') }}</td>
        
                            <td>Rp. {{ number_format($invoices->sum('grandtotal'), 0, ',', '.') }}</td>
                        </tr>
        
                    </tbody>
                </table> --}}
            </tbody>
        </table>
    </div>
</div>