<div>
    <nav class="page-breadcrumb">
        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item">
                    <a livewire:navigate href="/">{{ __('Main') }}</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    {{ __('Report Consignment') }}
                </li>
                <li class="breadcrumb-item d-flex align-items-center" aria-current="page">
                    @admin
                        <select class="form-select form-select-sm filter-it-pop" wire:model.live="whs_code"
                            style="width: auto;">
                            @foreach ($warehouse as $whs)
                                <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                            @endforeach
                        </select>
                    @else
                        <span class="me-2"> {{ __('Report') }} {{ userWarehouse() }}</span>
                    @endadmin
                </li>
            </ol>
        </div>
    </nav>
    <div class="card">
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-3">
                    <label for="startDate">Start Date</label>
                    <input type="date" class="form-control" id="startDate" wire:model.live="startDate">
                </div>
                <div class="col-md-3">
                    <label for="endDate">End Date</label>
                    <input type="date" class="form-control" id="endDate" wire:model.live="endDate">
                </div>
            </div>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <button type="button" wire:click="exportExcel" class="btn btn-primary" @if(count($invoices) === 0) disabled @endif>
                        Export Excel
                    </button>
                </div>
                <div class="d-flex align-items-center">
                    <span class="me-2">Total Records: {{ $invoices->total() }}</span>
                </div>
            </div>

            <div class="table-responsive">
                <div class="mb-3 d-flex justify-content-between">
                    <div class="d-flex align-items-center">
                        <label class="me-2">Show</label>
                        <select wire:model.live="perPage" class="form-control form-select-sm me-2">
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                        <label class="">entries</label>
                    </div>
                    <div class="d-flex align-items-center">
                        <label class="me-2">Search</label>
                        <input wire:model.live="search" type="text" class="form-control form-control-sm"
                            placeholder="Search">
                    </div>
                </div>

                

                <table class="my-table" style="width:100%">
                    <thead>
                        <tr>
                            <th scope="col" wire:click="doSort('no')" style="cursor: pointer; white-space: nowrap; border-top-left-radius: .5rem">
                                {{ __('Invoice') }}
                                @if($sortColumn === 'no')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('created_at')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Date') }}
                                @if($sortColumn === 'created_at')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" style="white-space: nowrap">{{ __('Time') }}</th>
                            <th scope="col" wire:click="doSort('users_name')" style="cursor: pointer; white-space: nowrap">
                                {{ __('User') }}
                                @if($sortColumn === 'users_name')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('sales_name')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Staff') }}
                                @if($sortColumn === 'sales_name')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" style="white-space: nowrap">{{ __('Qty') }}</th>
                            <th scope="col" wire:click="doSort('item_name')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Item Name') }}
                                @if($sortColumn === 'item_name')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('item_code')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Item Code') }}
                                @if($sortColumn === 'item_code')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('item_barcode')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Item Barcode') }}
                                @if($sortColumn === 'item_barcode')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('item_brand')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Brand') }}
                                @if($sortColumn === 'item_brand')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('item_supp')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Supplier') }}
                                @if($sortColumn === 'item_supp')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('price')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Price') }}
                                @if($sortColumn === 'price')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" style="white-space: nowrap">{{ __('Total Price') }}</th>
                            <th scope="col" wire:click="doSort('cost')" style="cursor: pointer; white-space: nowrap">
                                {{ __('Cost') }}
                                @if($sortColumn === 'cost')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                            <th scope="col" wire:click="doSort('margin')" style="cursor: pointer; white-space: nowrap; border-top-right-radius: .5rem">
                                {{ __('Margin') }}
                                @if($sortColumn === 'margin')
                                    <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                @else
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                @endif
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($invoices as $invoice)
                            <tr>
                                <td><span class="badge bg-info text-dark">{{ $invoice->no }}</span></td>
                                <td>{{ \Carbon\Carbon::parse($invoice->created_at)->format('d/m/y') }}</td>
                                <td>{{ \Carbon\Carbon::parse($invoice->created_at)->format('H:i') }}</td>
                                <td>{{ $invoice->users_name }}</td>
                                <td>{{ $invoice->sales_name }}</td>
                                <td>{{ $invoice->total_qty }}</td>
                                <td>{{ $invoice->item_name }}</td>
                                <td>{{ $invoice->item_code }}</td>
                                <td>{{ $invoice->item_barcode }}</td>
                                <td>{{ $invoice->item_brand ? $invoice->item_brand : '-' }}</td>
                                <td>{{ $invoice->item_supp ? $invoice->item_supp : '-' }}</td>
                                <td>Rp. {{ number_format($invoice->price, 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format($invoice->price * $invoice->total_qty, 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format($invoice->cost, 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format($invoice->margin, 0, ',', '.') }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="15" class="text-center">No records found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $invoices->links('vendor.livewire.bootstrap') }}
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .table th {
        background-color: #f8f9fa;
        border-bottom: 2px solid #dee2e6;
    }
    .table-hover tbody tr:hover {
        background-color: rgba(0, 123, 255, 0.05);
    }
    .badge {
        font-size: 0.9em;
    }
    .pagination {
        margin-bottom: 0;
    }
</style>
@endpush

@push('scripts')
<script>
    document.addEventListener('livewire:initialized', () => {
        @this.on('refreshDatatable', () => {
            // Any additional JavaScript functionality can be added here
        });
    });
</script>
@endpush

