<div wire:ignore.self class="modal fade modal-xl" id="modalDetail" aria-hidden="true" aria-labelledby="modalDetailLabel2"
    tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalDetailLabel2">Detail Invoice - {{ $datadetail[0]->no }} </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" wire:click="close"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th style="text-align: center">Date</th>
                            <th style="text-align: center">Staff</th>
                            <th style="text-align: center">Members</th>
                            <th style="text-align: center">Item Code</th>
                            <th style="text-align: center">Item Barcode</th>
                            <th style="text-align: center">Item Name</th>
                            <th style="text-align: center">Qty</th>
                            <th style="text-align: center">Price</th>
                            <th style="text-align: center">Disc</th>
                            <th style="text-align: center">Total Disc</th>
                            <th style="text-align: center">Sub Total</th>
                            <th style="text-align: center">Grand Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datadetail as $invoice)
                            <tr>
                                <td>{{ \Carbon\Carbon::parse($invoice->created_at)->format('d/m/y') }}</td>
                                <td>{{ $invoice->sales_name }}</td>

                                @if (isset($invoice->id_member))
                                    <td>{{ $invoice->member_name }}</td>
                                @else
                                    <td> - </td>
                                @endif

                                <td>`{{ $invoice->code }}`</td>
                                <td>`{{ $invoice->barcode }}`</td>
                                <td>{{ $invoice->name }}</td>
                                <td>{{ $invoice->qty }}</td>
                                <td>Rp. {{ number_format($invoice->nprice, 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format($invoice->nprice - $invoice->price, 0, ',', '.') }}</td>
                                <td>Rp.
                                    {{ number_format(($invoice->nprice - $invoice->price) * abs($invoice->qty), 0, ',', '.') }}
                                </td>
                                <td>Rp. {{ number_format($invoice->nprice * $invoice->qty, 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format($invoice->total_price, 0, ',', '.') }}</td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
