<div>
    @livewireStyles
    <nav class="page-breadcrumb">
        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item">
                    <a livewire:navigate href="/">{{ __('Main') }}</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    {{ __('Report') }}

                </li>
                <li class="breadcrumb-item d-flex align-items-center" aria-current="page">
                    @admin
                        <select class="form-select form-select-sm filter-it-pop" wire:model.live="whs_code"
                            style="width: auto;">
                            @foreach ($warehouse as $whs)
                                <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                            @endforeach
                        </select>
                    @else
                        <span class="me-2"> {{ __('Report') }} {{ userWarehouse() }}</span>
                    @endadmin
                </li>

            </ol>
        </div>
    </nav>
    <div class="card-body" wire:init="initializeComponent">
        <div id="cashier">
            @if ($invoiceNo)
                <livewire:report.modaldetail :datadetail="$datadetail" />
            @endif
            <div class="card-body">
                <div class="form-group row">
                    <div class="col-md-3">
                        <label for="startDate">Start Date</label>
                        <input type="date" class="form-control" id="startDate" wire:model="startDate">
                    </div>
                    <div class="col-md-3">
                        <label for="endDate">End Date</label>
                        <input type="date" class="form-control" id="endDate" wire:model="endDate">
                    </div>

                    {{-- <div x-data="{ open: false, allChecked: false }" class="col-md-2" @click.away="open = false">
                <label for="typeCardCode">Customer</label>

                <button class="form-control" x-on:click="open = ! open"
                    x-text="(allChecked ? 'All Selected' : 'Select Customer')">
                    Select Card Code
                </button>
                <div x-show.important="open" x-transition class="form-control dropdown-menu d-block py-0 w-auto px-2">
                    <div class="mt-2 ms-2 mb-2">
                        <input type="checkbox" id="selectAll" name="selectAll" x-model="allChecked"
                            wire:model="selectAll">
                        <label for="selectAllCheckbox" class="ms-2">Select All</label>
                    </div>
                    @foreach ($cardcode as $index => $crdcd)
                        <div class="ms-4">
                            <input x-bind:checked="allChecked" x-bind:hidden="allChecked" type="checkbox"
                                id="checkbox{{ $index + 1 }}" name="checkbox{{ $index + 1 }}"
                                wire:model="checkboxes.{{ $crdcd->code }}"
                                x-on:change="updateCheckboxes('{{ $crdcd->code }}')">
                            <label x-bind:hidden="allChecked" class="ms-2"
                                for="checkbox{{ $index + 1 }}">{{ $crdcd->name }} - ({{ $crdcd->code }})</label>
                        </div>
                    @endforeach
                </div>

            </div> --}}
                    <div class="col-md-2">
                        <label for="typeInvoice">Type Invoice</label>
                        <select class="form-select" wire:model="type" id="type">
                            <option value="All">All</option>
                            <option value="BJ">Sale</option>
                            <option value="RS">Return Sale</option>
                        </select>
                    </div>

                    <div class="col-md-2 mt-4">
                        <button type="button" id="filterBtn" wire:click="filterInvoices"
                            class="btn btn-primary mb-2">Filter</button>
                        <button type="button" id="clearBtn" wire:click="clearFilter"
                            class="btn btn-danger mb-2">Clear Filter</button>
                    </div>

                </div>

                <div class="col-md-4 mt-4 mb-4 d-flex gap-2">
                    <button type="button" wire:click="exportExcel"
                        class="btn btn-outline-success mb-2 d-flex gap-2 align-items-center justify-content-center">
                        <div style="width: 15px; height: auto;">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
                                stroke="currentColor" class="size-6">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                            </svg>
                        </div>

                        Excel
                    </button>
                    <button type="button" wire:click="exportARInvoiceDetail"
                        class="btn btn-outline-danger mb-2 d-flex gap-2 align-items-center justify-content-center">
                        <div style="width: 15px; height: auto;">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
                                stroke="currentColor" class="size-6">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                            </svg>
                        </div>

                        ARs
                    </button>
                    <button type="button" wire:click="exportARItemDetail"
                        class="btn btn-outline-warning mb-2 d-flex gap-2 align-items-center justify-content-center">
                        <div style="width: 15px; height: auto;">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
                                stroke="currentColor" class="size-6">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                            </svg>
                        </div>

                        Detail
                    </button>
                    {{-- @if ($loadingsap)
                <button type="button"class="btn btn-primary mb-2" disabled>
                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                        aria-hidden="true"></span>
                    <span id="innerSpan">Loading . . .</span>
                </button>
            @else
                <button type="button" data-bs-toggle="modal" data-bs-target="#modalGetSAP"
                    class="btn btn-primary mb-2">Get SAP</button>
            @endif --}}

                    {{-- @if ($syncount >= 1)
                <button type="button" data-bs-toggle="modal" data-bs-target="#modalSyncAll"
                    class="btn btn-primary mb-2">Sync All</button>
            @else
                <button type="button" class="btn btn-primary mb-2" disabled>Sync All</button>
            @endif --}}
                </div>
                <div class="table-responsive">
                    <div class="mb-3 d-flex justify-content-between">
                        <div class="d-flex align-items-center">
                            <label class="me-2">Show</label>
                            <select wire:model.live="perPage" class="form-control form-select-sm me-2">
                                <option value="10">10</option>
                                <option value="20">20</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                            <label class="">entries</label>
                        </div>
                        <div class="d-flex align-items-center">
                            <label class="me-2">Search</label>
                            <input wire:model.live="search" type="text" class="form-control form-control-sm" 
                                placeholder="Search">
                        </div>
                    </div>

                    <table class="my-table" style="width:100%">
                        <thead>
                            <tr>
                                <th style="text-align: center; border-top-left-radius: .5rem;">
                                    <a wire:click="sortBy('no')" role="button" style="cursor: pointer; text-decoration: none;">
                                        No. Invoice
                                        @if($sortField === 'no')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </a>
                                </th>
                                <th style="text-align: center;">
                                    <a wire:click="sortBy('created_at')" role="button" style="cursor: pointer; text-decoration: none;">
                                        Date
                                        @if($sortField === 'created_at')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </a>
                                </th>
                                <th style="text-align: center;">Time</th>
                                <th style="text-align: center;">
                                    <a wire:click="sortBy('users_name')" role="button" style="cursor: pointer; text-decoration: none;">
                                        Cashier
                                        @if($sortField === 'users_name')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </a>
                                </th>
                                <th style="text-align: center;">
                                    <a wire:click="sortBy('sales_name')" role="button" style="cursor: pointer; text-decoration: none;">
                                        Staff
                                        @if($sortField === 'sales_name')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </a>
                                </th>
                                <th style="text-align: center;">
                                    <a wire:click="sortBy('total_qty')" role="button" style="cursor: pointer; text-decoration: none;">
                                        Quantity
                                        @if($sortField === 'total_qty')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </a>
                                </th>
                                <th style="text-align: center;">
                                    <a wire:click="sortBy('subtotal')" role="button" style="cursor: pointer; text-decoration: none;">
                                        Subtotal
                                        @if($sortField === 'subtotal')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </a>
                                </th>
                                <th style="text-align: center;">Discount</th>
                                <th style="text-align: center;">Cashback</th>
                                @if ($isEnableService)
                                    <th style="text-align: center;">Service Percent</th>
                                    <th>Service Amount</th>
                                @endif
                                <th style="text-align: center;">Total</th>
                                <th style="text-align: center;">Cash</th>
                                <th style="text-align: center;">Card</th>
                                <th style="text-align: center; border-top-right-radius: .5rem;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $totalCash = 0;
                                $totalTransfer = 0;
                                $totalSubtotalQrisCash = 0;
                                $totalSubtotalCard = 0;
                                $totalService = 0;
                            @endphp

                            @foreach ($invoices as $invoice)
                                <tr>
                                    <td>
                                        <button data-bs-toggle="modal" data-bs-target="#exampleModal{{ $invoice['no'] }}"
                                            class="btn btn-info text-black border-white" style="border-radius: 1rem">
                                            {{ $invoice['no'] }}
                                        </button>
                                    </td>
                                    <td>{{ \Carbon\Carbon::parse($invoice['created_at'])->format('d/m/y') }}</td>
                                    <td>{{ \Carbon\Carbon::parse($invoice['created_at'])->format('H:i') }}</td>
                                    <td>{{ $invoice['users_name'] }}</td>
                                    <td>{{ $invoice['sales_name'] }}</td>
                                    <td>{{ $invoice['total_qty'] }}</td>
                                    <td>Rp. {{ number_format($invoice['subtotal'] ?? 0, 0, ',', '.') }}</td>
                                    <td>Rp. {{ number_format($invoice['disc_total'], 0, ',', '.') }}</td>
                                    @if ($invoice['cashback'] !== 'N')
                                        <td>Rp. {{ number_format($invoice['value'], 0, ',', '.') }}</td>
                                    @else
                                        <td>Rp. 0</td>
                                    @endif
                                    @if ($isEnableService)
                                        <td>{{ number_format($invoice['service_percent'], 1) }}%</td>
                                        <td>
                                            @php
                                                $totalService += $invoice['service_amount'] ?? 0;
                                            @endphp
                                            Rp. {{ number_format($invoice['service_amount'] ?? 0, 0, ',', '.') }}
                                        </td>
                                    @endif
                                    <td>Rp. {{ number_format($invoice['grandtotal'], 0, ',', '.') }}</td>

                                    @if ($invoice['payment'] === 'Multi')
                                        @php
                                            $totalCash += $invoice['cash'];
                                            $totalSubtotalCard += $invoice['transfer'];
                                        @endphp
                                        <td>Rp. {{ number_format($invoice['cash'], 0, ',', '.') }}</td>
                                        <td>Rp. {{ number_format($invoice['transfer'], 0, ',', '.') }}</td>
                                    @elseif ($invoice['payment'] === 'Cash')
                                        @php
                                            $totalCash += $invoice['grandtotal'];
                                        @endphp
                                        <td>Rp. {{ number_format($invoice['grandtotal'], 0, ',', '.') }}</td>
                                        <td>Rp. 0</td>
                                    @elseif ($invoice['payment'] === 'Qris')
                                        @php
                                            $totalSubtotalCard += $invoice['grandtotal'];
                                        @endphp
                                        <td>Rp. 0</td>
                                        <td>Rp. {{ number_format($invoice['grandtotal'], 0, ',', '.') }}</td>
                                    @elseif ($invoice['payment'] === 'Card')
                                        @php
                                            $totalSubtotalCard += $invoice['grandtotal'];
                                        @endphp
                                        <td>Rp. 0</td>
                                        <td>Rp. {{ number_format($invoice['grandtotal'], 0, ',', '.') }}</td>
                                    @else
                                        <td>Rp. 0</td>
                                        <td>Rp. 0</td>
                                    @endif

                                    <td>
                                        <button class="btn btn-primary" data-bs-toggle="modal"
                                            data-bs-target="#modalPrint{{ $invoice['no'] }}">Print</button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <div class="mt-4">
                        
                        <div>
                            {{ $paginatedData->links() }}
                        </div>
                    </div>
                </div>

                @foreach ($invoices as $invoice)
                    <!-- Print Modal -->
                    <div class="modal fade" id="modalPrint{{ $invoice['no'] }}" tabindex="-1"
                        aria-labelledby="modalPrintLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="modalPrintLabel">Print Invoice</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Are you sure want Print Receipt <span class="fw-bold">
                                            {{ $invoice['no'] }}
                                        </span> ?</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" wire:click="toPrint('{{ $invoice['no'] }}')"
                                        class="btn btn-primary" data-bs-dismiss="modal">
                                        Print</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Detail Modal -->
                    <div class="modal fade" id="exampleModal{{ $invoice['no'] }}" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">INVOICE</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body text-center">
                                    {{ $invoice['no'] }}
                                </div>
                                <div class="modal-footer">
                                    <button class="mx-2 btn btn-success" data-bs-dismiss="modal"
                                        @if ($invoice['no_inv']) wire:click="exportreturnExcelDetail('{{ $invoice['no'] }}')"
                                        @else wire:click="exportExcelDetail('{{ $invoice['no'] }}')" @endif>
                                        Export
                                    </button>
                                    <button type="button" class="btn btn-primary"
                                        data-bs-dismiss="modal"
                                        wire:click="dispatchToDetail('{{ $invoice['no'] }}')">Check</button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

                <div wire:ignore.self>
                    <table id="example" class="my-table table-striped mt-5" style="width:100%">
                        <thead>
                            <tr>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>Total Receipt</th>
                                <th>Quantity</th>
                                <th>Cash</th>
                                <th>Card</th>
                                @if ($isEnableService)
                                    <th>Total Service</th>
                                @endif
                                <th>Subtotal</th>
                                <th>Discount</th>
                                <th>Cashback</th>
                                <th>Total</th>
                                <th>Return Sale</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="5">Total</td>
                                <td></td>
                                <td>{{ count($invoices) }}</td>
                                <td>{{ collect($invoices)->sum('total_qty') }}</td>
                                <td>Rp. {{ number_format($totalCash, 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format($totalSubtotalCard, 0, ',', '.') }}</td>
                                @if ($isEnableService)
                                    <td>Rp. {{ number_format($totalService, 0, ',', '.') }}</td>
                                @endif
                                <td>Rp. {{ number_format(collect($invoices)->sum('subtotal'), 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format(collect($invoices)->sum('disc_total'), 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format(collect($invoices)->sum('value'), 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format(collect($invoices)->sum('grandtotal'), 0, ',', '.') }}</td>
                                <td>Rp. {{ number_format(collect($returnsale)->sum('price'), 0, ',', '.') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>



            {{-- <livewire:report.get-s-a-p /> --}}

            <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalNotFound" tabindex="-1"
                aria-labelledby="modalNotFoundLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="staticBackdropLabel">Alert</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            There's no data on certain period. <br>
                            The system will all data
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" id="okButton"
                                data-bs-dismiss="modal">OK</button>
                        </div>
                    </div>
                </div>
            </div>
            <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="noDataToday" tabindex="-1"
                aria-labelledby="noDataTodayLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="staticBackdropLabel">Alert</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-center">
                            There's no data available for today. <br> The system will show data from the latest
                            available
                            date.
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" id="okButton"
                                data-bs-dismiss="modal">OK</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
{{-- @foreach ($invoices as $invoice)
    <script>
        document.getElementById('invoice-{{ $invoice->no }}').addEventListener('click', function() {
            const data = '{{ $invoice->no }}';
            Livewire.dispatch('getDetailInvoice', {
                data: data
            });
        });
    </script>
@endforeach --}}
@livewireScripts
@push('scripts')
<script>
    document.addEventListener('livewire:load', function() {
        Livewire.on('refreshjs', (params) => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        });
    });

    Livewire.on('noDataToday', () => {
        $('#noDataToday').modal('show');
    });

    Livewire.on('dataNotfound', () => {
        $('#modalNotFound').modal('show');
    });

    Livewire.on('syncCompletedBrowser', () => {
        let closeButton = document.getElementById('closeSync');
        if (closeButton) {
            closeButton.click();
        }
    });

    Livewire.on('syncCompletedBrowserAll', () => {
        let closeButton = document.getElementById('closeSyncAll');
        if (closeButton) {
            closeButton.click();
        }
    });

    Livewire.on('refreshBrowser', (params) => {
        window.location.href = '{{ route('report.reportinvoicereturnsale') }}';
    });

    document.getElementById('okButton').addEventListener('click', function() {
        document.getElementById('startDate').value = ''; // Clear start date
        document.getElementById('endDate').value = ''; // Clear end date
    });

    Livewire.on('openModal', () => {
        $('#modalDetail').modal('show');
    });

    Livewire.on('closeModalweb', () => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });

        $('#modalDetail').modal('hide');
    });

    Livewire.on('toPrintBrowser', (params) => {
        var url = '{{ route('welcome.print', ':params') }}';
        url = url.replace(':params', params);
        window.open(url, '_blank');
    });
</script>
@endpush

<style>
    .pagination-wrapper nav div:first-child {
        display: none;
    }
    .pagination {
        margin-bottom: 0;
    }
    .page-item.active .page-link {
        background-color: #727cf5;
        border-color: #727cf5;
    }
    .page-link {
        cursor: pointer;
    }
    .cursor-pointer {
        cursor: pointer;
    }
</style>
</div>

