<div>
    <div class="page-content">
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div
                            class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h4 class="card-title" style="color: #1266AB">{{ __('Filter Loss Sales') }}</h6>
                        </div>

                        <div class="mb-3 form-group row">
                            <div class="col">
                                <label for="from_date">Start Date</label>
                                <input wire:model.live="from_date" type="date"
                                    class="form-control @error('from_date') is-invalid @enderror form-control-sm"
                                    id="from_date">
                                @error('from_date')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col">
                                <label for="to_date">End Date</label>
                                <input wire:model.live="to_date" type="date"
                                    class="form-control @error('to_date') is-invalid @enderror form-control-sm"
                                    id="to_date">
                                @error('to_date')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        @if (session('partner') == '')
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                        <label for="warehouse" class="form-label">{{ __('Store') }}</label>
                                        @if ($flagWhs)
                                            <button class="form-control form-control-sm text-start"
                                                x-on:click.prevent="open = !open"
                                                x-text="(allChecked ? 'All Selected' : '-- Select Store --')">
                                                -- Select Store --
                                            </button>
                                        @else
                                            <button
                                                class="form-control form-control-sm border border-danger  text-start"
                                                x-on:click.prevent="open = !open"
                                                x-text="(allChecked ? 'All Selected' : '-- Select Store --')">
                                                -- Select Store --
                                            </button>
                                            <span class="text-danger">Store is required.</span>
                                        @endif
                                        <div x-show.important="open" x-transition
                                            class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                            <div class="mt-2 ms-2 mb-2">
                                                <input type="checkbox" id="whsSelectAll" name="whsSelectAll"
                                                    x-model="allChecked" wire:model.live="whsSelectAll">
                                                <label for="selectAllCheckbox" class="ms-2">Select All</label>
                                            </div>
                                            <input type="text" x-model="search"
                                                class="form-control form-control-sm mb-2" placeholder="Search Store...">
                                            @foreach ($whs as $wh)
                                                <div class="ms-4"
                                                    x-show="containsIgnoreCase('{{ $wh->name }}', search)">
                                                    <input x:checked="allChecked && whsCheckboxes.{{ $wh->code }}"
                                                        x-bind:hidden="allChecked" type="checkbox"
                                                        id="whsCheckboxes{{ $wh->code }}"
                                                        name="whsCheckboxes{{ $wh->code }}"
                                                        wire:model="whsCheckboxes.{{ $wh->code }}"
                                                        x-on:change.live="updateWhsCheckboxes('{{ $wh->code }}')">
                                                    <label x-bind:hidden="allChecked" class="ms-2"
                                                        for="whsCheckboxes{{ $wh->code }}">{{ $wh->name }}</label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                                <div class="col"></div>
                            </div>


                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="filterby" class="form-label">{{ __('Filter') }}</label>
                                    <select wire:model.live="filterby"
                                        class="form-select @error('filterby') is-invalid @enderror form-select-sm"
                                        id="filterby">
                                        <option value="">-- {{ __('Select filter') }} --</option>
                                        @foreach ($udfs as $udf)
                                            <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                {{ $udf->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('filterby')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($filterby != '')
                                        <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                            <label class="form-label">{{ $searchby }}</label>
                                            @if ($flagFilter1)
                                                <button class="form-control form-control-sm"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby }} --')">
                                                    -- Select {{ $searchby }} --
                                                </button>
                                            @else
                                                <button class="form-control form-control-sm border border-danger"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby }} --')">
                                                    -- Select {{ $searchby }} --
                                                </button>
                                                <span class="text-danger">{{ $searchby }} is required.</span>
                                            @endif
                                            <div x-show.important="open" x-transition
                                                class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                                <div class="mt-2 ms-2 mb-2">
                                                    <input type="checkbox" id="searchSelectAll1"
                                                        name="searchSelectAll1" x-model="allChecked"
                                                        wire:model.live="searchSelectAll1">
                                                    <label class="ms-2">Select All</label>
                                                </div>
                                                <input type="text" x-model="search"
                                                    class="form-control form-control-sm mb-2"
                                                    placeholder="Search {{ $searchby }}...">
                                                @foreach ($search1 as $search)
                                                    <div class="ms-4"
                                                        x-show="containsIgnoreCase('{{ $search->name }}', search)">
                                                        <input
                                                            x:checked="allChecked && searchCheckboxes1.{{ $search->code }}"
                                                            x-bind:hidden="allChecked" type="checkbox"
                                                            id="searchCheckboxes1{{ $search->code }}"
                                                            name="searchCheckboxes1{{ $search->code }}"
                                                            wire:model="searchCheckboxes1.{{ $search->code }}"
                                                            x-on:change.live="updateSearchCheckboxes1('{{ $search->code }}')">
                                                        <label x-bind:hidden="allChecked" class="ms-2"
                                                            for="searchCheckboxes1{{ $search->code }}">{{ $search->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            @if ($filterby != '')
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="filterby2" class="form-label">{{ __('Filter II') }}</label>
                                        <select wire:model.live="filterby2"
                                            class="form-select @error('filterby2') is-invalid @enderror form-select-sm"
                                            id="filterby2">
                                            <option value="">-- {{ __('Select filter II') }} --</option>
                                            @foreach ($udf2s as $udf)
                                                <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                    {{ $udf->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('filterby2')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col">
                                        @if ($filterby2 != '')
                                            <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                                <label class="form-label">{{ $searchby2 }}</label>
                                                @if ($flagFilter2)
                                                    <button class="form-control form-control-sm"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby2 }} --')">
                                                        -- Select {{ $searchby2 }} --
                                                    </button>
                                                @else
                                                    <button class="form-control form-control-sm border border-danger"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby2 }} --')">
                                                        -- Select {{ $searchby2 }} --
                                                    </button>
                                                    <span class="text-danger">{{ $searchby2 }} is required.</span>
                                                @endif
                                                <div x-show.important="open" x-transition
                                                    class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                                    <div class="mt-2 ms-2 mb-2">
                                                        <input type="checkbox" id="searchSelectAll1"
                                                            name="searchSelectAll2" x-model="allChecked"
                                                            wire:model.live="searchSelectAll2">
                                                        <label class="ms-2">Select All</label>
                                                    </div>
                                                    <input type="text" x-model="search"
                                                        class="form-control form-control-sm mb-2"
                                                        placeholder="Search {{ $searchby2 }}...">
                                                    @foreach ($search2 as $search)
                                                        <div class="ms-4"
                                                            x-show="containsIgnoreCase('{{ $search->name }}', search)">
                                                            <input
                                                                x:checked="allChecked && searchCheckboxes2.{{ $search->code }}"
                                                                x-bind:hidden="allChecked" type="checkbox"
                                                                id="searchCheckboxes2{{ $search->code }}"
                                                                name="searchCheckboxes2{{ $search->code }}"
                                                                wire:model="searchCheckboxes2.{{ $search->code }}"
                                                                x-on:change.live="updateSearchCheckboxes2('{{ $search->code }}')">
                                                            <label x-bind:hidden="allChecked" class="ms-2"
                                                                for="searchCheckboxes2{{ $search->code }}">{{ $search->name }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            @if ($filterby != '' && $filterby2 != '')
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="filterby3" class="form-label">{{ __('Filter III') }}</label>
                                        <select wire:model.live="filterby3"
                                            class="form-select @error('filterby3') is-invalid @enderror form-select-sm"
                                            id="filterby3">
                                            <option value="">-- {{ __('Select filter III') }} --</option>
                                            @foreach ($udf3s as $udf)
                                                <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                    {{ $udf->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('filterby3')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col">
                                        @if ($filterby3 != '')
                                            <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                                <label class="form-label">{{ $searchby3 }}</label>
                                                @if ($flagFilter3)
                                                    <button class="form-control form-control-sm"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby3 }} --')">
                                                        -- Select {{ $searchby3 }} --
                                                    </button>
                                                @else
                                                    <button class="form-control form-control-sm border border-danger"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby3 }} --')">
                                                        -- Select {{ $searchby3 }} --
                                                    </button>
                                                    <span class="text-danger">{{ $searchby3 }} is required.</span>
                                                @endif
                                                <div x-show.important="open" x-transition
                                                    class="form-control dropdown-menu d-block py-0 w-auto px-3">
                                                    <div class="mt-3 ms-3 mb-3">
                                                        <input type="checkbox" id="searchSelectAll1"
                                                            name="searchSelectAll3" x-model="allChecked"
                                                            wire:model.live="searchSelectAll3">
                                                        <label class="ms-3">Select All</label>
                                                    </div>
                                                    <input type="text" x-model="search"
                                                        class="form-control form-control-sm mb-3"
                                                        placeholder="Search {{ $searchby3 }}...">
                                                    @foreach ($search3 as $search)
                                                        <div class="ms-4"
                                                            x-show="containsIgnoreCase('{{ $search->name }}', search)">
                                                            <input
                                                                x:checked="allChecked && searchCheckboxes3.{{ $search->code }}"
                                                                x-bind:hidden="allChecked" type="checkbox"
                                                                id="searchCheckboxes3{{ $search->code }}"
                                                                name="searchCheckboxes3{{ $search->code }}"
                                                                wire:model="searchCheckboxes3.{{ $search->code }}"
                                                                x-on:change.live="updateSearchCheckboxes3('{{ $search->code }}')">
                                                            <label x-bind:hidden="allChecked" class="ms-3"
                                                                for="searchCheckboxes3{{ $search->code }}">{{ $search->name }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        @else
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label class="form-label">Brand</label>
                                    <select wire:model.live="brand"
                                        class="form-control @error('brand') is-invalid @enderror form-control-sm">
                                        @foreach ($brands as $brand)
                                            <option value="{{ $brand->brand }}">{{ $brand->brand }}</option>
                                        @endforeach
                                    </select>

                                    @error('brand')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col"></div>
                            </div>

                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="filterby" class="form-label">{{ __('Filter') }}</label>
                                    <select wire:model.live="filterby"
                                        class="form-select @error('filterby') is-invalid @enderror form-select-sm"
                                        id="filterby">
                                        <option value="">-- {{ __('Select filter') }} --</option>
                                        @foreach ($udfs as $udf)
                                            <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                {{ $udf->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('filterby')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($filterby != '')
                                        <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                            <label class="form-label">{{ $searchby }}</label>
                                            @if ($flagFilter1)
                                                <button class="form-control form-control-sm"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby }} --')">
                                                    -- Select {{ $searchby }} --
                                                </button>
                                            @else
                                                <button class="form-control form-control-sm border border-danger"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby }} --')">
                                                    -- Select {{ $searchby }} --
                                                </button>
                                                <span class="text-danger">{{ $searchby }} is required.</span>
                                            @endif
                                            <div x-show.important="open" x-transition
                                                class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                                <div class="mt-2 ms-2 mb-2">
                                                    <input type="checkbox" id="searchSelectAll1"
                                                        name="searchSelectAll1" x-model="allChecked"
                                                        wire:model.live="searchSelectAll1">
                                                    <label class="ms-2">Select All</label>
                                                </div>
                                                <input type="text" x-model="search"
                                                    class="form-control form-control-sm mb-2"
                                                    placeholder="Search {{ $searchby }}...">
                                                @foreach ($search1 as $search)
                                                    <div class="ms-4"
                                                        x-show="containsIgnoreCase('{{ $search['name'] }}', search)">
                                                        <input
                                                            x:checked="allChecked && searchCheckboxes1.{{ $search['code'] }}"
                                                            x-bind:hidden="allChecked" type="checkbox"
                                                            id="searchCheckboxes1{{ $search['code'] }}"
                                                            name="searchCheckboxes1{{ $search['code'] }}"
                                                            wire:model="searchCheckboxes1.{{ $search['code'] }}"
                                                            x-on:change.live="updateSearchCheckboxes1('{{ $search['code'] }}')">
                                                        <label x-bind:hidden="allChecked" class="ms-2"
                                                            for="searchCheckboxes1{{ $search['code'] }}">{{ $search['name'] }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            @if ($filterby != '')
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="filterby2" class="form-label">{{ __('Filter II') }}</label>
                                        <select wire:model.live="filterby2"
                                            class="form-select @error('filterby2') is-invalid @enderror form-select-sm"
                                            id="filterby2">
                                            <option value="">-- {{ __('Select filter II') }} --</option>
                                            @foreach ($udf2s as $udf)
                                                <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                    {{ $udf->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('filterby2')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col">
                                        @if ($filterby2 != '')
                                            <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                                <label class="form-label">{{ $searchby2 }}</label>
                                                @if ($flagFilter2)
                                                    <button class="form-control form-control-sm"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby2 }} --')">
                                                        -- Select {{ $searchby2 }} --
                                                    </button>
                                                @else
                                                    <button class="form-control form-control-sm border border-danger"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby2 }} --')">
                                                        -- Select {{ $searchby2 }} --
                                                    </button>
                                                    <span class="text-danger">{{ $searchby2 }} is required.</span>
                                                @endif
                                                <div x-show.important="open" x-transition
                                                    class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                                    <div class="mt-2 ms-2 mb-2">
                                                        <input type="checkbox" id="searchSelectAll1"
                                                            name="searchSelectAll2" x-model="allChecked"
                                                            wire:model.live="searchSelectAll2">
                                                        <label class="ms-2">Select All</label>
                                                    </div>
                                                    <input type="text" x-model="search"
                                                        class="form-control form-control-sm mb-2"
                                                        placeholder="Search {{ $searchby2 }}...">
                                                    @foreach ($search2 as $search)
                                                        <div class="ms-4"
                                                            x-show="containsIgnoreCase('{{ $search['name'] }}', search)">
                                                            <input
                                                                x:checked="allChecked && searchCheckboxes2.{{ $search['code'] }}"
                                                                x-bind:hidden="allChecked" type="checkbox"
                                                                id="searchCheckboxes2{{ $search['code'] }}"
                                                                name="searchCheckboxes2{{ $search['code'] }}"
                                                                wire:model="searchCheckboxes2.{{ $search['code'] }}"
                                                                x-on:change.live="updateSearchCheckboxes2('{{ $search['code'] }}')">
                                                            <label x-bind:hidden="allChecked" class="ms-2"
                                                                for="searchCheckboxes2{{ $search['code'] }}">{{ $search['name'] }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            @if ($filterby != '' && $filterby2 != '')
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="filterby3" class="form-label">{{ __('Filter III') }}</label>
                                        <select wire:model.live="filterby3"
                                            class="form-select @error('filterby3') is-invalid @enderror form-select-sm"
                                            id="filterby3">
                                            <option value="">-- {{ __('Select filter III') }} --</option>
                                            @foreach ($udf3s as $udf)
                                                <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                    {{ $udf->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('filterby3')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col">
                                        @if ($filterby3 != '')
                                            <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                                <label class="form-label">{{ $searchby3 }}</label>
                                                @if ($flagFilter3)
                                                    <button class="form-control form-control-sm"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby3 }} --')">
                                                        -- Select {{ $searchby3 }} --
                                                    </button>
                                                @else
                                                    <button class="form-control form-control-sm border border-danger"
                                                        x-on:click.prevent="open = !open"
                                                        x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby3 }} --')">
                                                        -- Select {{ $searchby3 }} --
                                                    </button>
                                                    <span class="text-danger">{{ $searchby3 }} is required.</span>
                                                @endif
                                                <div x-show.important="open" x-transition
                                                    class="form-control dropdown-menu d-block py-0 w-auto px-3">
                                                    <div class="mt-3 ms-3 mb-3">
                                                        <input type="checkbox" id="searchSelectAll1"
                                                            name="searchSelectAll3" x-model="allChecked"
                                                            wire:model.live="searchSelectAll3">
                                                        <label class="ms-3">Select All</label>
                                                    </div>
                                                    <input type="text" x-model="search"
                                                        class="form-control form-control-sm mb-3"
                                                        placeholder="Search {{ $searchby3 }}...">
                                                    @foreach ($search3 as $search)
                                                        <div class="ms-4"
                                                            x-show="containsIgnoreCase('{{ $search['name'] }}', search)">
                                                            <input
                                                                x:checked="allChecked && searchCheckboxes3.{{ $search['code'] }}"
                                                                x-bind:hidden="allChecked" type="checkbox"
                                                                id="searchCheckboxes3{{ $search['code'] }}"
                                                                name="searchCheckboxes3{{ $search['code'] }}"
                                                                wire:model="searchCheckboxes3.{{ $search['code'] }}"
                                                                x-on:change.live="updateSearchCheckboxes3('{{ $search['code'] }}')">
                                                            <label x-bind:hidden="allChecked" class="ms-3"
                                                                for="searchCheckboxes3{{ $search['code'] }}">{{ $search['name'] }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        @endif

                        @if ($issearch)
                            <button type="button" class="btn btn-primary btn-sm mt-3" disabled>
                                <div class="spinner-border spinner-border-sm" role="status"></div>
                                Get Data
                            </button>
                        @else
                            <button type="button" class="btn btn-primary btn-sm mt-3"
                                wire:click.prevent="checkData">Get Data</button>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <livewire:report.analysis.loss-sales-table :tableName='$tableName' />
    </div>
</div>

@livewireScripts


@push('scripts')
    <script>
        function containsIgnoreCase(value, search) {
            return value.toLowerCase().includes(search.toLowerCase());
        }
    </script>
@endpush
