<div class="row mt-3">
    @if ($data)
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                        <h4 class="card-title" style="color: #1266AB">
                            {{ __('Report Loss Sales') }}</h6>
                            <button type="button" class="btn btn-success btn-sm"
                                wire:click.prevent="exportData">Export</button>
                    </div>

                    <div wire:ignore.self class="table-responsive">
                        <div class="mb-3 d-flex justify-content-between">
                            <div class="d-flex align-items-center">
                                <label class="me-2">Show</label>
                                <select wire:model.live="perPage" class="form-control form-select-sm me-2">
                                    <option value="10">10</option>
                                    <option value="20">20</option>
                                    <option value="50">50</option>
                                </select>
                                <label class="">entries</label>
                            </div>
                            <div class="d-flex align-items-center">
                                <label class="me-2">Search</label>
                                <input wire:model.live="search" type="text" class="form-control form-control-sm"
                                    placeholder="Search">
                            </div>
                        </div>

                        <table class="table table-striped dataTables_wrapper dt-bootstrap5" style="width:100%">
                            <thead>
                                <tr>
                                    <th scope="col" rowspan="2" class="align-middle">
                                        {{ __('Warehouse') }}</th>
                                    <th wire:click.live="doSort('code')" scope="col" rowspan="2"
                                        class="cursor-pointer align-middle">
                                        <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="Code"
                                            columnNameSort="code" />
                                    </th>
                                    {{-- <th wire:click.live="doSort('barcode')" scope="col" rowspan="2"
                                        class="cursor-pointer align-middle">
                                        <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="Barcode"
                                            columnNameSort="barcode" />
                                    </th> --}}
                                    <th wire:click.live="doSort('name')" scope="col" rowspan="2"
                                        class="cursor-pointer align-middle">
                                        <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="Name"
                                            columnNameSort="name" />
                                    </th>
                                    <th wire:click.live="doSort('salestotal')" scope="col" rowspan="2"
                                        class="cursor-pointer align-middle text-center">
                                        <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="Total Sales"
                                            columnNameSort="salestotal" />
                                    </th>
                                    <th wire:click.live="doSort('stocknullcount')" scope="col" rowspan="2"
                                        class="cursor-pointer align-middle text-center">
                                        <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="Stock 0 Days"
                                            columnNameSort="stocknullcount" />
                                    </th>
                                    <th wire:click.live="doSort('losssales')" scope="col" rowspan="2"
                                        class="cursor-pointer align-middle text-center">
                                        <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="Loss Sales"
                                            columnNameSort="losssales" />
                                    </th>
                                    @foreach ($dates as $date)
                                        <th scope="col" colspan="2" class="text-center">
                                            {{ \Carbon\Carbon::parse($date)->format('j F Y') }}</th>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach ($dates as $date)
                                        <th scope="col" class="text-center">
                                            {{ __('Sales') }}</th>
                                        <th scope="col" class="text-center">
                                            {{ __('Stock') }}</th>
                                    @endforeach
                                </tr>
                            </thead>

                            <tbody>
                                @php
                                    $subtotal_losssales = 0;
                                @endphp
                                @foreach ($data as $item)
                                    <tr>
                                        <td scope="col">{{ Str::limit(strip_tags($item->whs), 50) }}</td>
                                        <td scope="col">{{ $item->code }}</td>
                                        {{-- <td scope="col">{{ $item->barcode }}</td> --}}
                                        <td scope="col">{{ Str::limit(strip_tags($item->name), 50) }}</td>
                                        <td scope="col" class="text-center">{{ number_format($item->salestotal) }}
                                        <td scope="col" class="text-center">
                                            {{ number_format($item->stocknullcount) }}
                                        <td scope="col" class="text-center">{{ number_format($item->losssales) }}
                                        </td>
                                        @foreach ($dates as $date)
                                            @php
                                                $formattedDate = \Carbon\Carbon::parse($date)->format('ymd');
                                                $salesColumn = 'sales' . $formattedDate;
                                                $stockColumn = 'stock' . $formattedDate;
                                            @endphp

                                            <td scope="col" class="text-center">
                                                {{ number_format($item->$salesColumn) }}
                                            </td>
                                            <td scope="col" class="text-center">
                                                {{ number_format($item->$stockColumn) }}
                                            </td>
                                        @endforeach
                                    </tr>

                                    @php
                                        $subtotal_losssales += $item->losssales;
                                    @endphp
                                @endforeach
                            </tbody>

                            <tfoot>
                                <tr>
                                    <td colspan="5">Subtotal</td>
                                    <td class="text-center">{{ number_format($subtotal_losssales) }}</td>
                                </tr>
                                <tr>
                                    <th colspan="5">Total</th>
                                    <th class="text-center">{{ number_format($total_losssales) }}</th>
                                </tr>
                            </tfoot>
                        </table>

                        @if ($data)
                            <div class="py-4 px-3">
                                {{ $data->links('vendor.livewire.bootstrap') }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
