<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">{{ __('Home') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Promo') }}
                    </li>
                </ol>
            </div>
        </nav>

        <div class="row" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="d-flex justify-content-end">
                    <button wire:click="promo" type="button" class="btn btn-primary btn-sm add-promo-pop"
                    @admin @else disabled
                    @endadmin>{{ __('+ Add') }}</button>
            </div>
            <div class="">
                <div class="card-body">
                    {{-- <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h4 class="card-title" style="color: #1266AB">{{ __('Promo') }}</h6>
                        </div> --}}

                    <livewire:promo.promo-table />
                </div>
            </div>
        </div>
    </div>
</div>
</div>

@if ($istutorials)
<script>
    const promoPopup = () => {
        const driver = window.driver.js.driver;
        const driverObj = driver({
            showProgress: true,
            steps: [
                // {
                //     element: '.pricelist-pop',
                //     popover: {
                //         description: 'Menu Supplier memungkinkan Anda untuk mengelola informasi semua pemasok.'
                //     }
                // },
                {
                    element: '.promo-pop',
                    popover: {
                        description: 'Here, you can view the list of active/inactive promos, add new promos, or update existing promo information.'
                    }
                },
                {
                    element: '.filter-promo-pop',
                    popover: {
                        description: 'Use Promo Status to filter the promo list based on their status, whether active or inactive. Select the desired status to view relevant promos.'
                    }
                },
                {
                    element: '.add-promo-pop',
                    popover: {
                        description: 'Next, you can click the Add button to add a new promo.'
                    }
                },
                {
                    element: '.go--pop',
                    popover: {
                        description: '......'
                    }
                },
            ],
            onDeselected: () => {
                $.ajax({
                    type: "POST",
                    url: '/update-status-driver',
                    data: {
                        menu: "Promo",
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(data) {
                    },
                    error: function(data, textStatus, errorThrown) {
                    },
                });
            }
        });

        driverObj.drive();
    }

</script>
@endif
