<div class="table-responsive">
    <table id="table" class="my-table table-striped dataTables_wrapper dt-bootstrap5" style="width:100%">
        <thead>
            <tr>
                <th scope="col" style="border-top-left-radius: .5rem">#</th>
                @if ($tipe == 6)
                <th scope="col">{{ __('Voucher No') }}</th>
                <th scope="col">{{ __('Voucher Value') }}</th>
                @else
                @if ($tipe == 3 || $tipe == 4)
                <th scope="col">{{ __('Pack') }}</th>
                @endif
                <th scope="col">{{ __('ItemCode') }}</th>
                <th scope="col">{{ __('CodeBars') }}</th>
                <th scope="col">{{ __('ItemName') }}</th>
                @if ($tipe == 1)
                <th scope="col">{{ __('Discount (%)') }}</th>
                @elseif ($tipe == 2)
                <th scope="col">{{ __('Special Price') }}</th>
                @endif
                @endif
                <th scope="col" style="border-top-right-radius: .5rem">{{ __('Action') }}</th>
            </tr>
        </thead>

        <tbody>
            @foreach($items as $item)
            @if ($tipe == 6)
            <tr wire:key='{{ $item->voucher }}'>
                <td scope="col">{{ $loop->iteration }}</td>
                <td scope="col">{{ $item->voucher }}</td>
                <td scope="col">{{ number_format($item->value) }}</td>
                <td>
                     {{-- <button wire:click="editItem('{{ $item->voucher }}')" type="button" class="btn btn-primary content-end" style="padding: 5px 10px; font-size: 12px;" onclick="window.scrollTo(0, 0);"> --}}
                    <button onclick="handleEditItem('{{ $item->voucher }}');" type="button" class="btn btn-primary content-end" style="padding: 5px 10px; font-size: 12px;" onclick="window.scrollTo(0, 0);">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                            <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                            <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                        </svg>
                    </button>
                    <button type="button" class="btn btn-danger content-end delete-promo" style="padding: 5px 10px; font-size: 12px;" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $item->voucher }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                            <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                            <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                        </svg>
                    </button>
                </td>
            </tr>

            <div wire:ignore.self class="modal fade" id="deleteModal{{ $item->voucher }}" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel">{{ __('Confirmation') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                        </div>
                        <div class="modal-body">
                            {{ __('Are you sure you want to delete this voucher?') }}
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button wire:click="deleteVoucher('{{ $item->voucher }}')" type="submit" class="btn btn-danger" id="confirm-delete" data-bs-dismiss="modal">{{ __('Delete') }}</button>
                        </div>
                    </div>
                </div>
            </div>
            @else
            <tr wire:key='{{ $item->item_code }}'>
                <td scope="col">{{ $loop->iteration }}</td>
                @if ($item->tipe == 3 || $tipe == 4)
                <td>{{ $item->pack }}</td>
                @endif
                <td>{{ $item->item_code }}</td>
                <td>{{ $item->item_barcode }}</td>
                <td>{{ $item->item_name }}</td>
                @if ($item->tipe == 1)
                <td>{{ number_format($item->disc) }}</td>
                @elseif ($item->tipe == 2)
                <td>{{ number_format($item->disc_price) }}</td>
                @endif
                <td>
                    @if ($tipe != 7)
                    <!-- <button wire:click="editItem('{{ $item->item_code }}')" type="button" class="btn btn-primary content-end" style="padding: 5px 10px; font-size: 12px;" onclick="window.scrollTo(0, 0);"> -->
                    <button onclick="handleEditItem('{{ $item->item_code }}');" type="button" class="btn btn-primary content-end" style="padding: 5px 10px; font-size: 12px;" onclick="window.scrollTo(0, 0);">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                            <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                            <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                        </svg>
                    </button>

                    @endif
                    <button type="button" class="btn btn-danger content-end delete-promo" style="padding: 5px 10px; font-size: 12px;" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $item->item_code }}{{ $item->pack }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                            <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                            <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                        </svg>
                    </button>
                </td>
            </tr>

            <div wire:ignore.self class="modal fade" id="editModal{{ $item->item_code }}{{ $item->pack }}" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="editModalLabel">{{ __('Confirmation') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                        </div>
                        <div class="modal-body">
                            {{ __('Are you sure you want to edit selected item?') }}
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button wire:click="editItem('{{ $item->item_code }}')" type="submit" class="btn btn-primary" id="confirm-edit" data-bs-dismiss="modal">{{ __('Edit') }}</button>
                        </div>
                    </div>
                </div>
            </div>

            <div wire:ignore.self class="modal fade" id="deleteModal{{ $item->item_code }}{{ $item->pack }}" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel">{{ __('Confirmation') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                        </div>
                        <div class="modal-body">
                            {{ __('Are you sure you want to delete selected item?') }}
                        </div>
                        <!-- <form> -->
                        <!-- @csrf -->
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button wire:click="delete('{{ $item->item_code }}', '{{ $item->pack }}')" type="submit" class="btn btn-danger" id="confirm-delete" data-bs-dismiss="modal">{{ __('Delete') }}</button>
                        </div>
                        <!-- </form> -->
                    </div>
                </div>
            </div>
            @endif
            @endforeach
        </tbody>
    </table>
</div>