<div wire:ignore.self data-bs-backdrop="static" class="modal fade" id="detailModal" tabindex="-1"
    aria-labelledby="detailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-m modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">
                    @if ($tipe == 6)
                        {{ __('Input Voucher') }}
                    @else
                        {{ __('Input Item Promo') }}
                    @endif
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
            </div>
            @if ($tipe == 6)
                <div class="modal-body" style="overflow-y: auto;">
                @else
                    <div class="modal-body" style="overflow-y: auto; height: 400px;">
            @endif

            @if ($tipe == 6)
                <div>
                    <div class="mb-3 form-group row">
                        <div class="col">
                            <label for="create_by" class="form-label">{{ __('Create by') }}</label>
                            <select wire:model.live="create_by" class="form-control form-select-sm" id="create_by">
                                <option value="1">{{ __('Voucher') }}</option>
                                <option value="2">{{ __('Batch') }}</option>
                            </select>
                        </div>
                        <div class="col"></div>
                    </div>

                    <div class="mb-3 form-group row">
                        <div class="col">
                            @if ($create_by == 1)
                                <label for="create_by_voucher_no" class="form-label">Voucher No</label>
                                @if ($errorDetail == '')
                                    <input type="text" wire:model.live="create_by_voucher_no"
                                        class="form-control form-control-sm @error('create_by_voucher_no') is-invalid @enderror"
                                        id="create_by_voucher_no" @if ($editItem) disabled @endif>
                                    @error('create_by_voucher_no')
                                        <span class=" text-danger">{{ $message }}</span>
                                    @enderror
                                @else
                                    <input type="text" wire:model.live="create_by_voucher_no"
                                        class="form-control form-control-sm is-invalid" id="create_by_voucher_no"
                                        @if ($editItem) disabled @endif>
                                @endif
                            @else
                                <label for="create_by_voucher_batch" class="form-label">Number of Vouchers</label>
                                <input type="text" wire:model.live="create_by_voucher_batch"
                                    class="form-control form-control-sm @error('create_by_voucher_batch') is-invalid @enderror"
                                    id="create_by_voucher_batch">
                                @error('create_by_voucher_batch')
                                    <span class=" text-danger">{{ $message }}</span>
                                @enderror
                            @endif
                            @if ($create_by == 1 && $errorDetail != '')
                                <span class="text-danger">{{ $errorDetail }}</span>
                            @endif
                        </div>
                        <div class="col">
                            <label for="create_by_voucher_value" class="form-label">Voucher Value</label>
                            <input type="number" wire:model.live="create_by_voucher_value"
                                class="form-control form-control-sm @error('create_by_voucher_value') is-invalid @enderror"
                                id="create_by_voucher_value">
                            @error('create_by_voucher_value')
                                <span class=" text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
            @else
                <div>
                    <div class="mb-3 form-group row">
                        <div class="col">
                            <label for="search_by" class="form-label">{{ __('Search by') }}</label>
                            <select wire:model.live="search_by" class="form-control form-select-sm" id="search_by">
                                <option value="1">{{ __('ItemCode') }}</option>
                                <option value="2">{{ __('CodeBars') }}</option>
                            </select>
                        </div>
                        <div class="col">
                            @if ($tipe == 3 || $tipe == 4)
                                <div x-data="{ open: false, allChecked: false }" class="col" @click.away="open = false">
                                    <label for="pack" class="form-label">{{ __('Promo Pack') }}</label>
                                    @if ($flagPack)
                                        <button class="form-control form-control-sm" x-on:click.prevent="open = ! open"
                                            x-text="(allChecked ? 'All Selected' : 'Select Pack')">
                                            Select Pack
                                        </button>
                                    @else
                                        <button class="form-control form-control-sm border border-danger"
                                            x-on:click.prevent="open = ! open"
                                            x-text="(allChecked ? 'All Selected' : 'Select Pack')">
                                            Select Pack
                                        </button>
                                        <span class="text-danger">The promo pack is required.</span>
                                    @endif
                                    <div x-show.important="open" x-transition
                                        class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                        <div class="mt-2 ms-2 mb-2">
                                            <input type="checkbox" id="packSelectAll" name="packSelectAll"
                                                x-model="allChecked" wire:model.live="packSelectAll">
                                            <label for="selectAllCheckbox" class="ms-2">Select All</label>
                                        </div>
                                        @for ($i = 1; $i <= $qty_pack; $i++)
                                            <div class="ms-4">
                                                <input x-bind:checked="allChecked" x-bind:hidden="allChecked"
                                                    type="checkbox" id="packCheckboxes{{ $i }}"
                                                    name="packCheckboxes{{ $i }}"
                                                    wire:model.live="packCheckboxes.{{ $i }}"
                                                    x-on:change.live="updatePackCheckboxes('{{ $i }}')">
                                                <label x-bind:hidden="allChecked" class="ms-2"
                                                    for="packCheckboxes{{ $i }}">{{ $i }}</label>
                                            </div>
                                        @endfor
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 form-group row">
                        <div class="col">
                            <label for="item_code" class="form-label">ItemCode {{ $item_barcode }}</label>
                            <input type="text" wire:model="item_barcode" class="form-control form-control-sm">
                            <div class="input-group">
                                @if ($search_by == 1)
                                    @if ($errorDetail == '')
                                        <input type="text" wire:model="item_code"
                                            class="form-control form-control-sm" id="item_code">
                                    @else
                                        <input type="text" wire:model="item_code"
                                            class="form-control form-control-sm is-invalid" id="item_code">
                                    @endif
                                @else
                                    <input type="text" wire:model="item_code" class="form-control form-control-sm"
                                        id="item_code" disabled>
                                @endif
                                @if ($search_by == 1)
                                    @if ($search_code)
                                        <button type="button" class="btn btn-primary btn-sm" disabled>
                                            <div class="spinner-border spinner-border-sm text-light" role="status">
                                            </div>
                                            Search
                                        </button>
                                    @else
                                        <button wire:click.prevent="searchFlagTrue" type="button"
                                            class="btn btn-primary btn-sm">Search</button>
                                    @endif
                                @endif
                            </div>
                            @if ($search_by == 1 && $errorDetail != '')
                                <span class="text-danger">{{ $errorDetail }}</span>
                            @endif
                        </div>
                        <div class="col">
                            <label for="item_barcode" class="form-label">CodeBars</label>
                            <div class="input-group">
                                @if ($search_by == 2)
                                    @if ($errorDetail == '')
                                        <input type="text" wire:model="item_barcode"
                                            class="form-control form-control-sm">
                                    @else
                                        <input type="text" wire:model="item_barcode"
                                            class="form-control form-control-sm is-invalid">
                                    @endif
                                @else
                                    <input type="text" class="form-control form-control-sm"
                                        value="{{ $item_barcode }}">
                                @endif
                                @if ($search_by == 2)
                                    @if ($search_barcode)
                                        <button type="button" class="btn btn-primary btn-sm" disabled>
                                            <div class="spinner-border spinner-border-sm text-light" role="status">
                                            </div>
                                            Search
                                        </button>
                                    @else
                                        <button wire:click.prevent="searchFlagTrue" type="button"
                                            class="btn btn-primary btn-sm">Search</button>
                                    @endif
                                @endif
                            </div>
                            @if ($search_by == 2 && $errorDetail != '')
                                <span class="text-danger">{{ $errorDetail }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">ItemName</label>
                        <input type="text" class="form-control form-control-sm" value="{{ $item_name }}"
                            disabled>
                    </div>

                    @if ($tipe == 1 || $tipe == 2)
                        <div class="mb-3 form-group row">
                            <div class="col">
                                <div class="mb-3">
                                    <label for="item_nprice" class="form-label">Price</label>
                                    <input wire:model.live="item_nprice" class="form-control form-control-sm"
                                        id="item_nprice" x-mask:dynamic="$money($input, '.')" disabled>
                                </div>
                            </div>

                            <div class="col">
                                @if ($tipe == 1)
                                    <div class="mb-3">
                                        <label for="item_disc" class="form-label">Discount (%)</label>
                                        <input wire:model.live="item_disc"
                                            class="form-control @error('item_disc') is-invalid @enderror form-control-sm"
                                            id="item_disc" x-mask:dynamic="$money($input, '.')"
                                            @if ($item_code == '') disabled @endif>
                                        @error('item_disc')
                                            <span class=" text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                @elseif ($tipe == 2)
                                    <div class="mb-3">
                                        <label for="item_price" class="form-label">Special Price</label>
                                        <input wire:model.live="item_price"
                                            class="form-control @error('item_price') is-invalid @enderror form-control-sm"
                                            id="item_price" x-mask:dynamic="$money($input, '.')">
                                        @error('item_price')
                                            <span class=" text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                @endif
                            </div>
                        </div>

                        <div class="mb-3">
                            <input type="checkbox" wire:model.live="item_qty_check" class="form-check-input"
                                id="item_qty_check">
                            @if ($tipe == 1)
                                <label for="item_qty_check"
                                    class="form-check-label">{{ __('Input Discount (%) by Qty') }}</label>
                            @else
                                <label for="item_qty_check"
                                    class="form-check-label">{{ __('Input Special Price by Qty') }}</label>
                            @endif
                        </div>

                        @if ($item_qty_check)
                            <div class="mb-3">
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="item_qty_qty" class="form-label">Qty</label>
                                        <div class="input-group">
                                            <input wire:model.live="item_qty_qty" class="form-control form-control-sm"
                                                id="item_qty_qty" x-mask:dynamic="$money($input, '.')">
                                            @error('item_qty_qty')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col">
                                        @if ($tipe == 1)
                                            <label for="item_qty_disc" class="form-label">Discount (%)</label>
                                            <div class="input-group">
                                                <input wire:model.live="item_qty_disc"
                                                    class="form-control form-control-sm" id="item_qty_disc"
                                                    x-mask:dynamic="$money($input, '.')">
                                                @error('item_qty_disc')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                                <a type="button" class="btn btn-primary btn-sm"
                                                    wire:click.prevent="addQty">Add</a>
                                            </div>
                                        @else
                                            <label for="item_qty_price" class="form-label">Special Price</label>
                                            <div class="input-group">
                                                <input wire:model.live="item_qty_price"
                                                    class="form-control form-control-sm" id="item_qty_price"
                                                    x-mask:dynamic="$money($input, '.')">
                                                @error('item_qty_price')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                                <a type="button" class="btn btn-primary btn-sm"
                                                    wire:click.prevent="addQty">Add</a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <livewire:promo.promo-add-item-qty :tipe="$tipe" :item_code="$item_code" />
                            </div>
                        @endif
                    @endif
                </div>
            @endif
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
            <button wire:click.prevent="addList" class="btn btn-primary">
                @if ($editItem)
                    Update to List
                @else
                    Add to List
                @endif
            </button>
        </div>
    </div>
</div>
</div>

@livewireScripts
<script>
    $(document).ready(function() {
        if ($.fn.dataTable.isDataTable('#tableDetail')) {
            $('#tableDetail').DataTable().destroy();
        }

        $('#tableDetail').DataTable({
            "lengthMenu": [
                [10, 25, 50, 100, -1],
                [10, 25, 50, 100, "All"]
            ]
        });
    });
</script>
