<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Compare SO') }}
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Detail') }}
                    </li>
                </ol>
            </div>
        </nav>

        <div class="" id="cashier">
            <div class="col-md-12 grid-margin">
                <div class="button-top-right">
                    <button type="button" wire:click="export" class="btn btn-primary btn-sm ml-4">Export
                        Difference</button>
                    <button type="button" wire:click="exportNoDiff" class="btn btn-primary btn-sm ml-4">Export No
                        Difference</button>

                    <button wire:click="close" type="button"
                        class="btn btn-secondary btn-sm ml-4">{{ __('Close') }}</button>
                </div>
                <div class="">
                    <div class="card p-3 mb-3">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Compare SO Result') }}</h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Date : ') }} <span
                                    class="">{{ $opnameh->date ?? '' }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Store : ') }} <span
                                    class="">{{ $opnameh->whs_name ?? '' }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Remark : ') }} <span
                                    class="">{{ $opnameh->remark ?? '' }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Type : ') }}
                                <span>{{ $opnames->first()->type ?? '' }}</span>
                            </h6>
                        </div>
                        
                    </div>

                    <div>
                        <div class="py-12">
                            <div class="table-responsive table-opname-result">
                                <table id="example" class="my-table dataTables_wrapper dt-bootstrap5"
                                    style="width:100%; ">
                                    <thead>
                                        <tr>
                                            <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                            <th scope="col">{{ __('Code') }}</th>
                                            <th scope="col">{{ __('Barcode') }}</th>
                                            <th scope="col">{{ __('Name') }}</th>
                                            <th scope="col">{{ __('Price') }}</th>
                                            <th scope="col">{{ __('Qty') }}</th>
                                            <th scope="col">{{ __('Opname') }}</th>
                                            <th scope="col" style="border-top-right-radius: 1rem">
                                                {{ __('Difference') }}</th>
                                        </tr>
                                    </thead>

                                    <tbody class="small">
                                        @foreach ($opnames as $key => $opname)
                                            <tr>
                                                <th scope="col">{{ $key + 1 }}</td>
                                                <td>{{ $opname->item_code }}</td>
                                                <td>{{ $opname->item_barcode }}</td>
                                                <td>{{ $opname->item_name }}</td>
                                                <td>{{ number_format($opname->price) }}</td>
                                                <td>{{ number_format($opname->qty) }}</td>
                                                <td>{{ number_format($opname->opname) }}</td>
                                                <td>{{ number_format($opname->difference) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script>
        Livewire.on('refreshDatatable', (params) => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        });
    </script>
</div>
