<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Setting DoH</h1>
        <a href="{{ route('setting-moh-list') }}" class="btn btn-secondary">Back</a>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <form wire:submit.prevent="updateSettings">
        <div class="card">
            <div class="card-body">
                <div class="form-group">
                    <label for="code">Code</label>
                    <input type="text" class="form-control" id="code" wire:model="code" readonly disabled>
                </div>
                <div class="form-group">
                    <label for="name">Name</label>
                    <input type="text" class="form-control" id="name" wire:model="name" readonly disabled>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="moh">Day of Hand</label>
                            <input type="number" class="form-control @error('moh') is-invalid @enderror" id="moh"
                                wire:model="moh" placeholder="Enter DoH">
                            @error('moh')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="min_display">Min Display</label>
                            <input type="number" class="form-control @error('min_display') is-invalid @enderror"
                                id="min_display" wire:model="min_display" placeholder="Enter Min Display">
                            @error('min_display')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-primary mt-3">Save</button>
    </form>
</div>
