<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="py-12 mt-2">
        <div class="header" x-data="{ isInputGroupVisible: false }"
            @keydown.window="if ($event.ctrlKey && ($event.key === 'ArrowRight' || $event.key === 'ArrowLeft')) { 
            isInputGroupVisible = !isInputGroupVisible; 
            @this.call('changeTable'); 
        }">
            <div class="form-check" wire:click="changeTable" @click="isInputGroupVisible = !isInputGroupVisible"
                data-toggle="tooltip" title="Click to show/hide">
                <button class="badge bg-primary">
                    @if ($isTable)
                        Add
                    @else
                        Show Table
                    @endif
                </button>
            </div>
            <div class="mb-4" x-show="isInputGroupVisible">

                @if (!$chunks)
                    <div style="display: flex; justify-content: end">
                        <a data-bs-target="#modalCreate" data-bs-toggle="modal"
                            class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3 mb-3">Add Item PriceList</a>
                    </div>
                    <div class="card p-3">
                        <label for="importFile" class="form-label">{{ __('Import File') }} <span
                                class="text-danger">*.csv</span>
                        </label>
                        <input wire:model="file" type="file"
                            class="form-control @error('file') is-invalid @enderror form-control-md" id="importFile"
                            name="importFile" accept=".csv">
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div>
                            <button wire:click="importItem" type="button"
                                class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                                @if (!$file) disabled @endif>{{ __('Import') }}
                            </button>
                        </div>
                    </div>
                @endif
                @if ($chunks)
                    @if (!$editChunks)
                        <button class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="saveChunks">Save</button>
                    @endif
                    @if ($editChunks)
                        <button class="btn btn-success btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEdit">Save
                            Edit</button>
                    @else
                        <button class="btn btn-warning btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEdit">
                            Edit</button>
                    @endif
                    <button class="btn btn-secondary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                        wire:click="cancelImport">Cancel</button>
                @endif
                <div class="table-responsive table-member-tablet mt-4">
                    @if ($chunks)
                        <table class="my-table" @if (!$editChunks) id="example" @endif
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th style="text-align: center">No</th>
                                    <th style="text-align: center">Item Code</th>
                                    <th style="text-align: center">Pricelist Code</th>
                                    <th style="text-align: center">Price</th>

                                </tr>
                            </thead>
                            <tbody>
                                @if ($editChunks)
                                    @foreach ($chunks as $index => $item)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.item_code">
                                            </td>

                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.pricelist_code">
                                            </td>

                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.price">
                                            </td>

                                        </tr>
                                    @endforeach
                                @else
                                    @foreach ($chunks as $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>

                                            <td>{{ $item['item_code'] }}</td>
                                            <td>{{ $item['pricelist_code'] }}</td>

                                            <td>{{ $item['price'] }}</td>

                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>
        </div>
        @if ($isTable)
            <div class="table-responsive table-member-tablet mt-4">
                <table class="my-table" id="example" style="width:100%">
                    <thead>
                        <tr>
                            <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                            <th style="text-align: center">Item Code</th>
                            <th style="text-align: center">Pricelist Code</th>
                            <th style="text-align: center">Price</th>
                            <th style="text-align: center; border-top-right-radius: .5rem">Action</th>


                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($itemPricelist as $item)
                            <tr>
                                <td style="text-align: center">{{ $loop->iteration }}</td>
                                <td>{{ $item->item_code }}</td>
                                <td>{{ $item->pricelist_code }}</td>
                                <td>{{ $item->price }}</td>
                                <td style="text-align: center">
                                    <div type="button"
                                        onclick="handleEditItemPricelist('{{ $item->item_code }}', '{{ $item->pricelist_code }}')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" width="22px" height="22px">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                        </svg>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        @endif
    </div>
    <div wire:ignore.self class="modal fade " id="modalCreate" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Buat Price di : {{ userWarehouse() }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    @if ($errMsg != '')
                        <small class="text-danger d-block mt-1"> {{ $errMsg }}</small>
                    @endif
                    {{-- @admin
                        <div class="form-group">
                            <label for="whs_code">Warehouse</label>
                            <select wire:model.live="whs_code" id="whs_code" class="form-select">
                                @foreach ($warehouses as $warehouse)
                                    <option value="{{ $warehouse->code }}">{{ $warehouse->name }}</option>
                                @endforeach
                            </select>
                            @error('whs_code')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endadmin --}}
                    <div class="form-group">
                        <label for="item_code">Item Code</label>
                        <input type="text" wire:model.live="item_code" id="item_code" class="form-control mb-2">
                        @error('item_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="pricelist_code">Pricelist Code</label>
                        <select class="form-select mb-2" wire:model.live="pricelist_code">
                            <option value="">-- Select Pricelist --</option>
                            @foreach ($Pricelist as $pl)
                                <option value="{{ $pl->code }}">{{ $pl->code }}</option>
                            @endforeach
                        </select>
                        @error('pricelist_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="price">Price</label>
                        <input type="number" wire:model.live="price" id="price" class="form-control mb-2">
                        @error('price')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $price == '' || $errMsg != '') disabled @endif
                        wire:click="save">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade " id="modalEditPricelistItem" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Pricelist </span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    {{-- @admin
                        <div class="form-group">
                            <label for="whs_code">Warehouse</label>
                            <select wire:model.live="whs_code" id="whs_code" class="form-select" disabled>
                                @foreach ($warehouses as $warehouse)
                                    <option value="{{ $warehouse->code }}">{{ $warehouse->name }}</option>
                                @endforeach
                            </select>
                            @error('whs_code')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endadmin --}}
                    <div class="form-group">
                        <label for="item_code">Item Code</label>
                        <input type="text" value="{{ $selectedItemCode }}" class="form-control mb-2" disabled>
                    </div>
                    <div class="form-group">
                        <label for="pricelist_code">Pricelist Code</label>
                        <input type="text" value="{{ $selectedItemPricelistCode }}" class="form-control mb-2"
                            disabled>

                    </div>
                    <div class="form-group">
                        <label for="price">Old Price</label>
                        <input type="text" value="{{ $selectedItemPrice }}" class="form-control mb-2" disabled>

                    </div>
                    <div class="form-group">
                        <label for="price">New Price</label>
                        <input type="number" wire:model.live="pricenew" id="price" class="form-control mb-2">
                        @error('pricenew')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="refreshjs"
                        data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $pricenew == '' || $errMsg != '') disabled @endif
                        wire:click="update">Save</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.shiftKey && event.key === 'N') {
                event.preventDefault();
                $('#modalCreate').modal('show');
            }
        });
    </script>
</div>
