<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            height: 50px;
        }
    </style>
    <div class="pricelist-page py-12 mt-2">
        <div class="header" x-data="{ isInputGroupVisible: false }"
            @keydown.window="if ($event.ctrlKey && ($event.key === 'ArrowRight' || $event.key === 'ArrowLeft')) { 
            isInputGroupVisible = !isInputGroupVisible; 
            @this.call('changeTable'); 
        }"
            @success-import.window="isInputGroupVisible = false">
            <div class="d-flex justify-content-start">
                <div class="form-check" wire:click="changeTable" @click="isInputGroupVisible = !isInputGroupVisible"
                    data-toggle="tooltip" title="Click to show/hide">
                    <button class="btn btn-sm mb-4 add-product-pop"
                        style="background: #ee32ff1f; color: #ee32ff; border-radius: 1rem">
                        @if ($isTable)
                            + Add
                        @else
                            <div class="d-flex justify-content-center gap-1 align-items-center">
                                <div style="width: 17px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                    </svg>
                                </div>
                                Table
                            </div>
                        @endif
                    </button>
                </div>
            </div>

            <div class="mb-4" x-show="isInputGroupVisible">
                @if (!$chunks)
                    <div style="display: flex; justify-content: end">
                        <a data-bs-target="#modalCreate" data-bs-toggle="modal"
                            class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3 mb-3">+ Add Pricelist</a>
                    </div>
                    <div class="p-4" style="border: 1px dashed rgba(46, 46, 46, 0.288); border-radius: .5rem">
                        <div class="fs-4 fw-semibold mb-2">
                            Import File
                        </div>
                        <label for="importFile" class="form-label">{{ __('Supported formats') }} <span
                                class="text-danger">*.csv, *.xlsx</span>
                        </label>
                        <input wire:model="file" type="file"
                            class="form-control @error('file') is-invalid @enderror form-control-md" id="importFile"
                            name="importFile" accept=".csv, .xlsx"
                            style="background: transparent; border-radius: .5rem">
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="d-flex justify-content-end gap-2 mt-3">
                            <button wire:click="importItem" type="button"
                                class="btn btn-success btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                @if (!$file) disabled @endif>
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                                    </svg>
                                </div>{{ __('Import') }}
                            </button>
                            <button type="button"
                                class="btn btn-outline-secondary btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                onclick="window.location.href='/assets/template/Template Pricelist.csv'">
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                    </svg>
                                </div> {{ __(' Download Template') }}
                            </button>
                        </div>
                    </div>
                @endif

                @if ($chunks)
                    @if (!$editChunks)
                        <button class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="saveChunks">Save</button>
                    @endif
                    @if ($editChunks)
                        <button class="btn btn-success btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="modeEditFalse">Save
                            Edit</button>
                    @else
                        <button class="btn btn-warning btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEditTrue">
                            Edit</button>
                    @endif
                    <button class="btn btn-secondary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                        wire:click="cancelImport">Cancel</button>

                    @if ($this->hasDuplicates)
                        <div class="d-flex justify-content-end gap-2 mb-3">
                            <button wire:click="downloadDuplicates('xlsx')"
                                class="btn btn-sm btn-outline-primary rounded-3">
                                <i class="fas fa-file-excel me-1"></i> Export Duplicate Data
                            </button>

                        </div>
                    @endif

                    <div class="table-responsive table-member-tablet mt-4">
                        <table class="my-table" @if (!$editChunks) id="example" @endif>
                            <thead>
                                <tr>
                                    <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                                    <th>Code</th>
                                    <th style="text-align: center; border-top-right-radius: .5rem">Name</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($editChunks)
                                    @foreach ($chunks as $index => $item)
                                        <tr>
                                            <td class="text-center">{{ $loop->iteration }}</td>
                                            <td>
                                                <input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.code">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.name">
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    @foreach ($chunks as $item)
                                        <tr>
                                            <td class="text-center">{{ $loop->iteration }}</td>
                                            <td>{{ $item['code'] }}</td>
                                            <td>{{ $item['name'] }}</td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>

        @if ($isTable)
            <div class="card p-4 bg-transparent">
                <div class="table-responsive">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="d-flex align-items-center">
                            <label class="me-2">Show</label>
                            <select wire:model.live="perPage" class="form-control form-select-sm me-2"
                                style="width: auto">
                                <option value="5">5</option>
                                <option value="10">10</option>
                                <option value="20">20</option>
                                <option value="50">50</option>
                            </select>
                            <label>entries</label>
                        </div>
                        <div class="d-flex align-items-center">
                            <label class="me-2">Search</label>
                            <input wire:model.live="search" type="text" class="form-control form-control-sm"
                                placeholder="Search">
                        </div>
                    </div>

                    <table class="my-table" style="width:100%">
                        <thead>
                            <tr>
                                <th style="text-align: center; border-top-left-radius: .5rem" style="width: 60px">No
                                </th>
                                <th wire:click="doSort('code')" style="cursor: pointer">
                                    Code
                                    @if ($sortColumn === 'code')
                                        <span>
                                            @if ($sortDirection === 'ASC')
                                                <i class="fas fa-sort-up"></i>
                                            @else
                                                <i class="fas fa-sort-down"></i>
                                            @endif
                                        </span>
                                    @endif
                                </th>
                                <th wire:click="doSort('name')" style="cursor: pointer">
                                    Name
                                    @if ($sortColumn === 'name')
                                        <span>
                                            @if ($sortDirection === 'ASC')
                                                <i class="fas fa-sort-up"></i>
                                            @else
                                                <i class="fas fa-sort-down"></i>
                                            @endif
                                        </span>
                                    @endif
                                </th>
                                <th style="text-align: center; border-top-right-radius: .5rem">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($pricelists as $index => $item)
                                <tr>
                                    <td class="text-center">{{ $pricelists->firstItem() + $index }}</td>
                                    <td>{{ $item->code }}</td>
                                    <td>{{ $item->name }}</td>
                                    <td class="text-center">
                                        <div class="btn-group gap-2">
                                            <a href="{{ route('item.pricelistitem', ['id' => $item->code]) }}"
                                                class="btn btn-sm btn-primary">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" viewBox="0 0 16 16">
                                                    <path
                                                        d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                                                    <path
                                                        d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
                                                </svg>
                                            </a>
                                            <button class="btn btn-sm btn-primary"
                                                onclick="Livewire.dispatch('isEdit', ['{{ $item->code }}'])">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-pencil-square"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                    <path fill-rule="evenodd"
                                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                                                </svg>
                                            </button>
                                            <button class="btn btn-sm btn-danger"
                                                onclick="openDeleteModal('{{ $item->code }}', '{{ $item->name }}')">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                    <path
                                                        d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                                                    <path
                                                        d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                                                </svg>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center">No pricelists found</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    <div>
                        {{ $pricelists->onEachSide(1)->links() }}
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Create/Edit Modal -->
    <div wire:ignore.self class="modal fade" id="modalCreate" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ $isEdit ? 'Edit' : 'Create' }} Pricelist</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div x-data="{
                        autoGenerate: false,
                        codePricelist: '',
                        generateCode() {
                            const random = Math.random().toString(36).substring(2, 7).toUpperCase();
                            this.codePricelist = 'PRC-' + random;
                            this.$nextTick(() => {
                                const input = document.getElementById('code');
                                input.dispatchEvent(new Event('input'));
                            });
                        }
                    }" x-init="if (autoGenerate) generateCode()">
                        <div class="form-check mb-2">
                            <input type="checkbox" class="form-check-input" id="auto_code" x-model="autoGenerate"
                                @change="autoGenerate ? generateCode() : codePricelist = ''">
                            <label class="form-check-label" for="auto_code">Generate Code</label>
                        </div>
                        <div class="form-group">
                            <label for="code">Code</label>
                            <input type="text" wire:model.live="code" id="code" class="form-control mb-2"
                                x-model="codePricelist" :disabled="autoGenerate"
                                @input="codePricelist = codePricelist.toUpperCase()" wire:model.live="code">
                            @error('code')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" wire:model.live="name" id="name" class="form-control mb-2">
                            @error('name')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    @if (!$isEdit)
                        <button type="button" id="btn-save" class="btn btn-primary"
                            @if ($errors->any() || $name == '') disabled @endif wire:click="save">Save</button>
                    @else
                        <button type="button" id="btn-save" class="btn btn-primary"
                            @if ($errors->any() || $name == '') disabled @endif wire:click="saveUpdate">Edit</button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div wire:ignore.self class="modal fade" id="deleteConfirmModal" tabindex="-1"
        aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Confirmation</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete <strong id="deleteItemName"></strong>?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" onclick="confirmDelete()"
                        data-bs-dismiss="modal">Delete</button>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            document.addEventListener('livewire:initialized', () => {
                Livewire.on('closeModal', () => {
                    $('#modalCreate').modal('hide');
                });
            });

            Livewire.on('openModalEdit', ([code, name]) => {
                const codeInput = document.getElementById('code');
                const nameInput = document.getElementById('name');

                // Set values
                codeInput.value = code;
                nameInput.value = name;

                $('#modalCreate').modal('show');
            });

            Livewire.on('clearAfterCloseModalEdit', () => {
                const codeInput = document.getElementById('code');
                const nameInput = document.getElementById('name');
                const btnSave = document.getElementById('btn-save');

                // Set values
                codeInput.value = '';
                nameInput.value = '';

                $('#modalCreate').modal('hide');
            });

            let deleteCode = null;

            function openDeleteModal(code, name) {
                deleteCode = code;
                document.getElementById('deleteItemName').textContent = name;
                $('#deleteConfirmModal').modal('show');
            }

            function confirmDelete() {
                if (deleteCode) {
                    Livewire.dispatch('markAsDeleted', {
                        code: deleteCode
                    });
                    deleteCode = null;
                }
                $('#deleteConfirmModal').modal('hide');
            }
        </script>
    @endpush

    @if ($istutorials)
        <script>
            const pricelistPopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver({
                    showProgress: true,
                    steps: [
                        {
                            element: '.add-pricelist-pop',
                            popover: {
                                description: 'Click the add button to add a price list according to your store pricing scheme. Here you can create several schemes, for example international price and local price.'
                            }
                        },
                        {
                            element: '.show-table-pricelist-pop',
                            popover: {
                                description: 'Click show table to display the price lists you have created.'
                            }
                        },
                        {
                            element: '.see-action-pop',
                            popover: {
                                description: 'Click here to see the details of the items included in this price list.'
                            }
                        }
                    ],
                    onDeselected: () => {
                        $.ajax({
                            type: "POST",
                            url: '/update-status-driver',
                            data: {
                                menu: "Pricelist",
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {},
                            error: function(data, textStatus, errorThrown) {},
                        });
                    }
                });
                driverObj.drive();
            }
        </script>
    @endif
</div>
