<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="py-12 mt-2">
        <div class="header" x-data="{ isInputGroupVisible: false }"
            @keydown.window="if ($event.ctrlKey && ($event.key === 'ArrowRight' || $event.key === 'ArrowLeft')) { 
            isInputGroupVisible = !isInputGroupVisible; 
            @this.call('changeTable'); 
        }">
            <div class="d-flex justify-content-start">
                <div class="form-check" wire:click="changeTable" @click="isInputGroupVisible = !isInputGroupVisible"
                    data-toggle="tooltip" title="Click to show/hide">
                    <button class="btn btn-sm mb-4 add-product-pop"
                        style="background: #ee32ff1f; color: #ee32ff; border-radius: 1rem">
                        @if ($isTable)
                            + Add
                        @else
                            Show Table
                        @endif
                    </button>
                </div>
            </div>

            <div class="mb-4" x-show="isInputGroupVisible">

                @if (!$chunks)
                    <div style="display: flex; justify-content: end">
                        <a data-bs-target="#modalCreate" data-bs-toggle="modal"
                            class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3 mb-3">+ Item PriceList</a>
                    </div>
                    <div class="p-4" style="border: 1px dashed rgba(46, 46, 46, 0.288); border-radius: .5rem">
                        <div class="fs-4 fw-semibold mb-2">
                            Import File
                        </div>
                        <label for="importFile" class="form-label">{{ __('Supported formats') }} <span
                                class="text-danger">*.csv, *.xlsx</span>
                        </label>
                        <input wire:model="file" type="file"
                            class="form-control @error('file') is-invalid @enderror form-control-md" id="importFile"
                            name="importFile" accept=".csv, .xlsx"
                            style="background: transparent; border-radius: .5rem">
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="d-flex justify-content-end gap-2 mt-3">
                            <button wire:click="importItem" type="button"
                                class="btn btn-primary btn-sm rounded-3 fs-6 px-4"
                                @if (!$file) disabled @endif>{{ __('Import') }}</button>
                            <button type="button" class="btn btn-outline-secondary btn-sm rounded-3 fs-6 px-4"
                                onclick="window.location.href='/assets/template/Template Item Pricelist.csv'">
                                <i class="fas fa-download"></i> {{ __(' Download Template') }}
                            </button>
                        </div>
                    </div>
                @endif
                @if ($chunks)
                    @if (!$editChunks)
                        <button class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="saveChunks">Save</button>
                    @endif
                    @if ($editChunks)
                        <button class="btn btn-success btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEdit">Save
                            Edit</button>
                    @else
                        <button class="btn btn-warning btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEdit">
                            Edit</button>
                    @endif
                    <button class="btn btn-secondary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                        wire:click="cancelImport">Cancel</button>

                    @if ($this->hasDuplicates)
                        <div class="d-flex justify-content-end gap-2 mb-3">
                            <button wire:click="downloadDuplicates('xlsx')"
                                class="btn btn-sm btn-outline-primary rounded-3">
                                <i class="fas fa-file-excel me-1"></i> Export Duplicate Data
                            </button>

                        </div>
                    @endif
                @endif
                <div class="table-responsive table-member-tablet mt-4">
                    @if ($chunks)
                        <table class="my-table" @if (!$editChunks) id="example" @endif
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th style="text-align: center">No</th>
                                    <th style="text-align: center">Item Code</th>
                                    <th style="text-align: center">Pricelist Code</th>
                                    <th style="text-align: center">Price</th>

                                </tr>
                            </thead>
                            <tbody>
                                @if ($editChunks)
                                    @foreach ($chunks as $index => $item)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.item_code">
                                            </td>

                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.pricelist_code">
                                            </td>

                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.price">
                                            </td>

                                        </tr>
                                    @endforeach
                                @else
                                    @foreach ($chunks as $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>

                                            <td>{{ $item['item_code'] }}</td>
                                            <td>{{ $item['pricelist_code'] }}</td>

                                            <td>{{ $item['price'] }}</td>

                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>
        </div>
        @if ($isTable)
            <div class="card p-4 bg-transparent">
                <div class="fs-4 fw-semibold mb-3">Item Price List</div>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="d-flex align-items-center gap-2">
                        <select wire:model.live="perPage" class="form-select form-select-sm w-auto">
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                        <label class="mb-0">entries</label>
                    </div>
                    <div class="search-box">
                        <input type="text" class="form-control form-control-sm" placeholder="Search..." wire:model.live="search">
                    </div>
                </div>
                <div class="table-responsive table-member-tablet">
                    <table class="my-table" style="width:100%">
                        <thead>
                            <tr>
                                <th style="border-top-left-radius: .5rem">No</th>
                                <th wire:click="doSort('item_code')" style="cursor: pointer">
                                    Item Code
                                    @if ($sortColumn === 'item_code')
                                        <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th>Item Name</th>
                                <th wire:click="doSort('price')" style="cursor: pointer">
                                    Price
                                    @if ($sortColumn === 'price')
                                        <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th style="border-top-right-radius: .5rem">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($itemPricelists as $item)
                                <tr>
                                    <td style="text-align: center">{{ ($itemPricelists->currentPage() - 1) * $itemPricelists->perPage() + $loop->iteration }}</td>
                                    <td>{{ $item->item_code }}</td>
                                    <td>{{ $item->item_name }}</td>
                                    <td>{{ number_format($item->price, 0, ',', '.') }}</td>
                                    <td style="text-align: center">
                                        <div class="btn btn-sm" type="button" style="background: #00000015;"
                                            onclick="handleEditItemPricelist('{{ $item->item_code }}', '{{ $item->pricelist_code }}')">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" width="17px" height="17px">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                            </svg>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    
                        {{ $itemPricelists->links() }}
                </div>
            </div>
        @endif
    </div>
    <div wire:ignore.self class="modal fade " id="modalCreate" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Price at: <span
                            class="text-primary">{{ $param }}</span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    @if ($errMsg != '')
                        <small class="text-danger d-block mt-1"> {{ $errMsg }}</small>
                    @endif

                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            <label for="searchItemInput">Item</label>
                            <input type="text" class="form-control rounded"
                                wire:model.debounce.100ms.live="searchitem" id="searchItemInput"
                                placeholder="Select Item"
                                @keydown.arrow-down.prevent="selectedIndexItem = Math.min(selectedIndexItem + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexItem = Math.max(selectedIndexItem - 1, -1)"
                                x-on:keydown.enter="
                        if(selectedIndexItem == -1) {
                            $wire.selectItemByName();
                        }else{
                            $wire.selectItem(selectedIndexItem);
                            selectedIndexItem = -1;
                        }"
                                autocomplete="off">
                        </div>
                        @if ($selectedItem === null)
                            @if ($resultitem)
                                <div class="dropdown-menu d-block py-0">
                                    @foreach ($resultitem as $index => $item)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexItem === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndexItem === {{ $index }} }"
                                                    wire:click="selectItemByClick('{{ $item->code }}')">
                                                    {{ $item->code }} || {{ $item->name }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="pricelist_code">Pricelist Code</label>
                        <select class="form-select mb-2" wire:model.live="pricelist_code" disabled>
                            @foreach ($Pricelist as $pl)
                                <option value="{{ $pl->code }}" {{ $pl->code == $param ? 'selected' : '' }}>
                                    {{ $pl->code }}
                                </option>
                            @endforeach
                        </select>
                        @error('pricelist_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group" x-data="{
                        displayPrice: '',
                        formatPrice(value) {
                            let number = value.replace(/\D/g, '');
                            return new Intl.NumberFormat('id-ID').format(number);
                        },
                        updateDisplay() {
                            this.displayPrice = this.formatPrice($refs.priceInput.value);
                        }
                    }" x-init="updateDisplay()" @input="updateDisplay">
                        <label for="price">Price</label>
                        <input type="text" x-model="displayPrice" wire:model.live="price" id="price"
                            class="form-control mb-2"
                            @input="$refs.priceInput.value = displayPrice.replace(/\./g, '')"
                            placeholder="Enter price (example: 100.000.000)">
                        <input type="hidden" wire:model.live="price" x-ref="priceInput">
                        @error('price')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $price == '' || $errMsg != '' || $selectedItem === null) disabled @endif
                        wire:click="save">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade " id="modalEditPricelistItem" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Pricelist</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <label for="item_code">Item Code</label>
                        <input type="text" value="{{ $selectedItemCode }}" class="form-control mb-2" disabled>
                    </div>
                    <div class="form-group">
                        <label for="pricelist_code">Pricelist Code</label>
                        <input type="text" value="{{ $selectedItemPricelistCode }}" class="form-control mb-2"
                            disabled>

                    </div>
                    <div class="form-group">
                        <label for="price">Old Price</label>
                        <input type="text" value="{{ $selectedItemPrice }}" class="form-control mb-2" disabled>

                    </div>

                    <div class="form-group" x-data="{
                        displayPrice: '',
                        formatPrice(value) {
                            let number = value.replace(/\D/g, '');
                            return new Intl.NumberFormat('id-ID').format(number);
                        },
                        updateDisplay() {
                            this.displayPrice = this.formatPrice($refs.priceInput.value);
                        }
                    }" x-init="updateDisplay()" @input="updateDisplay">
                        <label for="price">New Price</label>
                        <input type="text" x-model="displayPrice" wire:model.live="pricenew" id="pricenew"
                            class="form-control mb-2"
                            @input="$refs.priceInput.value = displayPrice.replace(/\./g, '')"
                            placeholder="Masukkan harga (contoh: 100.000.000)">
                        <input type="hidden" wire:model.live="pricenew" x-ref="priceInput">
                        @error('pricenew')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="refreshjs"
                        data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $pricenew == '' || $errMsg != '') disabled @endif
                        wire:click="update">Save</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.shiftKey && event.key === 'N') {
                event.preventDefault();
                $('#modalCreate').modal('show');
            }
        });
    </script>
</div>
