<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="py-12 mt-2">
        <div class="mb-4">
            <div style="display: flex; justify-content: end">
                <a data-bs-target="#modalCreate" data-bs-toggle="modal"
                    class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 add-sales-emp-pop">+ Add Sales Employee</a>
            </div>

            <div class="table-responsive table-member-tablet mt-4">
                <table class="my-table"id="example" style="width:100%">
                    <thead>
                        <tr>
                            <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                            <th style="text-align: center">NIK</th>
                            <th style="text-align: center">Name</th>
                            <th style="text-align: center">Position</th>
                            <th style="text-align: center; border-top-right-radius: .5rem">Remark</th>


                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($itemSales as $item)
                            <tr>
                                <td style="text-align: center">{{ $loop->iteration }}</td>
                                {{-- <td style="text-align: center">{{ $item['company_code'] }}</td> --}}
                                <td style="text-align: center">{{ $item->code }}</td>
                                <td style="text-align: center">{{ $item->name }}</td>
                                <td style="text-align: center">{{ $item->position }}</td>
                                <td style="text-align: center">{{ $item->remark }}</td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade " id="modalCreate" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Employee</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    
                    <div class="form-group">
                        <div class="form-group">
                            <label for="barcode">NIK</label>
                            <input type="text" wire:model.live="code" id="code" class="form-control mb-2">
                            @error('code')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="name">Sales Name</label>
                        <input type="text" wire:model.live="name" id="name" class="form-control mb-2">
                        @error('name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="address">Position</label>
                        <input type="text" wire:model.live="position" id="position" class="form-control mb-2">
                        @error('position')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="address">Remark</label>
                        <input type="text" wire:model.live="remark" id="remark" class="form-control mb-2">
                        @error('remark')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $name == '') disabled @endif
                        wire:click="save">Save</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.shiftKey && event.key === 'N') {
                event.preventDefault();
                $('#modalCreate').modal('show');
            }
        });

    </script>
</div>
