<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb align-items-center">
                    <li class="breadcrumb-item">
                        <a href="{{ route('item') }}">{{ __('Items') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Insert') }}
                    </li>
                    {{-- <li class="breadcrumb-item d-flex align-items-center" aria-current="page">
                        <span class="me-2">Item Price</span>
                      
                            @admin
                                <select class="form-select form-select-sm filter-it-pop" wire:model.live="whs_code"
                                    style="width: auto;">
                                    @foreach ($warehouse as $whs)
                                        <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                                    @endforeach
                                </select>
                            @else
                                <span class="">{{ userWarehouse() }} </span>
                            @endadmin

                    </li> --}}
                </ol>
            </div>
        </nav>

        <div class="d-flex" style="flex-direction: column" id="cashier">
            <div class="d-flex align-items-center gap-2">
                <div class="fs-4 fw-semibold">Item Price</div>
                <div class="badge text-primary" style="background: #2282ff38">{{ $param }}</div>
            </div>
            
            <div class="row">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="">
                        <div class="card-body mb-3">
                            <livewire:pos.item.insert-item-pricelist wire:key="insert-itempricelist" :param="$param" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@livewireScripts


<script>
    function handleEditItemPricelist(code, pricelistcode) {
        Livewire.dispatch('editItemPricelist', {
            code: code,
            pricelistcode: pricelistcode
        });
    }

    Livewire.on('closemodalCreate', () => {
        $('#modalCreate').modal('hide');
    });

    Livewire.on('openModalEdit', () => {
        $('#modalEditPricelistItem').modal('show');
    });
    Livewire.on('closeModalEdit', () => {
        $('#modalEditPricelistItem').modal('hide');
    });

    Livewire.on('refreshDatatable', (params) => {
        setTimeout(() => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        }, 1000);
    });
</script>
