<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb d-flex align-items-center">
                    <li class="breadcrumb-item">
                        <a href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item d-flex align-items-center gap-1" x-data="{
                        whs_code: @entangle('whs_code'),
                        selectedOption: @entangle('selectedOption')
                    }">
                        @admin
                            <span class="me-2">{{ __('Item Transfer') }}</span>
                            <select class="form-select form-select-sm filter-it-pop" x-model="whs_code"
                                @change="selectedOption = 'In'; $wire.set('whs_code', whs_code)" style="width: auto;">
                                @foreach ($warehouse as $whs)
                                    <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                                @endforeach
                            </select>
                        @else
                            <span class="me-2">{{ __('Item Transfer') }} {{ userWarehouse() }} </span>
                        @endadmin

                        <select class="form-select form-select-sm filter-it-pop" x-model="selectedOption"
                            @change="$wire.set('selectedOption', selectedOption)" style="width: auto;">
                            <option value="In">{{ __('In') }}</option>
                            <option value="Out">{{ __('Out') }}</option>
                        </select>
                    </li>


                </ol>
            </div>
        </nav>

        <div class="" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="button-top-right">
                    <button wire:keydown.window.shift.n="toCreateITOut" wire:click="toCreateITOut" type="button"
                        class="btn btn-primary btn-sm ml-4 create-it-out-pop">{{ __('Create IT') }}</button>
                </div>
                <div class="card-body">
                    <div class="py-12">
                        <div class="table-responsive table-salesemp">
                            <div class="mb-3 d-flex justify-content-between">
                                <div class="d-flex align-items-center">
                                    <label class="me-2">Show</label>
                                    <select wire:model.live="perPage" class="form-control form-select-sm me-2">
                                        <option value="10">10</option>
                                        <option value="20">20</option>
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                    </select>
                                    <label class="">entries</label>
                                </div>
                                <div class="d-flex align-items-center">
                                    <label class="me-2">Search</label>
                                    <input wire:model.live="search" type="text" class="form-control form-control-sm" 
                                        placeholder="Search">
                                </div>
                            </div>
                            <table class="my-table" style="width:100%">
                                <thead>
                                    <tr>
                                        <th style="text-align: center; border-top-left-radius: .5rem;" scope="col">#</th>
                                        <th scope="col">{{ __('Action') }}</th>
                                        <th scope="col" wire:click="sortBy('no')" style="cursor: pointer;">
                                            {{ __('No') }}
                                            @if($sortField === 'no')
                                                @if($sortDirection === 'asc')
                                                    <i class="bi bi-arrow-up"></i>
                                                @else
                                                    <i class="bi bi-arrow-down"></i>
                                                @endif
                                            @endif
                                        </th>
                                        <th scope="col" wire:click="sortBy('whs_name')" style="cursor: pointer;">
                                            {{ __('From Store') }}
                                            @if($sortField === 'whs_name')
                                                @if($sortDirection === 'asc')
                                                    <i class="bi bi-arrow-up"></i>
                                                @else
                                                    <i class="bi bi-arrow-down"></i>
                                                @endif
                                            @endif
                                        </th>
                                        <th scope="col" wire:click="sortBy('to_whs_name')" style="cursor: pointer;">
                                            {{ __('To Store') }}
                                            @if($sortField === 'to_whs_name')
                                                @if($sortDirection === 'asc')
                                                    <i class="bi bi-arrow-up"></i>
                                                @else
                                                    <i class="bi bi-arrow-down"></i>
                                                @endif
                                            @endif
                                        </th>
                                        <th scope="col" wire:click="sortBy('date')" style="cursor: pointer;">
                                            {{ __('Date') }}
                                            @if($sortField === 'date')
                                                @if($sortDirection === 'asc')
                                                    <i class="bi bi-arrow-up"></i>
                                                @else
                                                    <i class="bi bi-arrow-down"></i>
                                                @endif
                                            @endif
                                        </th>
                                        <th scope="col" wire:click="sortBy('remark')" style="cursor: pointer;">
                                            {{ __('Remark') }}
                                            @if($sortField === 'remark')
                                                @if($sortDirection === 'asc')
                                                    <i class="bi bi-arrow-up"></i>
                                                @else
                                                    <i class="bi bi-arrow-down"></i>
                                                @endif
                                            @endif
                                        </th>
                                        <th scope="col" wire:click="sortBy('qty_close')" style="cursor: pointer;">
                                            {{ __('Qty') }}
                                            @if($sortField === 'qty_close')
                                                @if($sortDirection === 'asc')
                                                    <i class="bi bi-arrow-up"></i>
                                                @else
                                                    <i class="bi bi-arrow-down"></i>
                                                @endif
                                            @endif
                                        </th>
                                        <th scope="col" wire:click="sortBy('total')" style="cursor: pointer;">
                                            {{ __('Total') }}
                                            @if($sortField === 'total')
                                                @if($sortDirection === 'asc')
                                                    <i class="bi bi-arrow-up"></i>
                                                @else
                                                    <i class="bi bi-arrow-down"></i>
                                                @endif
                                            @endif
                                        </th>
                                        <th style="text-align: center; border-top-right-radius: .5rem;" scope="col">{{ __('Status') }}</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @forelse($itemtransfer as $key => $item)
                                        <tr>
                                            <td>{{ $itemtransfer->firstItem() + $key }}</td>
                                            <td>
                                                <button class="btn btn-primary content-end it-detail-pop"
                                                    style="padding: 2.5px 5px; font-size: 12px;">
                                                    <a href="/item-transfer/detail/{{ $item->no }}"
                                                        style="text-decoration: none; color: white">Detail</a>
                                                </button>
                                            </td>
                                            <td>{{ $item->no }}</td>
                                            <td>{{ $item->whs_name ?? '-' }}</td>
                                            <td>{{ $item->to_whs_name ?? '-' }}</td>
                                            <td>{{ \Carbon\Carbon::parse($item->date)->format('d F Y') }}</td>
                                            <td>{{ $item->remark }}</td>
                                            <td>
                                                @switch($item->status)
                                                    @case(1)
                                                        {{ $item->qty_open }}
                                                    @break
                                                    @case(2)
                                                        {{ $item->qty_close }}
                                                    @break
                                                    @case(3)
                                                        {{ $item->qty_close }}
                                                    @break
                                                    @case(4)
                                                        {{ $item->qty }}
                                                    @break
                                                    @case(5)
                                                        {{ $item->qty_request }}
                                                    @break
                                                    @default
                                                        {{ $item->qty }}
                                                @endswitch
                                            </td>
                                            <td>{{ 'Rp. ' . number_format($item->total, 0, ',', '.') }}</td>
                                            <td>
                                                @switch($item->status)
                                                    @case(1)
                                                        @if ($selectedOption == 'In')
                                                            <button class="btn btn-warning badge">
                                                                <a class="text-white" href="{{ route('item-transfer.edit', $item->no) }}" style="text-decoration: none;">Open</a>
                                                            </button>
                                                        @else
                                                            <button class="btn btn-warning badge">Open</button>
                                                        @endif
                                                    @break
                                                    @case(2)
                                                        <button class="btn btn-success badge">Close</button>
                                                        @php
                                                            $percentage = $item->qty_open > 0 ? ($item->qty_close / $item->qty_open) * 100 : 0;
                                                        @endphp
                                                        <button class="btn badge {{ $percentage >= 100 ? 'btn-success' : 'btn-warning' }}">
                                                            {{ round($percentage, 2) }}%
                                                        </button>
                                                    @break
                                                    @case(3)
                                                        <button class="btn btn-success badge">Close With Different</button>
                                                        @php
                                                            $percentage = $item->qty_open > 0 ? ($item->qty_close / $item->qty_open) * 100 : 0;
                                                        @endphp
                                                        <button class="btn badge {{ $percentage > 100 ? 'btn-success' : 'btn-warning' }}">
                                                            {{ round($percentage, 2) }}%
                                                        </button>
                                                    @break
                                                    @case(4)
                                                        <button class="btn btn-danger badge">Cancel</button>
                                                    @break
                                                    @case(5)
                                                        @if ($selectedOption == 'In')
                                                            <button class="btn btn-info badge">
                                                                <a class="text-white" style="text-decoration: none;">Request</a>
                                                            </button>
                                                        @else
                                                            <button class="btn btn-info badge">
                                                                <a class="text-white" href="{{ route('item-transfer.edit', $item->no) }}" style="text-decoration: none;">Request</a>
                                                            </button>
                                                        @endif
                                                    @break
                                                @endswitch
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="10" class="text-center">No records found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-4">
                            {{ $itemtransfer->links() }}
                        </div>

                        <div class="mt-4">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col" style="text-align: right;">{{ __('Total Qty Close') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Total</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">{{ number_format($totalSumQty, 0, ',', ',') }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@livewireScripts
<script>
    Livewire.on('refreshDatatable', (params) => {
        setTimeout(() => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        }, 500);
    });

    Livewire.on('closeModal', (params) => {
        $('#modalApprove' + params).modal('hide');
    });
</script>
