<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/item-transfer">{{ __('Inv Transfer Request') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Detail') }}
                    </li>
                </ol>

            </div>
        </nav>

        <div class="" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="button-top-right">
                    {{-- <button type="button" class="btn btn-secondary btn-sm ml-2">
                        <a href="{{ route('item-transfer.index') }}" style="text-decoration: none; color: white">Close</a>
                    </button> --}}
                    <div class="mb-1">
                        @if ($no->status == 5)
                            <button data-bs-target="#modalSign1" data-bs-toggle="modal" type="button"
                                class="btn btn-primary btn-sm ml-2">
                                @if ($isloading)
                                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                                        aria-hidden="true"></span>
                                    <span id="innerSpan">Loading . . .</span>
                                @else
                                    {{ __('Open') }}
                                @endif
                            </button>
                            <button data-bs-target="#modalReject" data-bs-toggle="modal" type="button"
                                class="btn btn-danger btn-sm ml-2">
                                <a href="#" style="text-decoration: none; color: white">Reject</a>
                            </button>
                            <button type="button" class="btn btn-secondary btn-sm ml-2">
                                <a href="{{ route('item-transfer.index') }}"
                                    style="text-decoration: none; color: white">Back</a>
                            </button>
                        @else
                            <button data-bs-target="#modalSign2" data-bs-toggle="modal" type="button"
                                class="custom-button1 btn-sm" @if ($no->status != 1) disabled @endif>
                                @if ($isloading)
                                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                                        aria-hidden="true"></span>
                                    <span id="innerSpan">Loading . . .</span>
                                @else
                                    {{ __('Save') }}
                                @endif
                            </button>
                            <button type="button" class="btn btn-secondary btn-sm ml-2">
                                <a href="{{ route('item-transfer.index') }}"
                                    style="text-decoration: none; color: white">Back</a>
                            </button>
                        @endif
    
                    </div>
                </div>
                <div class="">
                    <div class="card" style="margin-top: -1rem; margin-bottom: 1rem;">
                        <div class="m-2">
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">
                                    {{ __('Item Trans No. ') }}
                                    <span class="">{{ $no->no }}</span>

                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('From Store : ') }} <span
                                        class="">{{ $no->whs_name ?? '-' }}</span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('To Store : ') }} <span
                                        class="">{{ $no->to_whs_name ?? '-' }}</span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('Date : ') }} <span
                                        class="">{{ $no->date }}</span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('Remark : ') }} <span
                                        class="">{{ $no->remark }}</span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('Status : ') }} @switch($no->status)
                                        @case(1)
                                            <span class="btn btn-warning badge">Open
                                            </span>
                                        @break

                                        @case(2)
                                            <span class="btn btn-success badge">Close
                                            </span>
                                        @break

                                        @case(3)
                                            <span class="btn btn-success badge">Close With
                                                Different
                                            </span>
                                        @break

                                        @case(4)
                                            <span class="btn btn-danger badge">Cancel
                                            </span>
                                        @break

                                        @case(5)
                                            <span class="btn btn-info badge">Request
                                            </span>
                                        @break
                                    @endswitch
                            </div>
                            {{-- @if ($no->status == 5)
                                <div
                                    class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                    <button type="button" class="custom-button1 btn-sm ml-2"
                                        @if ($no->status == 1 || $no->status == 5) data-bs-target="#modalAddItemReq"
                                    data-bs-toggle="modal" data-bs-dismiss="modal" @else disabled @endif>{{ __('Add Item') }}</button>
                                </div>
                            @endif --}}
                        </div>

                    </div>

                    <div class="table-responsive">
                        <table id="table" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%;">
                            <thead>
                                <tr>
                                    <th scope="col" style="border-top-left-radius: .5rem">#</th>
                                    <th scope="col">{{ __('Code') }}</th>
                                    <th scope="col">{{ __('Barcode') }}</th>
                                    <th scope="col">{{ __('Name') }}</th>
                                    @if ($no->status == 5 || $no->status == 4)
                                    <th scope="col">{{ __('Qty Request') }}</th>
                                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Qty Send') }}
                                    @elseif ($no->status == 1)
                                    <th scope="col">{{ __('Qty Send') }}</th>
                                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Qty Receive') }}
                                    @elseif($no->status == 2 || $no->status == 3)
                                    <th scope="col">{{ __('Qty Send') }}</th>
                                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Qty Receive') }}
                                    @endif
                                    </th>


                                </tr>
                            </thead>

                            <tbody class="small">
                                @foreach ($details as $key => $detail)
                                    <tr wire:key="{{ $detail->code }}">
                                        <th scope="col">{{ $key + 1 }}</td>
                                        <td>{{ $detail->code }}</td>
                                        <td>{{ $detail->barcode }}</td>
                                        <td>{{ $detail->name }}</td>
                                        @if($no->status == 5 || $no->status == 4)
                                        <td>{{ number_format($detail->qty_request) }}</td>
                                        @elseif ($no->status == 1)
                                        <td>{{ number_format($detail->qty_open) }}</td>
                                        @elseif($no->status == 2 || $no->status == 3)
                                        <td>{{ number_format($detail->qty_open) }}</td>
                                        @endif

                                        <td x-data="{ isFocused: false }">
                                            @if ($no->status == 1 || $no->status == 5)
                                                <input type="number" wire:model="quantities.{{ $key }}"
                                                    class="form-control p-0" id="bg-qty-req"
                                                    x-on:focus="isFocused = true"
                                                    x-on:blur="isFocused = false; $wire.updateQuantity({{ $key }}, '{{ $detail->code }}')">
                                            @else
                                                {{ $detail->actualqty }}
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div wire:ignore.self>
                        <table id="table" class="table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    @if ($no->status == 5 || $no->status == 4)
                                    <th scope="col" style="text-align: right;">{{ __('Total Qty Request') }}</th>
                                    <th scope="col" style="text-align: right; width: 120px;">
                                        {{ __('Total Qty Send') }}</th>
                                    @elseif ($no->status == 1)
                                    <th scope="col" style="text-align: right;">{{ __('Total Qty Send') }}</th>
                                    <th scope="col" style="text-align: right; width: 120px;">
                                        {{ __('Total Qty Receive') }}</th>
                                    @elseif($no->status == 2 || $no->status == 3)
                                    <th scope="col" style="text-align: right;">{{ __('Total Qty Send') }}</th>
                                    <th scope="col" style="text-align: right; width: 120px;">
                                        {{ __('Total Qty Receive') }}</th>
                                    @endif

                                </tr>
                            </thead>

                            <tbody class="small">

                                <tr>
                                    <td colspan="2">Total</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    @if ($no->status == 5 || $no->status == 4)
                                    <td style="text-align: right;">
                                        {{ number_format($details->sum('qty_request'), 0, ',', ',') }}</td>
                                    
                                    </td>
                                    @elseif ($no->status == 1)
                                    <td style="text-align: right;">
                                        {{ number_format($details->sum('qty_open'), 0, ',', ',') }}</td>
                                   
                                    </td>
                                    @elseif($no->status == 2 || $no->status == 3)
                                    <td style="text-align: right;">
                                        {{ number_format($details->sum('qty_open'), 0, ',', ',') }}</td>
                                   
                                    @endif
                                    <td style="text-align: right; width: 120px;">
                                        @php
                                            $totalQty = array_sum(array_map('floatval', $quantities));
                                        @endphp
                                        {{ number_format($totalQty, 0, ',', ',') }}
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    {{-- <div class="d-flex justify-content-end align-items-center">
                            <button data-bs-toggle="modal" @if ($no->status == 'N') data-bs-target="#modalSign" @else disabled @endif type="button"
                                class="custom-button1 btn-sm">{{ __('Sign IT Request') }}</button>
                        </div> --}}
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalSign2" aria-hidden="true" aria-labelledby="modalSignLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Close IT Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="d-flex justify-content-center align-items-center"> Are you sure to Close the It Request?
                    </h4>
                    <h4 class="d-flex justify-content-center align-items-center">It's cant be Revert. </h4>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success mr-auto" wire:click="save" data-bs-dismiss="modal">Sign</button>

                    <button class="btn btn-danger" data-bs-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalSign1" aria-hidden="true" aria-labelledby="modalSignLabel1" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Open IT Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="d-flex justify-content-center align-items-center"> Are you sure to Open the It Request?
                    </h4>
                    <h4 class="d-flex justify-content-center align-items-center">It's cant be Revert. </h4>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success mr-auto" wire:click="save" data-bs-dismiss="modal">Open</button>

                    <button class="btn btn-secondary" data-bs-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalReject" aria-hidden="true" aria-labelledby="modalRejectLabel1" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalRejectLabel">Reject IT Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="d-flex justify-content-center align-items-center"> Are you sure to Reject the It
                        Request?
                    </h4>
                    <h4 class="d-flex justify-content-center align-items-center">It's cant be Revert.</h4>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-danger mr-auto" wire:click="reject"
                        data-bs-dismiss="modal">Reject</button>

                    <button class="btn btn-secondary" data-bs-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
    {{-- <livewire:pos.it.itreqin.add-item-req :no="$no" /> --}}
    {{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script> --}}
    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>


</div>
