<div wire:ignore.self>
    <div class="py-12">
        <div class="table-responsive">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5 text-dark bg-white" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: .5rem">#</th>
                        <th scope="col">{{ __('Aksi') }}</th>
                        <th scope="col">{{ __('Dari') }}</th>
                        <th scope="col">{{ __('No') }}</th>
                        <th scope="col">{{ __('Tanggal') }}</th>
                        <th scope="col">{{ __('Catatan') }}</th>
                        <th scope="col">{{ __('Total Qty') }}</th>
                        <th scope="col">{{ __('Status') }}</th>
                        <th class="text-center" scope="col">{{ __('Sign') }}</th>



                    </tr>
                </thead>

                <tbody class="small">
                    @forelse($its as $key => $it)
                        <tr wire:key="{{ $it->no }}">
                            <th scope="col">{{ $key + 1 }}</td>
                            <td>
                                <a href="/it_req/view/{{ $it->no }}" class="btn btn-primary content-end"
                                    style="padding: 2.5px 5px; font-size: 10px;">
                                    Detail
                                </a>
                            </td>
                            <td>{{ $it->whsFrom->name }}</td>
                            <td>{{ $it->no }}</td>
                            <td>{{ $it->date }}</td>
                            <td>{{ $it->comments }}</td>
                            <td>{{ $it->details_sum_qty_receive }}</td>
                            <td>
                                @if ($it->status == 'Not Checked')
                                    <span class="text-danger">Not yet checked</span>
                                @elseif($it->status == 'Same')
                                    <span class="text-success">Same</span>
                                @elseif($it->status == 'Difference')
                                    <span class="text-warning">Different</span>
                                @endif
                            </td>
                            <td class="d-flex justify-content-center">
                                @if ($it->sign == 'Y')
                                    <button class="btn btn-badge btn-sm btn-success" style="font-size: 10px;"> Verified
                                    </button>
                                @else
                                    <button class="btn btn-badge btn-sm btn-danger" style="font-size: 10px;"> Not verified yet
                                    </button>
                                @endif
                            </td>
                            

                        </tr>
                        <div class="modal fade" id="modalEmail{{ $it->no }}" aria-hidden="true"
                            aria-labelledby="modalEmailLabel2" tabindex="-1">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="modalSignLabel">Send Email IT Request</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <h4 class="d-flex justify-content-center align-items-center"> Are you sure to
                                            Send email It Request?
                                        </h4>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-success mr-auto"
                                            wire:click="sendEmailItReq('{{ $it->no }}')"
                                            data-bs-dismiss="modal">Send</button>

                                        <button class="btn btn-danger" data-bs-target="#modalSign"
                                            data-bs-toggle="modal" data-bs-dismiss="modal">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="modalSync{{ $it->no }}" aria-hidden="true"
                            aria-labelledby="modalSyncLabel2" tabindex="-1">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="modalSignLabel">Sync IT Request</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <h4 class="d-flex justify-content-center align-items-center"> Are you sure to
                                            Sync the It Request?
                                        </h4>
                                        <h4 class="d-flex justify-content-center align-items-center">It's cant be
                                            Revert. </h4>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-success mr-auto"
                                            wire:click="syncITReq('{{ $it->no }}')"
                                            data-bs-dismiss="modal">Send</button>

                                        <button class="btn btn-danger" data-bs-target="#modalSign"
                                            data-bs-toggle="modal" data-bs-dismiss="modal">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                    @endforelse
                </tbody>
            </table>
        </div>
        <table id="example" class="my-table dataTables_wrapper dt-bootstrap5 text-dark mt-2" style="width:100%; ">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col" style="text-align: right;">{{ __('Total Qty') }}</th>

                </tr>
            </thead>

            <tbody class="small">

                <tr>
                    <td>Total</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>

                    <td style="text-align: right;">{{ number_format($totalSumQty, 0, ',', ',') }}</td>

                </tr>

            </tbody>
        </table>
    </div>
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });
</script>
