<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb fs-5">
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/it_req">{{ __('Inv Transfer Out') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Detail') }}
                    </li>
                </ol>

                <div>
                    <button data-bs-target="#modalSign2"
                    data-bs-toggle="modal" type="button"
                        class="btn btn-primary btn-sm" @if($no->sign == 'Y') disabled @endif>
                        @if($isloading)
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                        @else
                        {{ __('Save') }}
                        @endif</button>
                        <button wire:click="close" type="button"
                    class="btn btn-secondary btn-sm ml-2">{{ __('Close') }}</button>
                </div>
                
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card mt-4">
                <div class="">
                    <div class="card bg-white" style="margin-top: -1rem; margin-bottom: 1rem;">
                        <div class="m-2">
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('IT Request Detail No. ') }} <span
                                        class="text-dark">{{ $no->no }}</span></h6>
                            </div>
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('Date : ') }} <span
                                        class="text-dark">{{ $no->date }}</span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-1">
                                <h6 class="card-title text-secondary">{{ __('Remark : ') }} <span
                                        class="text-dark">{{ $no->comments }}</span></h6>
                            </div>
                            {{-- <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <button type="button" class="btn btn-primary btn-sm ml-2" @if($no->sign == 'N') data-bs-target="#modalAddItemReq"
                                    data-bs-toggle="modal" data-bs-dismiss="modal" @else disabled @endif>{{ __('Add Item') }}</button>
                            </div> --}}
                        </div>
                       
                    </div>

                        <div class="table-responsive">
                            <table id="table" class="my-table dataTables_wrapper dt-bootstrap5 text-dark bg-white"
                                style="width:100%;">
                                <thead>
                                    <tr>
                                        <th scope="col" style="border-top-left-radius: .5rem">#</th>
                                        <th scope="col">{{ __('Code') }}</th>
                                        <th scope="col">{{ __('Barcode') }}</th>
                                        <th scope="col">{{ __('Name') }}</th>
                                        <th scope="col">{{ __('Qty Send') }}</th>
                                        <th scope="col" style="border-top-right-radius: .5rem">{{ __('Qty Receive') }}</th>


                                    </tr>
                                </thead>

                                <tbody class="small">
                                    @foreach ($details as $key => $detail)
                                        <tr wire:key="{{ $detail->code }}">
                                            <th scope="col">{{ $key + 1 }}</td>
                                            <td>{{ $detail->code }}</td>
                                            <td>{{ $detail->barcode }}</td>
                                            <td>{{ $detail->name }}</td>
                                            <td>{{ number_format($detail->qty) }}</td>

                                            <td x-data="{ isFocused: false }">
                                                @if($no->sign == 'N')
                                                <input type="number" wire:model="quantities.{{ $key }}"
                                                    class="form-control p-0 border-0" x-on:focus="isFocused = true"
                                                    x-on:blur="isFocused = false; $wire.updateQuantity({{ $key }}, '{{ $detail->code }}')">
                                                    @else
                                                    {{ $detail->qty_receive }}
                                                    @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div wire:ignore.self>
                            <table id="table" class="my-table dataTables_wrapper dt-bootstrap5 text-dark"
                                style="width:100%; ">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col" colspan="4"></th>
                                        <th scope="col" style="text-align: right;">{{ __('Total Qty') }}</th>
                                    </tr>
                                </thead>

                                <tbody class="small">

                                    <tr>
                                        <td colspan="2">Total</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td colspan="4"></td>
                                        <td style="text-align: right;">
                                            {{ number_format($details->sum('qty'), 0, ',', ',') }}</td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        {{-- <div class="d-flex justify-content-end align-items-center">
                            <button data-bs-toggle="modal" @if($no->sign == 'N') data-bs-target="#modalSign" @else disabled @endif type="button"
                                class="btn btn-primary btn-sm">{{ __('Sign IT Request') }}</button>
                        </div> --}}
                </div>
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" id="modalSign" aria-hidden="true" aria-labelledby="modalSignLabel" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Sign IT Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="d-flex justify-content-center align-items-center">
                        <button type="button" @if($no->status == 'Same') disabled @else wire:click="sendEmail" @endif class="btn btn-info btn-sm mx-auto">
                            @if($isloading)
                            <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                            <span id="innerSpan">Loading . . .</span>
                            @else
                            {{ __('Send Email') }}
                            @endif
                        </button>
                        <button type="button" class="btn btn-primary btn-sm mx-auto" data-bs-target="#modalSign2"
                            data-bs-toggle="modal" data-bs-dismiss="modal">{{ __('Sign IT Request') }}</button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalSign2" aria-hidden="true" aria-labelledby="modalSignLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Sign IT Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="d-flex justify-content-center align-items-center"> Are you sure to Sign the It Request? 
                    </h4>
                    <h4 class="d-flex justify-content-center align-items-center">It's cant be Revert. </h4>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success mr-auto" wire:click="save" data-bs-dismiss="modal">Sign</button>
                    
                    <button class="btn btn-danger"  data-bs-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
    <livewire:pos.it.add-item-req :no="$no" />
    {{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script> --}}
    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>


</div>
