<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center mt-4 mb-2 breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="{{ route('it.itreqout') }}">{{ __('IT Request Out') }} </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Buat IT Request Keluar') }}
                    </li>
                </ol>
            </div>
        </nav>
        <div class="row">
            <div class="col-sm-4 col-md-4 col-lg-3">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="dateInput">Date</label>

                        <input type="date" class="form-control rounded" id="dateInput" wire:model.live="date"
                            placeholder="Choose Date" autocomplete="off">
                    </div>
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="searchItemInput">From Store/Warehouse</label>
                        <input type="text" class="form-control rounded"
                            wire:model.debounce.100ms.live="searchwarehouse" id="searchWarehouseInput"
                            placeholder="Search Warehouse"
                            @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                            @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                            x-on:keydown.enter="
                if(selectedIndexWarehouse == -1) {

                }else{
                    $wire.selectWarehouse(selectedIndexWarehouse);
                    selectedIndexWarehouse = -1;
                }"
                            autocomplete="off">
                    </div>
                    @if ($selectedWarehouse === null)
                        @if ($resultwarehouse)
                            <div class="dropdown-menu d-block py-0">
                                @foreach ($resultwarehouse as $index => $item)
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexWarehouse === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link"
                                                :class="{ 'text-white': selectedIndexWarehouse === {{ $index }} }"
                                                wire:click="selectWarehouseByClick('{{ $item->code }}')">
                                                {{ $item->code }} || {{ $item->name }}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    @endif
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="textAreaInput">Note</label>
                        <textarea class="form-control rounded" id="textAreaInput" placeholder="Enter details" rows="1"
                            style="width: 500px;" wire:model.live="remarks" autocomplete="off"></textarea>
                        @error('remarks')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        @if ($selectedWarehouse)
            <div class="row mt-2">

                <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouseto: null }" x-init="selectedIndexWarehouseto = -1">
                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            <label for="searchItemInput">To Store/Warehouse</label>
                            <input type="text" class="form-control rounded"
                                wire:model.debounce.100ms.live="searchwarehouseto" id="searchWarehouseInput"
                                placeholder="Search Warehouse"
                                @keydown.arrow-down.prevent="selectedIndexWarehouseto = Math.min(selectedIndexWarehouseto + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexWarehouseto = Math.max(selectedIndexWarehouseto - 1, -1)"
                                x-on:keydown.enter="
                    if(selectedIndexWarehouseto == -1) {
                    }else{
                        $wire.selectWarehouseto(selectedIndexWarehouseto);
                        selectedIndexWarehouseto = -1;
                    }"
                                autocomplete="off">
                        </div>
                        @if ($selectedWarehouseto === null)
                            @if ($resultwarehouseto)
                                <div class="dropdown-menu d-block py-0">
                                    @foreach ($resultwarehouseto as $index => $item)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexWarehouseto === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndexWarehouseto === {{ $index }} }"
                                                    wire:click="selectWarehousetoByClick('{{ $item->code }}')">
                                                    {{ $item->code }} || {{ $item->name }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
                <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexItem: null }" x-init="selectedIndexItem = -1">
                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            <label for="searchItemInput">Item</label>
                            <input type="text" class="form-control rounded"
                                wire:model.live="searchitem" id="searchItemInput"
                                placeholder="Select Item"
                                @keydown.arrow-down.prevent="selectedIndexItem = Math.min(selectedIndexItem + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexItem = Math.max(selectedIndexItem - 1, -1)"
                                x-on:keydown.enter="
                    if(selectedIndexItem == -1) {
                             $wire.selectItemByBarcode();
                    }else{
                        $wire.selectItem(selectedIndexItem);
                        selectedIndexItem = -1;
                    }"
                                autocomplete="off">
                        </div>
                        @if ($selectedItem === null)
                            @if ($resultitem)
                                <div class="dropdown-menu d-block py-0">
                                    @foreach ($resultitem as $index => $item)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexItem === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndexItem === {{ $index }} }"
                                                    wire:click="selectItemByClick('{{ $item->code }}')">
                                                    {{ $item->code }} || {{ $item->name }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card-body">
                        <div class="py-12">
                            <div class="table-responsive head-table-no-suggestion">
                                {{-- <table id="example" --}}
                                <table class="my-table" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                            <th scope="col">{{ __('Kode') }}</th>
                                            <th scope="col">{{ __('Kode Bar') }}</th>
                                            <th scope="col">{{ __('Nama') }}</th>
                                            <th scope="col">{{ __('Qty') }}</th>
                                            <th scope="col">{{ __('Harga') }}</th>
                                            <th scope="col" style="border-top-right-radius: 1rem">
                                                {{ __('Aksi') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="small">
                                        @forelse ($tableItems as $index => $item)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $item['code'] }}</td>
                                                <td>{{ $item['barcode'] }}</td>
                                                <td>{{ $item['name'] }}</td>
                                                <td>
                                                    <input type="number"
                                                        wire:model.live="tableItems.{{ $index }}.quantity"
                                                        class="form-control" min="1">
                                                </td>
                                                <td>Rp. {{ number_format($item['price'], 0, ',', '.') }}</td>
                                                <td>
                                                    <button type="button"
                                                        onclick="handleremoveItem('{{ $index }}');"
                                                        class="btn btn-danger btn-sm">Delete</button>
                                                </td>
                                            </tr>
                                        @empty
                                        @endforelse


                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-between mt-4">
                <h5 class="mt-2">Total Quantity : {{ array_sum(array_column($tableItems, 'quantity')) }}</h5>
                <button wire:click="savetoTable" class="btn btn-primary"
                    @if (!$tableItems) disabled @endif>Save</button>
            </div>

        @endif
    </div>
    @livewireScripts()
    <script>
        function handleremoveItem(index) {
            Livewire.dispatch('removeItem', {
                index: index
            });
        }

        Livewire.on('refreshDatatable', (params) => {
            setTimeout(() => {
                $(document).ready(function() {
                    $.fn.dataTable.ext.errMode = 'none';
                    new DataTable('#example', {
                        order: [],
                    });
                });
            }, 1000); // 1000 milliseconds = 1 second
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>
