<div wire:ignore.self class="modal fade" id="modalAddItemReq" data-bs-backdrop="static" tabindex="-1"
    aria-labelledby="modalAddItemReqLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalAddItemReqLabel">Add Item IT Req</h5>
                <div id="loadingSpinner" class="spinner-border text-primary" role="status" style="display: none;">
                    <span class="visually-hidden">Loading...</span>
                </div>
                @if ($isloading)
                    <div id="loadingSpinner" class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                @endif
            </div>
            <div class="mt-2 mx-2 row align-items-center">
                <div class="col-lg-10">
                    <label>Item Code</label>
                    <input type="text" class="form-control" wire:model.live="itemcode">
                    <span class="text-danger">{{ $errMsg }}</span>
                </div>
                <div class="col-lg-2 mt-4">
                    <button type="button" class="btn btn-primary" wire:click="firstClick"
                        @if ($isloading) disabled="true" @endif>Check</button>

                </div>

            </div>
            @if ($barcode && $itemname !== '')
                <hr>
                <div class="mx-2 row align-items-center">
                    <div class="col-lg-12">
                        <label>Barcode</label>
                        <input type="text" class="form-control" wire:model.live="barcode" disabled>
                    </div>
                    <div class="col-lg-12">
                        <label>Name</label>
                        <input type="text" class="form-control" wire:model.live="itemname" disabled>
                    </div>
                    <div class="col-lg-12">
                        <label>Qty</label>
                        <input type="number" class="form-control" wire:model.live="qty">
                    </div>

                </div>
            @endif

            <div wire:ignore.self class="modal-footer mt-4">
                <button type="button" wire:click="closeButton" id="closeSyncAll" class="btn btn-danger" data-bs-dismiss="modal"
                    @if ($isloading) disabled="true" @endif>Close</button>
                <button type="button" wire:click="save" class="btn btn-primary"
                    @if ($isloading || $barcode == '') disabled="true" @endif>Save</button>
            </div>
        </div>
    </div>
</div>
@livewireScripts

<script>
    Livewire.on('closeButton', () => {
            var closeButton = document.getElementById('closeSyncAll');
            if (closeButton !== null) {
                closeButton.click();
            }
        });
    
</script>
