<div class="min-h-screen flex items-center justify-center bg-gray-100">
    <div class="max-w-md w-full p-6 bg-white rounded-lg shadow-lg">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold mb-2">Set Up Your Password</h2>
            <p class="text-gray-600">Please create a password for your supplier dashboard account.</p>
        </div>

        <form wire:submit.prevent="setPassword" class="space-y-6">
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                <input type="email" id="email" wire:model="email" class="form-control" disabled>
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                <input type="password" id="password" wire:model="password" class="form-control @error('password') is-invalid @enderror">
                @error('password')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label for="password_confirmation" class="block text-sm font-medium text-gray-700">Confirm Password</label>
                <input type="password" id="password_confirmation" wire:model="password_confirmation" 
                    class="form-control @error('password_confirmation') is-invalid @enderror">
                @error('password_confirmation')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <button type="submit" class="w-full btn btn-primary">
                Set Password
            </button>
        </form>
    </div>

    <script>
        document.addEventListener('livewire:initialized', () => {
            @this.on('redirect', () => {
                setTimeout(() => {
                    window.location.href = '/supplier/login';
                }, 2000);
            });
        });
    </script>
</div> 