<div class="container py-5">
    <div class="row justify-content-center g-4">
        <div class="col-md-6">
            <div class="card h-100 border-0 position-relative">
                <div class="pricing-icon bg-success bg-opacity-50 d-flex justify-content-center align-items-center">
                    <img src="{{ asset('assets/favicon/android-chrome-192x192.png') }}" style="width: 60px; height: 60px;">
                </div>
                <div class="rounded-top-3 card-header bg-success bg-opacity-10 text-center pt-5">
                    <h3 class="text-success">{{ $paketBasic->name }}</h3>
                </div>
                <div class="card-body text-center">
                    <h4 class="mb-0">
                        Rp. {{ number_format($paketBasic->priceMonth, 2, ',', '.') }} / month
                    </h4>
                    <div class="text-muted small">
                        Save {{ number_format(($paketBasic->priceMonth * 12) - $paketBasic->priceYear, 2, ',', '.') }} per tahun
                    </div>
                    <div class="fw-bold mb-3">
                        Rp. {{ number_format($paketBasic->priceYear, 2, ',', '.') }} / year
                    </div>
                    <button class="btn btn-light border w-100 mb-4" 
                            {{ $company->plan == $paketBasic->name ? 'disabled' : '' }}
                            wire:click="setPaketId('{{ $paketBasic->id }}', true)">
                        {!! $company->plan == $paketBasic->name ? '<i class="bi bi-check-circle-fill text-success"></i>' : 'Downgrade' !!}
                    </button>
                    <p class="text-muted mb-4">
                        For startups with standard features
                    </p>
                    <ul class="feature-list text-start">
                        @if(isset($paketBasic->features))
                            @foreach($paketBasic->features as $feature)
                                <li>{{ $feature }}</li>
                            @endforeach
                        @else
                            <li>No features available</li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card h-100 border-0 premium position-relative">
                <div class="pricing-icon bg-info bg-opacity-50 d-flex justify-content-center align-items-center">
                    <img src="{{ asset('assets/favicon/android-chrome-192x192.png') }}" style="width: 60px; height: 60px;">
                </div>
                <div class="best-value">Best Value</div>
                <div class="rounded-top-3 card-header bg-info bg-opacity-10 text-center pt-5">
                    <h3 class="text-info">{{ $paketPro->name }}</h3>
                </div>
                <div class="card-body text-center">
                    <h4 class="mb-0">Rp. {{ number_format($paketPro->priceMonth, 2, ',', '.') }} / month</h4>
                    <div class="text-muted small">Save {{ number_format(($paketPro->priceMonth * 12) - $paketPro->priceYear, 2, ',', '.') }} per year</div>
                    <div class="fw-bold mb-3">Rp. {{ number_format($paketPro->priceYear, 2, ',', '.') }} / year</div>
                    <button class="btn btn-light border w-100 mb-4" 
                            {{ $company->plan !== 'Basic' ? 'disabled' : '' }}
                            wire:click="setPaketId('{{ $paketPro->id }}', false)">
                        {!! $company->plan !== 'Basic' ? '<i class="bi bi-check-circle-fill text-success"></i>' : 'Upgrade' !!}
                    </button>
                    <p class="text-muted mb-4">
                        For growing businesses with full features and unlimited device access
                    </p>
                    <ul class="feature-list text-start">
                        @if(isset($paketPro->features))
                            @foreach($paketPro->features as $feature)
                                <li>{{ $feature }}</li>
                            @endforeach
                        @else
                            <li>No features available</li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
    @if ($isVisible)
        <livewire:payment.modal-upgrade />
    @endif
</div>
@livewireScripts()
<script>
    Livewire.on('openTheModal', function() {
        $('#upgradeModal').modal('show');
    });

    Livewire.on('openConfirmUpgradeModal', () => {
        $('#confirmUpgradeModal').modal('show');
    });

    Livewire.on('show-ppn-modal', () => {
        $('#upgradeModal').modal('hide');
        $('#ppnModal').modal('show');
    });

    Livewire.on('show-payment-modal', () => {
        $('#ppnModal').modal('hide');
        $('#upgradeModal').modal('show');
    });

    Livewire.on('close-modals', () => {
        $('#ppnModal').modal('hide');
        $('#upgradeModal').modal('hide');
        $('#confirmUpgradeModal').modal('hide');
    });
</script>
