<div>
    <div wire:ignore.self class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="paymentModalLabel">Select Package</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p class="text-muted small mb-4">
                        Please contact support for Special Extension Promo
                    </p>

                    <div class="accordion mb-4" id="packageAccordion">
                        <!-- Plan Accordion -->
                        <div class="accordion-item border-0 mb-3">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#packageAccordionPlan">
                                    <img src="{{ asset('assets/favicon/android-chrome-192x192.png') }}" class="me-2" style="width: 24px; height: 24px;">
                                    {{ $company->plan }}
                                </button>
                            </h2>
                            <div id="packageAccordionPlan" class="accordion-collapse collapse show"
                                data-bs-parent="#packageAccordion">
                                <div class="accordion-body">
                                    @foreach ($price as $item)
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="radio" name="package"
                                                id="package{{ $loop->index }}" wire:model.live="selectedPackage"
                                                value="{{ $item->id }}">
                                            <label class="form-check-label d-flex justify-content-between"
                                                for="package{{ $loop->index }}">
                                                <span>{{ $item->name }}</span>
                                                <span class="package-price">IDR
                                                    {{ number_format($item->price, 2, ',', '.') }}</span>
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="accordion mb-4" id="userAccordion">
                            <div class="accordion-item border-0 mb-3">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#userList">
                                        <i class="bi bi-person me-2"></i> Delete User
                                    </button>
                                </h2>
                                <div id="userList" class="accordion-collapse collapse show" data-bs-parent="#userAccordion">
                                    <div class="accordion-body">
                                        @foreach ($allRegularUser as $user)
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" 
                                                       id="user{{ $user->code }}" 
                                                       wire:model.live="excludedUsers" 
                                                       value="{{ $user->code }}">
                                                <label class="form-check-label" for="user{{ $user->code }}">
                                                    {{ $user->username }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>

                    <div class="border-top pt-3 mb-4">
                        <div class="d-flex justify-content-between">
                            <strong>Total Payment</strong>
                            <strong>Rp {{ number_format($total, 2, ',', '.') }}</strong>
                        </div>
                        @if ($selectedPackage)
                            <p class="text-muted small">
                                The total amount to be paid is calculated from
                                {{ number_format($item->price, 2, ',', '.') }} x
                                {{ $allUser->count() - count($excludedUsers) }} users.
                            </p>
                        @endif
                    </div>
                    
                    <button class="btn btn-primary w-100 py-2" wire:click="openPpnModal"
                        @if (is_null($selectedItem)) disabled @endif>
                        Pay Now →
                    </button>                    
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="ppnModal" tabindex="-1" aria-labelledby="ppnModalLabel" aria-hidden="true"
        wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ppnModalLabel">Payment Confirmation</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h6 class="mb-3">Select Payment Type:</h6>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="radio" name="paymentType" id="individual"
                            value="individual" wire:model.live="paymentType">
                        <label class="form-check-label" for="individual"><strong>Individual (No VAT)</strong></label>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="radio" name="paymentType" id="business"
                            value="business" wire:model.live="paymentType">
                        <label class="form-check-label" for="business"><strong>Business (With VAT
                                {{ $selectedItem ? $selectedItem->ppn : 0 }}%)</strong></label>
                    </div>
                    <p class="text-muted small">
                        Select the payment type based on your needs. If you choose
                        <strong>'Individual'</strong>, no VAT will be applied. However, if you select
                        <strong>'Business'</strong>, a VAT of
                        <strong>{{ $selectedItem ? $selectedItem->ppn : 0 }}%</strong> will be added to the total
                        payment.
                    </p>
                    <hr>
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Initial Total</strong>
                        <strong>Rp {{ number_format($total, 2, ',', '.') }}</strong>
                    </div>
                    <div class="d-flex justify-content-between">
                        <strong>Total Payment</strong>
                        <strong>Rp {{ number_format($totalWithPPN, 2, ',', '.') }}</strong>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="backToPaymentModal">Back</button>
                    <button type="button" class="btn btn-primary" wire:click="createDataPay"
                        wire:loading.attr="disabled">Confirm</button>
                </div>
            </div>
        </div>
    </div>

</div>
@livewireScripts()
<script>
    Livewire.on('show-ppn-modal', () => {
        $('#paymentModal').modal('hide');
        $('#ppnModal').modal('show');
    });

    Livewire.on('show-payment-modal', () => {
        $('#ppnModal').modal('hide');
        $('#paymentModal').modal('show');
    });

    Livewire.on('close-modals', () => {
        $('#ppnModal').modal('hide');
        $('#paymentModal').modal('hide');
    });
</script>
