<div wire:ignore.self class="modal fade" id="modalEditDiscount" aria-hidden="true" aria-labelledby="modalEditDiscountLabel" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditDiscountLabel">Edit Discount</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div x-data="discountInput()" class="modal-body">
                <div class="form-group">
                    <label for="discountType">Discount Type</label>
                    <select wire:model.live="discountType" id="discountType" class="form-control mb-2">
                        <option value="percent">Percentage (%)</option>
                        <option value="value">Amount (Rp)</option>
                    </select>
                </div>
            
                <div class="form-group">
                    <label for="discountValue">Enter Discount</label>
                    <input type="text" 
                        x-model="formattedValue"
                        x-on:input="formatInput($event)"
                        x-on:blur="ensureNotNull()"
                        id="discountValue" 
                        wire:model.live="discountValue"
                        class="form-control mb-2">
                    @error('discountValue')
                        <small class="text-danger d-block mt-1">{{ $message }}</small>
                    @enderror
                </div>
            
                <div class="form-group">
                    <label>Original Price: </label>
                    <strong>Rp{{ number_format($selectedCart?->price ?? 0, 0, ',', '.') }}</strong>
                </div>
            
                <div class="form-group">
                    <label>Price After Discount: </label>
                    <strong>Rp{{ number_format($finalPrice, 0, ',', '.') }}</strong>
                </div>
            </div>
            
            <script>
                function discountInput() {
                    return {
                        rawValue: 0,
                        formattedValue: '0',
                        formatInput(event) {
                            let input = event.target.value.replace(/\D/g, ""); 
                            this.rawValue = input ? parseInt(input) : 0;
                            this.formattedValue = this.rawValue.toLocaleString("id-ID");
                        },
                        ensureNotNull() {
                            if (!this.rawValue) {
                                this.rawValue = 0;
                                this.formattedValue = '0';
                            }
                        }
                    };
                }
            </script>
            
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button class="btn btn-primary" wire:click="confirmUpdateDiscount"
                    data-bs-dismiss="modal">Save</button>
            </div>
        </div>
    </div>
</div>