<div wire:ignore.self class="modal fade" id="welcomeModalGreeting" tabindex="-1" aria-labelledby="welcomeModalLabel"
    aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered custom-width">
        <div class="modal-content rounded-4 border-0">
            <div class="modal-body text-center p-5">
              
                <p class="mb-4">Please complete your company information or skip.</p>

                <div>
                    <div class="mb-3 text-start">
                        <label for="nama_perusahaan" class="form-label">Company Name</label>
                        <input type="text" wire:model.defer="nama_perusahaan" class="form-control"
                            id="nama_perusahaan">
                        @error('nama_perusahaan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="mb-3 text-start">
                        <label for="alamat" class="form-label">Address</label>
                        <textarea wire:model.defer="alamat" class="form-control" id="alamat" rows="2"></textarea>
                        @error('alamat')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="mb-4 text-start">
                        <label for="no_hp" class="form-label">Phone Number</label>
                        <input type="number" wire:model.defer="no_hp" class="form-control" id="no_hp">
                        @error('no_hp')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-center gap-3">
                        <button type="button" class="btn btn-secondary px-4" data-bs-dismiss="modal">
                            Skip
                        </button>

                        <button type="button" wire:click="save" class="btn btn-primary px-4">Save</button>
                    </div>
                </div>

                <p class="text-muted mt-4 mb-0">
                    Need help? Contact our support team at
                    <a href="https://wa.me/6285117031010?text=Hello,%20mau%20tanya%20dong%20min."
                        class="text-decoration-none fw-bold" target="_blank">+62 851 1703 1010</a>.
                </p>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Enter') {
                Livewire.dispatch('saveEnter');
                $('#welcomeModalGreeting').modal('hide');
            }
        });
    });
</script>
