<div class="justify-content-center">
    <h1>{{ session('Promo-Voucher-Cashback' . auth()->user()->id) }}</h1>
    <div class="col">
        <div>
            <div
                @if ($isSuggestion) class="card-body head-table" @else class="card-body head-table-no-suggestion" @endif>
                <table class="my-table table-cashier-pop" style="width:100%">
                    <thead>
                        <tr>
                            <th style="border-top-left-radius: .5rem">Code</th>
                            <th>Name</th>
                            <th class="text-center">Qty</th>
                            <th class="text-center">Price (Rp)</th>
                            <th class="text-center">Discount (Rp)</th>
                            <th class="text-center">Subtotal (Rp)</th>
                            <th class="text-center" style="border-top-right-radius: .5rem"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($carts as $key => $cart)
                            <tr wire:key="cart-{{ $cart['id'] }}">
                                <td class="fw-semibold">{{ $cart['code'] }}</td>
                                <td data-bs-toggle="modal" data-bs-target="#modalCart" style="cursor: pointer">
                                    {{ $cart['name'] }}
                                </td>
                                <td width="80px" style="display: flex; align-items: center; gap: 5px;">
                                    <input class="form-control form-control-sm bg-transparent" type="number"
                                        id="{{ $cart['code'] }}"
                                        wire:change="sameCart({{ $cart['id'] }}, $event.target.value)"
                                        @if ($cart['unit'] != 0) value="{{ $cart['qty_unit'] }}" @else value="{{ $cart['qty'] }}" @endif
                                        onchange="updateQuantity(this, {{ $cart['id'] }})"
                                        onpaste="handlePaste(event)" @if (!Str::startsWith($cart['code'], ['FG', 'BUY', 'VOUCHER'])) min="1" @endif
                                        @if ($cart['maxpack'] == 'N' || $cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free' || Str::contains($cart['name'], '( Pack')) disabled @endif style="flex: 1 0 auto;">

                                    <select class="form-control form-control-sm input-group bg-transparent" @if( Str::contains($cart['name'], '( Pack')) disabled @endif
                                        id="type" onchange="resetQuantityToOne('{{ $cart['code'] }}')"
                                        wire:model="isCarts.{{ $key }}.unit"
                                        wire:change="handleUnitChange('{{ $key }}', $event.target.value)"
                                        style="flex: 1 0 auto;">
                                        <option value="0" @if ($cart['unit'] == 0) selected @endif>pcs
                                        </option>

                                        @foreach ($cart['units'] as $unit)
                                            <option value="{{ $unit->id }}">
                                                {{ $unit->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                </td>


                                <td style="text-align: center;">
                                    <div class="d-flex justify-content-evenly">
                                        @if ($isEnabledEditPrice)
                                            <span class="badge bg-success" style="cursor:pointer;"
                                                data-bs-toggle="modal" data-bs-target="#modalEditPrice"
                                                x-on:click="$wire.dispatch('setHarga', { id: {{ $cart['id'] }} })">
                                                Edit
                                            </span>
                                        @endif
                                        <span class="mr-5">
                                            {{ number_format($cart['nprice'], 0, ',', '.') }}
                                        </span>
                                    </div>
                                </td>
                                <td style="text-align: center;">
                                    <div class="d-flex justify-content-evenly">
                                        @if ($isEnabledEditDiscount && $cart['promo'] == 0)
                                            <span class="badge bg-success" style="cursor:pointer;"
                                                data-bs-toggle="modal" data-bs-target="#modalEditDiscount"
                                                x-on:click="$wire.dispatch('setDiscount', { id: {{ $cart['id'] }} })">
                                                Edit
                                            </span>
                                        @endif
                                        <span class="mr-5">
                                            {{ number_format($cart['nprice'] - $cart['price'], 0, ',', '.') }}
                                        </span>
                                    </div>
                                </td>

                                @if ($cart['unit'] == 0)
                                    <td style="text-align: center;">
                                        {{ number_format($cart['price'] * $cart['qty'], 0, ',', '.') }}</td>
                                @else
                                    <td style="text-align: center;">
                                        {{ number_format($cart['total_price'], 0, ',', '.') }}</td>
                                @endif
                                <td class="text-center">
                                    <button class="btn btn-warning btn-sm"
                                        wire:click="moveToLoseSale({{ $cart['id'] }})">Lost Sale</button>
                                </td>

                            </tr>
                        @empty
                            <tr class="text-center" width="100%">
                                <td colspan="6">
                                    Empty
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <button id="triggerOffcanvas" class="d-none" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasRight" aria-controls="offcanvasRight"></button>
                </table>
            </div>
        </div>
    </div>

    <div wire:key="{{ $refreshKey }}">
        @if ($isSuggestion)
            <div class="container mt-4">
                <h3 class="mb-4 text-center">{{ $suggestionName }}</h3>
                <div class="row">
                    @foreach ($suggestion as $index => $item)
                        <div class="col-md-4">
                            <div class="card border-0 shadow animate__animated" style="background-color: #EEF6F9"
                                x-data="{ isFadeOut: false }"
                                :class="{ 'animate__fadeInRight': !isFadeOut, 'animate__fadeOutLeft': isFadeOut }"
                                x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                x-transition:leave="animate__fadeOutLeft duration-300ms"
                                x-transition:leave-end="opacity-0">
                                <div class="suggestion-card">
                                    <h6 class="suggestion">{{ $item['name'] }} ( Pack {{ $item['pack'] }} )</h6>
                                    <h6 class="suggestion">{{ $item['barcode'] }} </h6>
                                    @if ($index === 0)
                                        <div class="add-to-cart"
                                            wire:click="addSuggestionFirst('{{ $item['code'] }}', '{{ $item['no'] }}')"
                                            @click="isFadeOut = true">
                                            Add to Cart
                                        </div>
                                    @else
                                        <div class="add-to-cart"
                                            wire:click="addSuggestion('{{ $item['code'] }}', '{{ $item['no'] }}')"
                                            @click="isFadeOut = true">

                                            Add to Cart
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
    <div style="border-radius: 0.25rem;">
        <div class="row body-charsier-3">

            <div x-data="{ selectedIndexSales: null }" x-init="selectedIndexSales = -1">

                <div
                    class="d-flex gap-5 @if (!$isDisabledSales) justify-content-between @else justify-content-end @endif">
                    @if (!$isDisabledSales)
                        <div class="col-md-4 sales-emp-pop">
                            <div class="d-flex align-items-center">
                                <label class="font-salesEmp">Sales Employee </label>
                                <h6 class="shortcut">F3</h6>
                                {{-- <button class="badge bg-primary ms-2" data-bs-toggle="modal"
                                    data-bs-target="#salesEmployeeCreateModal">Buat Sales</button> --}}
                            </div>

                            <input type="text" class="form-control fw-medium mt-2" id="sales_employee"
                                wire:model.live="form.sales" placeholder="No Sales" hidden>
                            <input type="text" class="form-control fw-medium mt-2" id="sales_employee"
                                wire:model.debounce.100ms.live="searchsales" placeholder="No Sales" autofocus
                                autocomplete="off"
                                @keydown.arrow-down.prevent="selectedIndexSales = Math.min(selectedIndexSales + 1, {{ count($sales) - 1 }})"
                                @keydown.arrow-up.prevent="selectedIndexSales = Math.max(selectedIndexSales - 1, -1)"
                                x-on:keydown.enter="
                                if(selectedIndexSales == -1) {
                                    $wire.modalCreateSales();
                                } else {
                                    $wire.selectSales(selectedIndexSales);
                                    selectedIndexSales = -1; 
                                }">
                            @if ($selectedSales === null && $isDropdownsalesVisible)
                                <div class="dropdown-menu border-dark-subtle d-block py-0">
                                    @foreach ($sales as $index => $sale)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexSales === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    wire:click="selectSalesByClick('{{ $sale->code }}')"
                                                    :class="{ 'text-white': selectedIndexSales === {{ $index }} }">
                                                    {{ $sale->code }} || {{ $sale->name }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    @endif

                    <div class="shadow-md" id="pay-container" style="">
                        <div class="quantity-pop qty-sub-2">
                            <div>
                                <h3 class="font-salesEmp">Quantity</h3>
                                <h3 class="sub-total">
                                    {{ $carttotal->sum('qty') }}
                                </h3>
                            </div>
                        </div>

                        <div class="subtotal-pop qty-sub">
                            <div>
                                <h3 class="font-salesEmp">Grand Total</h3>
                                <h3 class="sub-total">
                                    @if ($carttotal->isEmpty())
                                        Rp
                                    @else
                                        {{ 'Rp ' . number_format($carttotal->sum('total_price'), 0, ',', '.') }}
                                    @endif
                                </h3>
                            </div>
                        </div>
                        <div class="text-primary text-right"
                            style="display: flex; justify-content: flex-start !important;">
                            @if ($this->selectedSales === null && !$isDisabledSales)
                                <div class="pay-button-pop"
                                    style="display: flex; justify-content: end; align-items: center">
                                    <button type="button" onclick="openModalSales()" class="button-try">
                                        <div class="d-flex gap-4 justify-content-center align-items-center ">
                                            <div class="text-white ">PAY</div>
                                            <h6
                                                style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; fw-bold">
                                                F4
                                            </h6>
                                        </div>
                                    </button>
                                </div>
                            @else
                                <div class="pay" style="display: flex; justify-content: end; align-items: center">
                                    <button type="button"
                                        @if (!empty($carts)) data-bs-toggle="modal" 
                                data-bs-target="#invoiceModal" 
                                @else 
                                wire:click="cartEmpty" @endif
                                        class="button-try">
                                        <div class="d-flex gap-4 justify-content-center align-items-center ">
                                            <div class="text-white ">PAY</div>
                                            <h6 class="fst-italic"
                                                style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; fw-bold">
                                                F4
                                            </h6>
                                        </div>
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <input type="hidden" wire:keydown.window.shift.backspace="deleteLatestCart">
    <div wire:ignore.self class="modal fade" id="modalCart" tabindex="-1" aria-labelledby="modalCartLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCartLabel">Carts</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th class="text-center">#</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($carts as $cart)
                                <tr wire:key="cart-{{ $cart['id'] }}">
                                    <td>{{ $cart['code'] }}</td>
                                    <td>{{ $cart['name'] }}</td>
                                    <td>
                                        {{ 'Rp ' . number_format($cart['price'], 0, ',', '.') }}
                                    </td>
                                    <td width="80px">
                                        <input class="form-control quantity-input" type="number"
                                            id="{{ $cart['code'] }}"
                                            wire:change="sameCart({{ $cart['id'] }}, $event.target.value)"
                                            value="{{ $cart['qty'] }}"
                                            onchange="updateQuantity(this, {{ $cart['id'] }})"
                                            onpaste="handlePaste(event)"
                                            @if (!Str::startsWith($cart['code'], ['FG', 'BUY', 'VOUCHER'])) min="1" @endif
                                            @if ($cart['maxpack'] == 'N' || $cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free' || Str::contains($cart['name'], '( Pack')) disabled @endif>

                                    </td>
                                    <td class="text-center">
                                        <button wire:click="deleteCart({{ $cart['id'] }})"
                                            wire:loading.attr="disabled" class="btn badge btn-danger" type="button"
                                            {{ $cart['benefit'] == 'Free' || $cart['benefit'] == 'Cheapest' ? 'disabled' : '' }}>
                                            Delete
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr class="text-center" width="100%">
                                    <td colspan="6">
                                        Empty
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight"
        aria-labelledby="offcanvasRightLabel">
        <div class="offcanvas-header">
            <h5 class="mx-4" id="offcanvasRightLabel">Lost Sale</h5>
            <button type="button" class="text-reset mb-2" data-bs-dismiss="offcanvas" aria-label="Close"
                style="font-size: 1.5em; color: inherit; background: none; border: none"> → </button>
        </div>
        <div class="offcanvas-body">
            <div style="height: 450px; max-height: 450px; overflow-y: auto">
                @forelse ($lostSale as $item)
                    <div wire:key="lost-sale-{{ $item->id }}">
                        <p> Item : {{ $item->name }} - {{ $item->barcode }} </p>
                        @if ($item->total_qty <= 0)
                            <p class="text-danger"> No stock </p>
                            <textarea class="form-control" wire:model="keterangan.{{ $item->id }}" placeholder="Note">{{ $item->keterangan }}</textarea>
                        @else
                            <p class="text-success"> Stock available {{ $item->total_qty }} pcs</p>
                        @endif
                        <p><button class="btn badge btn-danger mt-2"
                                wire:click="moveToCart({{ $item->id }})">Cancel</button></p>
                        <hr>
                    </div>
                @empty
                    <div class="text-center">
                        <p>No lost sale</p>
                    </div>
                @endforelse
            </div>

            <div x-data="{ isInputGroupVisible: false }">
                <div class="mx-4" @click="isInputGroupVisible = !isInputGroupVisible" style="cursor: pointer;"
                    title="Click to enter customer origin">
                    <h5 class="mb-0">Customer Origin</h5>
                    <small class="text-muted"
                        x-text="isInputGroupVisible ? '(Click to close)' : '(Click to open)' "></small>
                </div>
                <hr>
                <div class="form-group row justify-content-center" x-show="isInputGroupVisible">
                    <div class="col-md-4">
                        <div x-data="{
                            open: false,
                            search: '',
                            negaraList: @js($negara),
                            selected: @entangle('selectedNegara'),
                            toggleSelection(code, name, id) {
                                this.selected = [{ code, name, id }];
                            },
                            isChecked(code) {
                                return this.selected.some(item => item.code === code);
                            },
                            getSelectedText() {
                                return this.selected.length > 0 ? this.selected[0].name : 'Country';
                            },
                            focusSearchInput() {
                                this.$refs.searchInputNegara.focus();
                            }
                        }" @click.away="open = false">
                            <label for="typeCardCode">Country</label>
                            <button class="form-control text-start"
                                x-on:click="open = ! open; $nextTick(() => focusSearchInput())"
                                x-text="getSelectedText()"></button>
                            <div x-show.important="open" x-transition
                                class="form-control dropdown-menu d-block py-0 w-auto px-2"
                                style="max-height: 200px; overflow-y: auto;">
                                <div class="p-2">
                                    <input type="text" x-ref="searchInputNegara" x-model="search"
                                        placeholder="Search Country..." class="form-control">
                                </div>
                                <template
                                    x-for="(negara, index) in negaraList.filter(n => n.name.toLowerCase().includes(search.toLowerCase()))"
                                    :key="negara.code">
                                    <div class="ms-4">
                                        <input type="radio" :id="'radio' + (index + 1)" name="negara"
                                            :value="negara.code" :checked="isChecked(negara.code)"
                                            x-on:change="toggleSelection(negara.code, negara.name, negara.id)">
                                        <label class="ms-2" :for="'radio' + (index + 1)">
                                            <span x-text="negara.name"></span> - (<span x-text="negara.code"></span>)
                                        </label>
                                    </div>
                                </template>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label for="Usia">Age <span class="text-danger">(±)</span></label>
                        <input type="number" wire:model="usia" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label for="gender">Gender</label>
                        <select id="gender" name="gender" class="form-control" wire:model="gender">
                            <option value="Man">Man</option>
                            <option value="Ladies">Ladies</option>
                            <option value="Couple">Couple</option>
                        </select>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input type="checkbox" id="lihat" class="form-check-input" wire:model="lihat">
                                <label class="form-check-label" for="lihat">Just browsing</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input type="checkbox" id="coba" class="form-check-input" wire:model="coba">
                                <label class="form-check-label" for="coba">Wants to try</label>
                            </div>
                        </div>
                    </div>

                    <div class="mt-2 col-md-12">
                        <label for="gender">Note</label>
                        <textarea class="form-control" name="" id="" cols="30" rows="7"
                            wire:model="description"></textarea>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-end">
                <button class="btn btn-primary mt-2" wire:click="saveLostSale">Save</button>

            </div>
        </div>
    </div>
    <livewire:pos.employee.modal-create-employee />
    <livewire:modals.edit-price-modal />
    <livewire:modals.edit-discount-modal />
    <div class="modal fade" id="youtubeModal" tabindex="-1" aria-labelledby="youtubeModalLabel"
        aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="youtubeModalLabel">Welcome Video</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="closeModalTutorial"></button>
                </div>
                <div class="modal-body p-0">
                    <div class="ratio ratio-16x9 h-100">
                        <iframe src="https://www.youtube.com/embed/02QAwEqm6Bw?si=LlH-NqQmnPQ1vPYB&rel=0" 
                            title="Langkah mudah menggunakan softcomp"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                            referrerpolicy="strict-origin-when-cross-origin"
                            allowfullscreen
                            style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: 0;">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



@livewireScripts
<script>
    Livewire.on('openModalTutorial', () => {
        $('#youtubeModal').modal('show');
    });

    Livewire.on('redirectToRefresh', () => {
        setTimeout(() => {
            window.location.reload();
        }, 1000);
    });

    function openModalSales() {
        $('#salesModal').modal('show');

        setTimeout(() => {
            $('#searchSalesModal').val('');
        }, 300);
    }

    function updateQuantity(input, cartId) {
        var code = input.id;
        var quantity = parseInt(input.value);

        if (!code.startsWith('FG') && !code.startsWith('BUY') && !code.startsWith('VOUCHER')) {
            if (isNaN(quantity) || quantity < 1) {
                quantity = 1;
            }
        }
        input.value = quantity;
    }

    function handlePaste(event) {
        var clipboardData, pastedData;

        event.stopPropagation();
        event.preventDefault();

        clipboardData = event.clipboardData || window.clipboardData;
        pastedData = clipboardData.getData('Text');

        var parsedValue = parseFloat(pastedData);
        if (!isNaN(parsedValue) && parsedValue >= 0) {
            var input = event.target;
            input.value = parsedValue;
            input.dispatchEvent(new Event('input'));
        }
    }

    window.addEventListener('keydown', function(event) {
        if (event.key === 'F3') {
            event.preventDefault();
            if (@this.modalOpen) {
                // Dispatch F3 modal open event
                Livewire.dispatch('F3ModalOpen');
            } else if (!@this.isDisabledSales) {
                // Open sales modal if not disabled
                @this.salesModal();
            } else if (@this.isDisabledSales) {
                if (@this.isCarts.length > 0) {
                    @this.createInvoice();
                } else {
                    @this.cartEmpty();
                }
            }
        }

        if (event.key === 'F4') {
            event.preventDefault();

            if (!@this.isSalesModalVisible) {
                if (@this.modalOpen) {
                    Livewire.dispatch('F4ModalOpen');
                } else if (@this.isCarts.length > 0) {
                    if (@this.selectedSales || @this.isDisabledSales) {
                        @this.createInvoice();
                    } else {
                        @this.salesModal();
                    }
                } else {
                    @this.cartEmpty();
                }
            } else {
                Livewire.dispatch('F4ModalOpen');
            }
        }

        if (event.key === 'End') {
            event.preventDefault();
            document.getElementById('triggerOffcanvas').click();
        }
    });

    Livewire.on('createInvoice', () => {
        $('#invoiceModal').modal('show');
    });
    Livewire.on('closePayment', () => {
        $('#invoiceModal').modal('hide');
        Livewire.dispatch('resetPayment');
    });

    Livewire.on('showCanvas', () => {
        setTimeout(() => {
            document.getElementById('triggerOffcanvas').click();
        }, 500);
    });
    Livewire.on('hideCanvas', () => {
        document.getElementById('triggerOffcanvas').click();
        Livewire.dispatch('successNotification');
    });

    Livewire.on('openModalCreateSales', () => {
        $('#salesEmployeeCreateModal').modal('show');
        $('#salesEmployeeCreateModal').on('shown.bs.modal', function() {
            $('#nik_code').focus();
        });
    });

    function resetQuantityToOne(cartCode) {
        const quantityInput = document.getElementById(cartCode);
        if (quantityInput) {
            quantityInput.value = 1;
        }
    }

    // YouTube Modal Handler
    document.addEventListener('DOMContentLoaded', function() {
        // Check if the video has been shown before
        if (!localStorage.getItem('youtubeVideoShown')) {
            // Replace YOUR_YOUTUBE_VIDEO_ID with your actual YouTube video ID
            const videoId = 'YOUR_YOUTUBE_VIDEO_ID';
            const iframe = document.getElementById('youtubeIframe');
            iframe.src = `https://www.youtube.com/embed/${videoId}?autoplay=1`;

            // Show the modal
            const youtubeModal = new bootstrap.Modal(document.getElementById('youtubeModal'));
            youtubeModal.show();

            // Set flag in localStorage
            localStorage.setItem('youtubeVideoShown', 'true');
        }
    });

    // Handle modal close - stop video playback
    document.getElementById('youtubeModal').addEventListener('hidden.bs.modal', function() {
        const iframe = document.getElementById('youtubeIframe');
        iframe.src = '';
    });
</script>
