<div>
    <!-- Modal -->
    <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="selectDiscount" tabindex="-1"
        aria-labelledby="selectDiscountLabel" aria-hidden="true" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="selectDiscountLabel">{{ $title }}</h5>
                </div>
                <div class="form-check">
                    <div class="modal-body">
                        <div class="card me-3 mt-2">
                            <div @if($selectedPromo == 'normalPrice') class="card-body text-white bg-primary rounded-2" @else class="card-body" @endif>
                                <div class="text-center">
                                    <input class="form-check-input" type="radio" name="promo"
                                    value="normalPrice" id="promoNormal"
                                    wire:model.live="selectedPromo">
                                <label for="promoNormal"
                                    class="form-check-label">Normal Price</label>
                                </div>
                            </div>
                        </div>
                        @forelse ($dataDisc as $data)
                            <div class="card me-3 mt-2">
                                <div @if($selectedPromo == $data['no']) class="card-body text-white bg-primary rounded-2" @else class="card-body" @endif>
                                    <div class="text-center">
                                        <input class="form-check-input" type="radio" name="promo"
                                        value="{{ $data['no'] }}" id="promo{{ $loop->index }}"
                                        wire:model.live="selectedPromo">
                                    <label for="promo{{ $loop->index }}"
                                        class="form-check-label">{{ $data['name'] }}</label>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <p>No data available.</p>
                        @endforelse
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" wire:keydown.window.shift.l="{{ $button }}" wire:click="{{ $button }}"
                        data-bs-dismiss="modal">Select</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    Livewire.on('closeModalDisc', () => {
        $('#selectDiscount').modal('hide');
    });
    Livewire.on('openTheModal', () => {
        setTimeout(() => {
            @this.modalDiscOpen();
            // Focus on the radio button
            var firstRadioButton = document.querySelector('input[type="radio"][name="promo"]');
            if (firstRadioButton) {
                firstRadioButton.focus();
            }
        }, 500); // Adjust the delay as needed after the page has finished reloading
    });
</script>
