<div>
    <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalDiscBundle" tabindex="-1"
        aria-labelledby="modalNewItemLabel" aria-hidden="true" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Process Discount @if ($name !== '')
                            <br><span class="text-primary">{{ $name }}</span>
                        @endif
                    </h5>
                </div>

                <div class="modal-body">
                    <div class="col mb-3" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
                        <div class="form-group">
                            <label class="small text-muted mb-1">Kode Produk</label>
                            <div class="d-flex">
                                <input type="text" id="searchitem" class="form-control" wire:model.live="searchitem"
                                    placeholder="Type to search..." autofocus autocomplete="off"
                                    @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($products) - 1 }})"
                                    @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                    x-on:keydown.enter="
                                if(selectedIndex == -1) {
                                    $wire.selectProductByName();
                                } else {
                                    $wire.selectProduct(selectedIndex);
                                    selectedIndex = -1; 
                                }"
                                @if($promoExclude) disabled @endif
                                >
                            </div>

                            @if ($selectedProduct === null && sizeof($products) > 0)
                                <div class="dropdown-menu d-block py-0" style="width: 770px">
                                    @foreach ($products as $index => $product)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndex === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" wire:click="byClick('{{ $product->code }}')"
                                                    class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndex === {{ $index }} }">
                                                    {{ $product->code }} || {{ $product->name }} ||
                                                    {{ $product->price }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                    <table class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Promo</th>
                                <th>Pack</th>
                                <th>Promo Tipe</th>
                                <th>Benefit</th>
                                <th class="text-center">#</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($carts as $index => $cart)
                                <tr>
                                    <td>{{ $cart['itemcode'] }}</td>
                                    <td>{{ $cart['itemname'] }}</td>
                                    <td>{{ 'Rp ' . number_format($cart['itemprice'], 0, ',', '.') }}</td>
                                    <td>{{ $cart['promo'] }}</td>
                                    <td>{{ $cart['pack'] }}</td>
                                    <td>{{ $cart['promotipe'] }}</td>
                                    <td>{{ $cart['benefit'] }}</td>
                                    <td class="text-center">
                                        <button wire:click="deleteFromCarts({{ $index }})"
                                            class="btn btn-danger" type="button" style="color: white; background-color: #dc3545; border-color: #dc3545;">Delete</button>
                                    </td>
                                </tr>
                            @empty
                                <tr class="text-center" width="100%">
                                    <td colspan="9">Empty</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                    <div class="" wire:key="{{ $refreshKey }}">
                        @if ($isSuggestion && !$promoExclude)
                            <div class="container mt-4">
                                <div class="row">
                                    @foreach ($suggestion as $index => $item)
                                        <div class="col-md-4">
                                            <div class="card border-0 shadow animate__animated"
                                                style="background-color: #EEF6F9" x-data="{ isFadeOut: false }"
                                                :class="{
                                                    'animate__fadeInRight': !
                                                        isFadeOut,
                                                    'animate__fadeOutLeft': isFadeOut
                                                }"
                                                x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                                x-transition:leave="animate__fadeOutLeft duration-300ms"
                                                x-transition:leave-end="opacity-0">
                                                <div class="suggestion-card">
                                                    <h6 class="suggestion">{{ Str::limit($item->name, 18, '...') }}
                                                        <br>( Pack
                                                        {{ $item->pack }} )
                                                    </h6>
                                                    <h6 class="suggestion">{{ $item->barcode }} </h6>
                                                    @if ($index === 0)
                                                        <div class="add-to-cart"
                                                            wire:click="addSuggestionFirst('{{ $item->code }}', '{{ $item->no }}')"
                                                            @click="isFadeOut = true">Add to Cart</div>
                                                    @else
                                                        <div class="add-to-cart"
                                                            wire:click="addSuggestion('{{ $item->code }}', '{{ $item->no }}')"
                                                            @click="isFadeOut = true">Add to Cart</div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                        @endif
                    </div>
                    <div class="modal-footer">
                        
                            @if(!$fulfilled)
                            <button type="button" class="custom-button1" data-bs-dismiss="modal"
                            data-bs-toggle="modal" wire:click="backToTransaction">Back</button>
                            <button type="button" id="saveButton" class="btn btn-danger" wire:click="save"
                            data-bs-dismiss="modal" disabled >Save</button>
                            @else
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"
                            disabled>Back</button>
                        <button type="button" id="saveButton" class="custom-button1" wire:click="save"
                            data-bs-dismiss="modal">Save</button>
                            @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#modalDiscBundle').on('shown.bs.modal', function() {
                trueSuggestion();
            });
        });
    </script>

</div>
