<div class="container">
    <livewire:cashier.transaction />
    <livewire:cashier.welcome-modal />
    <livewire:cashier.welcome-modal-awal />

    <style>
        .modal-backdrop.show {
            opacity: 0.7;
        }

        .modal-content {
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .custom-width {
            max-width: 600px;
            width: 95%;
            margin: auto;
        }

        .btn-primary {
            background-color: #0b5ed7;
            border: none;
            min-width: 120px;
        }

        .btn-primary:hover {
            background-color: #0d6efd;
        }

        .dark-blue {
            color: #0b5ed7;
        }

        .modal.show .modal-dialog {
            transform: scale(1);
        }

        @media (max-width: 768px) {
            .custom-width {
                width: 95%;
                margin: 1rem auto;
            }

            .modal-body {
                padding: 2rem !important;
            }

            .fs-1.5rem {
                font-size: 1.5rem !important;
            }
        }
    </style>

</div>
<script>
    Livewire.on('openModalGreeting', () => {
        $('#welcomeModal').modal('show');
    });
    Livewire.on('afterSaveGreetingFrontendCloseModal', () => {
        $('#welcomeModal').modal('hide');
    });
    Livewire.on('welcomeModalGreeting', () => {
        $('#welcomeModalGreeting').modal('show');
    });
    Livewire.on('closeModalGreetingAwalFrontend', () => {
        $('#welcomeModalGreeting').modal('hide');
    });
    Livewire.on('afterChangeStatusGreeting', () => {
        const cashierPopup = () => {
            const driver = window.driver.js.driver;
            const driverObj = driver({
                showProgress: true,
                steps: [
                    {
                        element: '.item-search-pop',
                        popover: {
                        description: 'Search for the item to be checked by typing its code or name here.'
                        }
                    },
                    {
                        element: '.table-cashier-pop',
                        popover: {
                        description: 'After selecting an item, you can see the list of selected products in this table. You can also adjust the quantity of each item to be checked here.'
                        }
                    },
                    {
                        element: '.quantity-pop',
                        popover: {
                        description: 'View the total quantity of selected items here.'
                        }
                    },
                    {
                        element: '.subtotal-pop',
                        popover: {
                        description: 'This section displays the total price calculated from all the selected items.'
                        }
                    },
                    {
                        element: '.sales-emp-pop',
                        popover: {
                        description: 'Before proceeding to payment, select the sales employee responsible by typing their registered name.'
                        }
                    },
                    {
                        element: '.pay-button-pop',
                        popover: {
                        description: 'Alternatively, you can enter the sales employee’s name by clicking the PAY (F4) button and proceed with the payment process.'
                        }
                    },
                    {
                        element: '.sidebar-pop',
                        popover: {
                        description: 'The sidebar can be accessed by clicking this button.'
                        }
                    },
                    ],

                onDeselected: () => {
                    $.ajax({
                        type: "POST",
                        url: '/update-status-driver',
                        data: {
                            menu: "Cashier",
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {},
                        error: function(data, textStatus, errorThrown) {},
                    });
                }
            });

            driverObj.drive();
        }

        setTimeout(() => {
            cashierPopup();
        }, 800);

    });
</script>
@if ($istutorials)
    <script>
        const cashierPopup = () => {
            const driver = window.driver.js.driver;
            const driverObj = driver({
                showProgress: true,
                steps: [{
                        element: '.item-search-pop',
                        popover: {
                            description: 'Cari barang yang akan diperiksa dengan mengetikkan kode atau nama barang di sini.'
                        }
                    },
                    {
                        element: '.table-cashier-pop',
                        popover: {
                            description: 'Setelah memilih barang, Anda dapat melihat daftar produk yang dipilih di tabel ini. Anda juga dapat menyesuaikan jumlah setiap barang yang akan diperiksa di sini.'
                        }
                    },
                    {
                        element: '.quantity-pop',
                        popover: {
                            description: 'Lihat total jumlah barang yang dipilih di sini.'
                        }
                    },
                    {
                        element: '.subtotal-pop',
                        popover: {
                            description: 'Bagian ini menunjukkan total harga yang dihitung dari semua barang yang akan diperiksa.'
                        }
                    },
                    {
                        element: '.sales-emp-pop',
                        popover: {
                            description: 'Sebelum melanjutkan ke pembayaran, pilih petugas penjualan yang bertanggung jawab dengan mengetikkan nama yang terdaftar.'
                        }
                    },
                    {
                        element: '.pay-button-pop',
                        popover: {
                            description: 'Sebagai alternatif, Anda dapat memasukkan nama petugas penjualan dengan mengklik tombol PAY (F4), kemudian melanjutkan dengan proses pembayaran.'
                        }
                    },
                    {
                        element: '.sidebar-pop',
                        popover: {
                            description: 'Sidebar dapat diakses dengan mengklik tombol ini.'
                        }
                    },
                ],
                onDeselected: () => {
                    $.ajax({
                        type: "POST",
                        url: '/update-status-driver',
                        data: {
                            menu: "Cashier",
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {},
                        error: function(data, textStatus, errorThrown) {},
                    });
                }
            });

            driverObj.drive();
        }
        setTimeout(() => {
            cashierPopup();
        }, 1000);
    </script>
@endif
