<div class="container mt-2">
    @if (session()->has('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <form wire:submit.prevent="register">
        <div class="mb-3">
            <label for="plan" class="form-label">Plan</label>
            <select id="plan" class="form-control rounded-pill @error('plan') is-invalid @enderror" wire:model.live="plan">
                <option value="">Select your plan</option>
                <option value="Basic">Basic</option>
                <option value="Pro">Pro</option>
            </select>
            @error('plan')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
        <div class="mb-3">
            <label for="name" class="form-label">Company name</label>
            <input type="text" id="name" class="form-control rounded-pill @error('name') is-invalid @enderror"
                wire:model.live="name" placeholder="Enter your name">
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="address" class="form-label">Address</label>
            <input type="text" id="address" class="form-control rounded-pill @error('address') is-invalid @enderror"
                wire:model.live="address" placeholder="Enter your address">
            @error('address')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="phone" class="form-label">Phone</label>
            <input type="text" id="phone" class="form-control rounded-pill @error('phone') is-invalid @enderror"
                wire:model.live="phone" placeholder="Enter your phone">
            @error('phone')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" id="email" class="form-control rounded-pill @error('email') is-invalid @enderror"
                wire:model.live="email" placeholder="Enter your email">
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
        <div class="mb-3">
            <label for="name" class="form-label">Username</label>
            <input type="text" id="username" class="form-control rounded-pill @error('username') is-invalid @enderror"
                wire:model.live="username" placeholder="Enter your username">
            @error('username')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="password" id="password" class="form-control rounded-pill @error('password') is-invalid @enderror"
                wire:model.live="password" placeholder="Enter your password">
            @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>


        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input @error('terms') is-invalid @enderror" id="terms" wire:model.live="terms">
            <label class="form-check-label" for="terms">
                I agree to the <a href="#" >Terms and Conditions</a>
            </label>
            @error('terms')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
        
        <div class="text-center mt-4">
            <div class="bot-login text-center">
                <span>Already have an account? <a href="{{ route('login') }}">Back to login</a></span>
            </div>
            <button type="submit" class="custom-button1 mt-2" @if(!$terms) disabled @endif>Register</button>
        </div>
    </form>
    
</div>
