<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme="">

<head>
    <script>
        (function() {
            const storedTheme = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const theme = storedTheme || (prefersDark ? 'dark' : 'light');
            document.documentElement.setAttribute('data-bs-theme', theme);
        })();
    </script>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-192x192.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-512x512.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/apple-touch-icon.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-16x16.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-32x32.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon.ico') }}" type="image/x-icon">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Softcomp.io</title>

    <link href="https://fastly.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <!-- Include Bootstrap 5 CSS -->
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet">

    <!-- Include DataTables Bootstrap 5 extension CSS -->
    <link href="{{ asset('assets/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.css" />

    <style>
        .modal {
            backdrop-filter: blur(5px);
        }

        .sidebar-icon .dropdown-menu {
            display: none;
            margin-top: .5rem;
            margin-bottom: 1.5rem;
            background-color: transparent;
            border: none;
        }

        .sidebar-icon .dropdown-menu.show {
            display: block;
        }

        .nav-link.active {
            background-color: purple;
            color: white;
            /* Agar teksnya terlihat jelas */
        }
    </style>
    @stack('styles')
    @livewireStyles
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
</head>

<body>

    <div id="app" class="bg-home">
        <div class="d-flex justify-content-center align-items-center">
            <div class="">
                @auth
                    @kasir
                        <button id="sidebarToggleBtn"
                            class="sidebar-pop go-setting-pop go-sales-emp-pop go-pricelist-pop go-good-receipt-pop go-sales-pop">
                            <div class="">
                                <a href="{{ route('welcome.awal') }}">
                                    <img id="arrowImage" src="{{ asset('assets/right-arrow (1).png') }}"
                                        style="height: 13px; width: auto" alt="Image Description">
                                </a>

                            </div>
                        </button>
                    @else
                        <button id="sidebarToggleBtn"
                            class="sidebar-pop go-setting-pop go-sales-emp-pop go-pricelist-pop go-good-receipt-pop go-sales-pop">
                            <div id="sidebarToggle" class="">
                                <img id="arrowImage" src="{{ asset('assets/right-arrow (1).png') }}"
                                    style="height: 13px; width: auto" alt="Image Description">
                            </div>
                        </button>
                    @endkasir


                    <div id="overlay" class="overlay"></div>

                    <div id="sidebar" class="sidebar">
                        <div class="p-4">
                            <div id="" class="d-flex justify-content-center logo">
                                <img id="" src="{{ asset('assets/Logo Softcomp - RGB-01.png') }}"
                                    alt="Image Description">
                            </div>
                            <div class="mt-4 gap-5"
                                style="display: flex; justify-content: space-between; flex-direction: column; height: 86vh;">
                                <div>
                                    <div class="sidebar-icon">
                                        <button id="toggleThemeButton" class="bg-transparent" style="border: none; padding: 8px 8px;"
                                            data-toggle="tooltip" rel="tooltip" data-placement="right" title="color mode"
                                            height="25px" width="25px">
                                            <i id="themeIcon" class="bi bi-moon-fill"></i>
                                        </button>
                                    </div>
                                    <div class="sidebar-icon">
                                        <a class="navbar-brand" href="{{ url('/') }}" style="padding: 8px 8px;">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" height="30px" width="30px">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                                            </svg>
                                            <div>Home</div>
                                        </a>
                                    </div>
                                    @admin
                                        <div class="sidebar-icon">
                                            <a class="nav-link {{ request()->routeIs('welcome.page-dashboard') ? 'active' : '' }}"
                                                href="{{ route('welcome.page-dashboard') }}">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                    stroke-width="1.5" stroke="currentColor" class="size-6">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5m.75-9 3-3 2.148 2.148A12.061 12.061 0 0 1 16.5 7.605" />
                                                </svg>
                                                <div>Statistics</div>
                                            </a>
                                        </div>
                                    @endadmin

                                    <!-- ARS Menu -->


                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                        data-bs-target="#collapseTwo"
                                        aria-expanded="{{ request()->routeIs('item.*') || request()->routeIs('warehouse.*') || request()->routeIs('promo.*') || request()->routeIs('user.*') ? 'true' : 'false' }}"
                                        aria-controls="collapseTwo">
                                        <div class="accordion" id="accordionExample">
                                            <div class="">
                                                <div class="" id="headingOne">
                                                    <a
                                                        class="nav-link dropdown-toggle {{ request()->routeIs('promo.*', 'po.*', 'pr.*', 'item-transfer.*', 'opname', 'item.input', 'item.pricelistitem') ? 'active' : '' }}">{{ __('') }}
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            height="30px" width="30px" title="master">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="m7.875 14.25 1.214 1.942a2.25 2.25 0 0 0 1.908 1.058h2.006c.776 0 1.497-.4 1.908-1.058l1.214-1.942M2.41 9h4.636a2.25 2.25 0 0 1 1.872 1.002l.164.246a2.25 2.25 0 0 0 1.872 1.002h2.092a2.25 2.25 0 0 0 1.872-1.002l.164-.246A2.25 2.25 0 0 1 16.954 9h4.636M2.41 9a2.25 2.25 0 0 0-.16.832V12a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 12V9.832c0-.287-.055-.57-.16-.832M2.41 9a2.25 2.25 0 0 1 .382-.632l3.285-3.832a2.25 2.25 0 0 1 1.708-.786h8.43c.657 0 1.281.287 1.709.786l3.284 3.832c.163.19.291.404.382.632M4.5 20.25h15A2.25 2.25 0 0 0 21.75 18v-2.625c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125V18a2.25 2.25 0 0 0 2.25 2.25Z" />
                                                        </svg>
                                                        <div class="" type="" data-bs-toggle="collapse"
                                                            data-bs-target="#collapseTwo" aria-expanded="true"
                                                            aria-controls="collapseOne">
                                                            Product
                                                        </div>
                                                    </a>
                                                </div>
                                                <div id="collapseTwo" class="accordion-collapse collapse"
                                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                    <div class="mt-2">
                                                        <div class="accordion" id="sub-accordionExample">
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link"
                                                                            href="{{ route('item.input') }}"
                                                                            onclick="navigate(event, '{{ route('item.input') }}', 'Item')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="master">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m7.875 14.25 1.214 1.942a2.25 2.25 0 0 0 1.908 1.058h2.006c.776 0 1.497-.4 1.908-1.058l1.214-1.942M2.41 9h4.636a2.25 2.25 0 0 1 1.872 1.002l.164.246a2.25 2.25 0 0 0 1.872 1.002h2.092a2.25 2.25 0 0 0 1.872-1.002l.164-.246A2.25 2.25 0 0 1 16.954 9h4.636M2.41 9a2.25 2.25 0 0 0-.16.832V12a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 12V9.832c0-.287-.055-.57-.16-.832M2.41 9a2.25 2.25 0 0 1 .382-.632l3.285-3.832a2.25 2.25 0 0 1 1.708-.786h8.43c.657 0 1.281.287 1.709.786l3.284 3.832c.163.19.291.404.382.632M4.5 20.25h15A2.25 2.25 0 0 0 21.75 18v-2.625c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125V18a2.25 2.25 0 0 0 2.25 2.25Z" />
                                                                            </svg>
                                                                            <div>Product</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link"
                                                                            href="{{ route('item.input') }}"
                                                                            onclick="navigate(event, '{{ route('item.input') }}', 'Pricelist')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M12 6v12m-3-2.818.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                                                            </svg>
                                                                            <div>Pricelist</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link"
                                                                            href="{{ route('item.input') }}"
                                                                            onclick="navigate(event, '{{ route('item.input') }}', 'Brand')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M16.5 3.75V16.5L12 14.25 7.5 16.5V3.75m9 0H18A2.25 2.25 0 0 1 20.25 6v12A2.25 2.25 0 0 1 18 20.25H6A2.25 2.25 0 0 1 3.75 18V6A2.25 2.25 0 0 1 6 3.75h1.5m9 0h-9" />
                                                                            </svg>
                                                                            <div>Brand</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link"
                                                                            href="{{ route('item.input') }}"
                                                                            onclick="navigate(event, '{{ route('item.input') }}', 'Category')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M2.25 7.125C2.25 6.504 2.754 6 3.375 6h6c.621 0 1.125.504 1.125 1.125v3.75c0 .621-.504 1.125-1.125 1.125h-6a1.125 1.125 0 0 1-1.125-1.125v-3.75ZM14.25 8.625c0-.621.504-1.125 1.125-1.125h5.25c.621 0 1.125.504 1.125 1.125v8.25c0 .621-.504 1.125-1.125 1.125h-5.25a1.125 1.125 0 0 1-1.125-1.125v-8.25ZM3.75 16.125c0-.621.504-1.125 1.125-1.125h5.25c.621 0 1.125.504 1.125 1.125v2.25c0 .621-.504 1.125-1.125 1.125h-5.25a1.125 1.125 0 0 1-1.125-1.125v-2.25Z" />
                                                                            </svg>

                                                                            <div>Category</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link"
                                                                            href="{{ route('item.input') }}"
                                                                            onclick="navigate(event, '{{ route('item.input') }}', 'Size')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M4.098 19.902a3.75 3.75 0 0 0 5.304 0l6.401-6.402M6.75 21A3.75 3.75 0 0 1 3 17.25V4.125C3 3.504 3.504 3 4.125 3h5.25c.621 0 1.125.504 1.125 1.125v4.072M6.75 21a3.75 3.75 0 0 0 3.75-3.75V8.197M6.75 21h13.125c.621 0 1.125-.504 1.125-1.125v-5.25c0-.621-.504-1.125-1.125-1.125h-4.072M10.5 8.197l2.88-2.88c.438-.439 1.15-.439 1.59 0l3.712 3.713c.44.44.44 1.152 0 1.59l-2.879 2.88M6.75 17.25h.008v.008H6.75v-.008Z" />
                                                                            </svg>

                                                                            <div>Size</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link"
                                                                            href="{{ route('item.input') }}"
                                                                            onclick="navigate(event, '{{ route('item.input') }}', 'Unit')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M2.25 13.5h3.86a2.25 2.25 0 0 1 2.012 1.244l.256.512a2.25 2.25 0 0 0 2.013 1.244h3.218a2.25 2.25 0 0 0 2.013-1.244l.256-.512a2.25 2.25 0 0 1 2.013-1.244h3.859m-19.5.338V18a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 18v-4.162c0-.224-.034-.447-.1-.661L19.24 5.338a2.25 2.25 0 0 0-2.15-1.588H6.911a2.25 2.25 0 0 0-2.15 1.588L2.35 13.177a2.25 2.25 0 0 0-.1.661Z" />
                                                                            </svg>
                                                                            <div>Unit of measurement</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        {{-- @pro --}}
                                                                        <a class="nav-link {{ request()->routeIs('promo.*') ? 'active' : '' }}"
                                                                            href="{{ route('promo.index') }}"
                                                                            onclick="navigate(event, '{{ route('promo.index') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9.568 3H5.25A2.25 2.25 0 0 0 3 5.25v4.318c0 .597.237 1.17.659 1.591l9.581 9.581c.699.699 1.78.872 2.607.33a18.095 18.095 0 0 0 5.223-5.223c.542-.827.369-1.908-.33-2.607L11.16 3.66A2.25 2.25 0 0 0 9.568 3Z" />
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M6 6h.008v.008H6V6Z" />
                                                                            </svg>
                                                                            <div>Promo</div>
                                                                        </a>
                                                                       

                                                                    </div>
                                                                </h2>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne"
                                        aria-expanded="{{ request()->routeIs('welcome.dashboard') || request()->routeIs('item') || request()->routeIs('salesemp') ? 'true' : 'false' }}">

                                        <div class="accordion" id="accordionExample" style="border: none">
                                            <div class="">
                                                <div class="" id="headingOne">
                                                    <a
                                                        class="nav-link dropdown-toggle {{ request()->routeIs('welcome.dashboard', 'item', 'welcome.returnsale') ? 'active' : '' }}">{{ __('') }}
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            class="size-6">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M13.5 21v-7.5a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 .75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349M3.75 21V9.349m0 0a3.001 3.001 0 0 0 3.75-.615A2.993 2.993 0 0 0 9.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 0 0 2.25 1.016c.896 0 1.7-.393 2.25-1.015a3.001 3.001 0 0 0 3.75.614m-16.5 0a3.004 3.004 0 0 1-.621-4.72l1.189-1.19A1.5 1.5 0 0 1 5.378 3h13.243a1.5 1.5 0 0 1 1.06.44l1.19 1.189a3 3 0 0 1-.621 4.72M6.75 18h3.75a.75.75 0 0 0 .75-.75V13.5a.75.75 0 0 0-.75-.75H6.75a.75.75 0 0 0-.75.75v3.75c0 .414.336.75.75.75Z" />
                                                        </svg>
                                                        <div class="" type="" data-bs-toggle="collapse"
                                                            data-bs-target="#collapseOne" aria-expanded="true"
                                                            aria-controls="collapseOne">
                                                            Transaction
                                                        </div>
                                                    </a>
                                                </div>
                                                <div id="collapseOne" class="accordion-collapse collapse"
                                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                    <div class="mt-2">
                                                        <div class="accordion" id="sub-accordionExample">
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">

                                                                        <a class="nav-link {{ request()->routeIs('welcome.dashboard') ? 'active' : '' }}"
                                                                            @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('welcome.dashboard') }}')" @endif
                                                                            href="{{ route('welcome.dashboard') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M13.5 21v-7.5a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 .75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349M3.75 21V9.349m0 0a3.001 3.001 0 0 0 3.75-.615A2.993 2.993 0 0 0 9.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 0 0 2.25 1.016c.896 0 1.7-.393 2.25-1.015a3.001 3.001 0 0 0 3.75.614m-16.5 0a3.004 3.004 0 0 1-.621-4.72l1.189-1.19A1.5 1.5 0 0 1 5.378 3h13.243a1.5 1.5 0 0 1 1.06.44l1.19 1.189a3 3 0 0 1-.621 4.72M6.75 18h3.75a.75.75 0 0 0 .75-.75V13.5a.75.75 0 0 0-.75-.75H6.75a.75.75 0 0 0-.75.75v3.75c0 .414.336.75.75.75Z" />
                                                                            </svg>
                                                                            <div>Sale</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">

                                                                        <a class="nav-link {{ request()->routeIs('item') ? 'active' : '' }}"
                                                                            href="{{ route('item') }}"
                                                                            onclick="navigate(event, '{{ route('item') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="item">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                                                            </svg>
                                                                            <div>Find Items</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">

                                                                        <a class="nav-link {{ request()->routeIs('welcome.returnsale') ? 'active' : '' }}"
                                                                            href="{{ route('welcome.returnsale') }}"
                                                                            onclick="navigate(event, '{{ route('welcome.returnsale') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                                                                <path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99" />
                                                                              </svg>
                                                                            <div>Exchange items</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('po.*') ? 'active' : '' }}"
                                                                            href="{{ route('po.index') }}"
                                                                            onclick="navigate(event, '{{ route('po.index') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5"
                                                                                stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Receipt">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3" />
                                                                            </svg>
                                                                            <div>Goods Receipt</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('pr.*') ? 'active' : '' }}"
                                                                            href="{{ route('pr.index') }}"
                                                                            onclick="navigate(event, '{{ route('pr.index') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5"
                                                                                stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Return">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                                                                            </svg>
                                                                            <div>Goods Return</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('item-transfer.*') ? 'active' : '' }}"
                                                                            href="{{ route('item-transfer.index') }}"
                                                                            @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('item-transfer.index') }}')" @endif>{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5"
                                                                                stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Item Transfer">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5m8.25 3v6.75m0 0-3-3m3 3 3-3M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                                                            </svg>
                                                                            <div>Item Transfer</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('opname') ? 'active' : '' }}"
                                                                            href="{{ route('opname') }}"
                                                                            onclick="navigate(event, '{{ route('opname') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5"
                                                                                stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="opname">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M12 6.042A8.967 8.967 0 0 0 6 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 0 1 6 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 0 1 6-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0 0 18 18a8.967 8.967 0 0 0-6 2.292m0-14.25v14.25" />
                                                                            </svg>
                                                                            <div>Opname</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordion-item" style="border: none; background: transparent;">
                                        <h2 class="accordion-header" id="sub-headingOne">
                                            <div class="sidebar-icon">
                                                <a class="nav-link {{ request()->routeIs('member.*') ? 'active' : '' }}"
                                                    href="{{ route('member.index') }}"
                                                    onclick="navigate(event, '{{ route('member.index') }}')">{{ __('') }}
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                        height="30px" width="30px" title="member">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                                                    </svg>
                                                    <div>Member</div>
                                                </a>
                                            </div>
                                        </h2>
                                    </div>
                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                        data-bs-target="#collapseARS"
                                        aria-expanded="{{ request()->routeIs('ars.*') ? 'true' : 'false' }}">

                                        <div class="accordion" id="accordionExample" style="border: none">
                                            <div class="">
                                                <div class="" id="headingOne">
                                                    <a
                                                        class="nav-link dropdown-toggle {{ request()->routeIs('ars.*') ? 'active' : '' }}">{{ __('') }}
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            class="size-6">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.325.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.241-.438.613-.43.992a7.723 7.723 0 0 1 0 .255c-.008.378.137.75.43.991l1.004.827c.424.35.534.955.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.47 6.47 0 0 1-.22.128c-.331.183-.581.495-.644.869l-.213 1.281c-.09.543-.56.94-1.11.94h-2.594c-.55 0-1.019-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.991a6.932 6.932 0 0 1 0-.255c.007-.38-.138-.751-.43-.992l-1.004-.827a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.086.22-.128.332-.183.582-.495.644-.869l.214-1.28Z" />
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                        </svg>
                                                        <div class="" type="" data-bs-toggle="collapse"
                                                            data-bs-target="#collapseARS" aria-expanded="true"
                                                            aria-controls="collapseARS">
                                                            Automation
                                                        </div>
                                                    </a>
                                                </div>
                                                <div id="collapseARS" class="accordion-collapse collapse"
                                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                    <div class="mt-2">
                                                        <div class="accordion" id="sub-accordionExample">
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header nav-link" id="sub-headingOne">
                                                                    <div class="sidebar-icon">

                                                                        <a class="nav-link {{ request()->routeIs('ars.report') ? 'active' : '' }}"
                                                                            href="{{ route('ars.report') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M13.5 21v-7.5a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 .75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349M3.75 21V9.349m0 0a3.001 3.001 0 0 0 3.75-.615A2.993 2.993 0 0 0 9.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 0 0 2.25 1.016c.896 0 1.7-.393 2.25-1.015a3.001 3.001 0 0 0 3.75.614m-16.5 0a3.004 3.004 0 0 1-.621-4.72l1.189-1.19A1.5 1.5 0 0 1 5.378 3h13.243a1.5 1.5 0 0 1 1.06.44l1.19 1.189a3 3 0 0 1-.621 4.72M6.75 18h3.75a.75.75 0 0 0 .75-.75V13.5a.75.75 0 0 0-.75-.75H6.75a.75.75 0 0 0-.75.75v3.75c0 .414.336.75.75.75Z" />
                                                                            </svg>
                                                                            <div>Restocking</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                    

                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                        data-bs-target="#collapseThree"
                                        aria-expanded="{{ request()->routeIs('report.loss-sales') || request()->routeIs('report.reportinvoicereturnsale') || request()->routeIs('report.reporttransactionmember') || request()->routeIs('report.voucher') || request()->routeIs('report.reportgoodsreceipt') || request()->routeIs('report.reportgoodsreturn') || request()->routeIs('report.reportopname') || request()->routeIs('report.reporttransactionmember') || request()->routeIs('report.voucher') || request()->routeIs('report.reportgoodsreceipt') || request()->routeIs('report.reportgoodsreturn') || request()->routeIs('report.reportopname') || request()->routeIs('report.reporttransactionmember') || request()->routeIs('report.voucher') || request()->routeIs('report.reportgoodsreceipt') || request()->routeIs('report.reportgoodsreturn') || request()->routeIs('report.reportopname') ? 'true' : 'false' }}">

                                        <div class="accordion" id="accordionExample" style="border: none">
                                            <div class="">
                                                <div class="" id="headingOne">
                                                    <a
                                                        class="nav-link dropdown-toggle {{ request()->routeIs('report.reportinvoicereturnsale', 'report.reporttransactionmember', 'report.voucher', 'report.reportgoodsreceipt', 'report.reportgoodsreturn', 'report.reportopname', 'report.reporttransfer', 'report.reportstock', 'report.reportstockcard', 'activity-log', 'report.reportmargin', 'report.loss-sales') ? 'active' : '' }}">{{ __('') }}
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            class="size-6">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25ZM6.75 12h.008v.008H6.75V12Zm0 3h.008v.008H6.75V15Zm0 3h.008v.008H6.75V18Z" />
                                                        </svg>

                                                        <div class="" type="" data-bs-toggle="collapse"
                                                            data-bs-target="#collapseThree" aria-expanded="true"
                                                            aria-controls="collapseOne">
                                                            Report
                                                        </div>
                                                    </a>
                                                </div>
                                                
                                                <div id="collapseThree" class="accordion-collapse collapse"
                                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">

                                                    <div class="mt-2">
                                                        <div class="accordion" id="sub-accordionExample">

                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportinvoicereturnsale') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportinvoicereturnsale') }}"
                                                                            onclick="navigate(event, '{{ route('report.reportinvoicereturnsale') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25ZM6.75 12h.008v.008H6.75V12Zm0 3h.008v.008H6.75V15Zm0 3h.008v.008H6.75V18Z" />
                                                                            </svg>

                                                                            <div>Sale</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>

                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.loss-sales') ? 'active' : '' }}"
                                                                            href="{{ route('report.loss-sales') }}"
                                                                            onclick="navigate(event, '{{ route('report.loss-sales') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                                                                <path stroke-linecap="round" stroke-linejoin="round" d="M7.5 21 3 16.5m0 0L7.5 12M3 16.5h13.5m0-13.5L21 7.5m0 0L16.5 12M21 7.5H7.5" />
                                                                            </svg>

                                                                            <div>Actual Lost Sale</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>

                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportmargin') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportmargin') }}"
                                                                            onclick="navigate(event, '{{ route('report.reportmargin') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M12 6v12m-3-2.818.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                                                            </svg>

                                                                            <div>Consignment</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reporttransactionmember') ? 'active' : '' }}"
                                                                            href="{{ route('report.reporttransactionmember') }}"
                                                                            onclick="navigate(event, '{{ route('report.reporttransactionmember') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="member">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                                                                            </svg>
                                                                            <div>Member Transactions</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.voucher') ? 'active' : '' }}"
                                                                            href="{{ route('report.voucher') }}"
                                                                            onclick="navigate(event, '{{ route('report.voucher') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm3 0h.008v.008H18V10.5Zm-12 0h.008v.008H6V10.5Z" />
                                                                            </svg>

                                                                            <div>Voucher</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportgoodsreceipt') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportgoodsreceipt') }}"
                                                                            onclick="navigate(event, '{{ route('report.reportgoodsreceipt') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Receipt">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3" />
                                                                            </svg>

                                                                            <div>Goods Receipt</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportgoodsreturn') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportgoodsreturn') }}"
                                                                            onclick="navigate(event, '{{ route('report.reportgoodsreturn') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Return">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                                                                            </svg>

                                                                            <div>Goods Return</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportopname') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportopname') }}"
                                                                            onclick="navigate(event, '{{ route('report.reportopname') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="opname">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M12 6.042A8.967 8.967 0 0 0 6 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 0 1 6 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 0 1 6-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0 0 18 18a8.967 8.967 0 0 0-6 2.292m0-14.25v14.25" />
                                                                            </svg>

                                                                            <div>Stock Opname</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reporttransfer') ? 'active' : '' }}"
                                                                            href="{{ route('report.reporttransfer') }}"
                                                                            onclick="navigate(event, '{{ route('report.reporttransfer') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Item Transfer">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5m8.25 3v6.75m0 0-3-3m3 3 3-3M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                                                            </svg>

                                                                            <div>Item Transfer</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportstock') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportstock') }}"
                                                                            onclick="navigate(event, '{{ route('report.reportstock') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m7.875 14.25 1.214 1.942a2.25 2.25 0 0 0 1.908 1.058h2.006c.776 0 1.497-.4 1.908-1.058l1.214-1.942M2.41 9h4.636a2.25 2.25 0 0 1 1.872 1.002l.164.246a2.25 2.25 0 0 0 1.872 1.002h2.092a2.25 2.25 0 0 0 1.872-1.002l.164-.246A2.25 2.25 0 0 1 16.954 9h4.636M2.41 9a2.25 2.25 0 0 0-.16.832V12a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 12V9.832c0-.287-.055-.57-.16-.832M2.41 9a2.25 2.25 0 0 1 .382-.632l3.285-3.832a2.25 2.25 0 0 1 1.708-.786h8.43c.657 0 1.281.287 1.709.786l3.284 3.832c.163.19.291.404.382.632M4.5 20.25h15A2.25 2.25 0 0 0 21.75 18v-2.625c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125V18a2.25 2.25 0 0 0 2.25 2.25Z" />
                                                                            </svg>

                                                                            <div>Stock</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportstockcard') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportstockcard') }}"
                                                                            onclick="navigate(event, '{{ route('report.reportstockcard') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M6 6.878V6a2.25 2.25 0 0 1 2.25-2.25h7.5A2.25 2.25 0 0 1 18 6v.878m-12 0c.235-.083.487-.128.75-.128h10.5c.263 0 .515.045.75.128m-12 0A2.25 2.25 0 0 0 4.5 9v.878m13.5-3A2.25 2.25 0 0 1 19.5 9v.878m0 0a2.246 2.246 0 0 0-.75-.128H5.25c-.263 0-.515.045-.75.128m15 0A2.25 2.25 0 0 1 21 12v6a2.25 2.25 0 0 1-2.25 2.25H5.25A2.25 2.25 0 0 1 3 18v-6c0-.98.626-1.813 1.5-2.122" />
                                                                            </svg>

                                                                            <div>Stock Card</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item"
                                                                style="border: none; background: transparent;">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('activity-log') ? 'active' : '' }}"
                                                                            href="{{ route('activity-log') }}"
                                                                            onclick="navigate(event, '{{ route('activity-log') }}')">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="activity-log">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5m.75-9 3-3 2.148 2.148A12.061 12.061 0 0 1 16.5 7.605" />
                                                                            </svg>

                                                                            <div>Activity Log</div>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                           
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                    data-bs-target="#collapseSetting"
                                    aria-expanded="{{ request()->routeIs('item.*') || request()->routeIs('warehouse.*') || request()->routeIs('salesemp') || request()->routeIs('user.*') || request()->routeIs('settings') ? 'true' : 'false' }}"
                                    aria-controls="collapseSetting">
                                    <div class="accordion" id="accordionExample">
                                        <div class="">
                                            <div class="" id="headingOne">
                                                <a
                                                    class="nav-link dropdown-toggle {{ request()->routeIs('udf.create','paymentable', 'warehouse.*', 'salesemp', 'user.index', 'changepass', 'settings', 'setting-moh-list', 'setting-moh', 'index-add-moh-udf', 'create-moh-udf') ? 'active' : '' }}">{{ __('') }}
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                        class="size-6">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            d="M10.343 3.94c.09-.542.56-.94 1.11-.94h1.093c.55 0 1.02.398 1.11.94l.149.894c.07.424.384.764.78.93.398.164.855.142 1.205-.108l.737-.527a1.125 1.125 0 0 1 1.45.12l.773.774c.39.389.44 1.002.12 1.45l-.527.737c-.25.35-.272.806-.107 1.204.165.397.505.71.93.78l.893.15c.543.09.94.559.94 1.109v1.094c0 .55-.397 1.02-.94 1.11l-.894.149c-.424.07-.764.383-.929.78-.165.398-.143.854.107 1.204l.527.738c.32.447.269 1.06-.12 1.45l-.774.773a1.125 1.125 0 0 1-1.449.12l-.738-.527c-.35-.25-.806-.272-1.203-.107-.398.165-.71.505-.781.929l-.149.894c-.09.542-.56.94-1.11.94h-1.094c-.55 0-1.019-.398-1.11-.94l-.148-.894c-.071-.424-.384-.764-.781-.93-.398-.164-.854-.142-1.204.108l-.738.527c-.447.32-1.06.269-1.45-.12l-.773-.774a1.125 1.125 0 0 1-.12-1.45l.527-.737c.25-.35.272-.806.108-1.204-.165-.397-.506-.71-.93-.78l-.894-.15c-.542-.09-.94-.56-.94-1.109v-1.094c0-.55.398-1.02.94-1.11l.894-.149c.424-.07.765-.383.93-.78.165-.398.143-.854-.108-1.204l-.526-.738a1.125 1.125 0 0 1 .12-1.45l.773-.773a1.125 1.125 0 0 1 1.45-.12l.737.527c.35.25.807.272 1.204.107.397-.165.71-.505.78-.929l.15-.894Z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                    </svg>
                                                    <div class="" type="" data-bs-toggle="collapse"
                                                        data-bs-target="#collapseSetting" aria-expanded="true"
                                                        aria-controls="collapseOne">
                                                        Setting
                                                    </div>
                                                </a>
                                            </div>
                                            <div id="collapseSetting" class="accordion-collapse collapse"
                                                aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                <div class="mt-2">
                                                    <div class="accordion" id="sub-accordionExample">
                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('paymentable') || request()->routeIs('paymentrenew') || request()->routeIs('paymentupgrade') ? 'active' : '' }}"
                                                                        href="{{ route('paymentrenew') }}"
                                                                        onclick="navigate(event, '{{ route('paymentrenew') }}')">{{ __('') }}
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            class="size-6">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M15.182 15.182a4.5 4.5 0 0 1-6.364 0M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0ZM9.75 9.75c0 .414-.168.75-.375.75S9 10.164 9 9.75 9.168 9 9.375 9s.375.336.375.75Zm-.375 0h.008v.015h-.008V9.75Zm5.625 0c0 .414-.168.75-.375.75s-.375-.336-.375-.75.168-.75.375-.75.375.336.375.75Zm-.375 0h.008v.015h-.008V9.75Z" />
                                                                        </svg>
                                                                        <div>Subscribe</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>

                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('udf.create') ? 'active' : '' }}"
                                                                        href="{{ route('udf.create') }}"
                                                                        onclick="navigate(event, '{{ route('udf.create') }}')">{{ __('') }}
                                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth={1.5} stroke="currentColor" className="w-6 h-6">
                                                                            <path strokeLinecap="round" strokeLinejoin="round" d="M10.5 6h3m-3 6h3m-3 6h3M6 10.5h12m-12-6h12m-12 12h12" />
                                                                          </svg>
                                                                          
                                                                        <div>UDF</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>
                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('user.index') ? 'active' : '' }}"
                                                                        href="{{ route('user.index') }}"
                                                                        onclick="navigate(event, '{{ route('user.index') }}')">{{ __('') }}
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            class="size-6">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z" />
                                                                        </svg>
                                                                        <div>User Management</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>
                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('item.*') ? 'active' : '' }}"
                                                                        href="{{ route('item.input') }}"
                                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Supplier')">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            class="size-6">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M8.25 18.75a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 0 1-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 0 0-3.213-9.193 2.056 2.056 0 0 0-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 0 0-10.026 0 1.106 1.106 0 0 0-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12" />
                                                                        </svg>
                                                                        <div>Supplier</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>
                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('warehouse.*') ? 'active' : '' }}"
                                                                        href="{{ route('warehouse.index') }}"
                                                                        onclick="navigate(event, '{{ route('warehouse.index') }}')">{{ __('') }}
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            class="size-6">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M13.5 21v-7.5a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 .75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349M3.75 21V9.349m0 0a3.001 3.001 0 0 0 3.75-.615A2.993 2.993 0 0 0 9.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 0 0 2.25 1.016c.896 0 1.7-.393 2.25-1.015a3.001 3.001 0 0 0 3.75.614m-16.5 0a3.004 3.004 0 0 1-.621-4.72l1.189-1.19A1.5 1.5 0 0 1 5.378 3h13.243a1.5 1.5 0 0 1 1.06.44l1.19 1.189a3 3 0 0 1-.621 4.72M6.75 18h3.75a.75.75 0 0 0 .75-.75V13.5a.75.75 0 0 0-.75-.75H6.75a.75.75 0 0 0-.75.75v3.75c0 .414.336.75.75.75Z" />
                                                                        </svg>
                                                                        <div>Store</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>

                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('salesemp') ? 'active' : '' }}"
                                                                        href="{{ route('salesemp') }}"
                                                                        onclick="navigate(event, '{{ route('salesemp') }}')">{{ __('') }}
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            height="30px" width="30px"
                                                                            title="salesemp">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z" />
                                                                        </svg>
                                                                        <div>Store staff</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>

                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('changepass') ? 'active' : '' }}"
                                                                        href="{{ route('changepass') }}"
                                                                        onclick="navigate(event, '{{ route('changepass') }}')">{{ __('') }}
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            class="size-6">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M15.75 5.25a3 3 0 0 1 3 3m3 0a6 6 0 0 1-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1 1 21.75 8.25Z" />
                                                                        </svg>
                                                                        <div>Change Password</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>

                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <div class="collapsed d-flex justify-content-between"
                                                                        type="" data-bs-toggle="collapse"
                                                                        data-bs-target="#mohSubMenu"
                                                                        aria-expanded="false"
                                                                        aria-controls="mohSubMenu">
                                                                        <a class="nav-link dropdown-toggle {{ request()->routeIs('setting-moh-list', 'setting-moh', 'index-add-moh-udf', 'create-moh-udf') ? 'active' : '' }}">
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9 17.25v1.007a3 3 0 0 1-.879 2.122L7.5 21h9l-.621-.621A3 3 0 0 1 15 18.257V17.25m6-12V15a2.25 2.25 0 0 1-2.25 2.25H5.25A2.25 2.25 0 0 1 3 15V5.25m18 0A2.25 2.25 0 0 0 18.75 3H5.25A2.25 2.25 0 0 0 3 5.25m18 0V12a2.25 2.25 0 0 1-2.25 2.25H5.25A2.25 2.25 0 0 1 3 12V5.25" />
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M8.25 15h7.5m-7.5-3h7.5m-7.5-3h7.5" />
                                                                            </svg>
                                                                            <div>DoH</div>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </h2>
                                                            <div id="mohSubMenu"
                                                                class="accordion-collapse collapse mx-3 mb-2"
                                                                aria-labelledby="mohHeading">
                                                                <div class="accordion-item"
                                                                    style="border: none; background: transparent;">
                                                                    <h2 class="accordion-header" id="mohListHeading">
                                                                        <div class="sidebar-icon">
                                                                            <a class="nav-link {{ request()->routeIs('setting-moh-list') ? 'active' : '' }}"
                                                                                href="{{ route('setting-moh-list') }}"
                                                                                onclick="navigate(event, '{{ route('setting-moh-list') }}')">
                                                                                <svg xmlns="http://www.w3.org/2000/svg"
                                                                                    fill="none" viewBox="0 0 24 24"
                                                                                    stroke-width="1.5" stroke="currentColor"
                                                                                    class="size-6">
                                                                                    <path stroke-linecap="round"
                                                                                        stroke-linejoin="round"
                                                                                        d="M9 17.25v1.007a3 3 0 0 1-.879 2.122L7.5 21h9l-.621-.621A3 3 0 0 1 15 18.257V17.25m6-12V15a2.25 2.25 0 0 1-2.25 2.25H5.25A2.25 2.25 0 0 1 3 15V5.25m18 0A2.25 2.25 0 0 0 18.75 3H5.25A2.25 2.25 0 0 0 3 5.25m18 0V12a2.25 2.25 0 0 1-2.25 2.25H5.25A2.25 2.25 0 0 1 3 12V5.25" />
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M8.25 15h7.5m-7.5-3h7.5m-7.5-3h7.5" />
                                                                            </svg>
                                                                            <div>DoH</div>
                                                                            </a>
                                                                        </div>
                                                                    </h2>
                                                                </div>
                                                                <div class="accordion-item"
                                                                    style="border: none; background: transparent;">
                                                                    <h2 class="accordion-header" id="mohUdfHeading">
                                                                        <div class="sidebar-icon">
                                                                            <a class="nav-link {{ request()->routeIs('index-add-moh-udf', 'create-moh-udf') ? 'active' : '' }}"
                                                                                href="{{ route('index-add-moh-udf') }}"
                                                                                onclick="navigate(event, '{{ route('index-add-moh-udf') }}')">
                                                                                <svg xmlns="http://www.w3.org/2000/svg"
                                                                                    fill="none" viewBox="0 0 24 24"
                                                                                    stroke-width="1.5" stroke="currentColor"
                                                                                    class="size-6">
                                                                                    <path stroke-linecap="round"
                                                                                        stroke-linejoin="round"
                                                                                        d="M10.5 6h3m-3 6h3m-3 6h3M6 10.5h12m-12-6h12m-12 12h12" />
                                                                                </svg>
                                                                                <div>DoH UDF</div>
                                                                            </a>
                                                                        </div>
                                                                    </h2>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="accordion-item"
                                                            style="border: none; background: transparent;">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('settings') ? 'active' : '' }}"
                                                                        href="{{ route('settings') }}"
                                                                        @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('settings') }}')" @endif>
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            class="size-6">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M10.343 3.94c.09-.542.56-.94 1.11-.94h1.093c.55 0 1.02.398 1.11.94l.149.894c.07.424.384.764.78.93.398.164.855.142 1.205-.108l.737-.527a1.125 1.125 0 0 1 1.45.12l.773.774c.39.389.44 1.002.12 1.45l-.527.737c-.25.35-.272.806-.107 1.204.165.397.505.71.93.78l.893.15c.543.09.94.559.94 1.109v1.094c0 .55-.397 1.02-.94 1.11l-.894.149c-.424.07-.764.383-.929.78-.165.398-.143.854.107 1.204l.527.738c.32.447.269 1.06-.12 1.45l-.774.773a1.125 1.125 0 0 1-1.449.12l-.738-.527c-.35-.25-.806-.272-1.203-.107-.398.165-.71.505-.781.929l-.149.894c-.09.542-.56.94-1.11.94h-1.094c-.55 0-1.019-.398-1.11-.94l-.148-.894c-.071-.424-.384-.764-.781-.93-.398-.164-.854-.142-1.204.108l-.738.527c-.447.32-1.06.269-1.45-.12l-.773-.774a1.125 1.125 0 0 1-.12-1.45l.527-.737c.25-.35.272-.806.108-1.204-.165-.397-.506-.71-.93-.78l-.894-.15c-.542-.09-.94-.56-.94-1.109v-1.094c0-.55.398-1.02.94-1.11l.894-.149c.424-.07.765-.383.93-.78.165-.398.143-.854-.108-1.204l-.526-.738a1.125 1.125 0 0 1 .12-1.45l.773-.773a1.125 1.125 0 0 1 1.45-.12l.737.527c.35.25.807.272 1.204.107.397-.165.71-.505.78-.929l.15-.894Z" />
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                                        </svg>

                                                                        <div>Setting</div>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                    <div class="accordion-item" style="border: none; background: transparent;">
                                        <h2 class="accordion-header" id="sub-headingOne">
                                            <div class="sidebar-icon">
                                                <a class="nav-link {{ request()->routeIs('bantuan') ? 'active' : '' }}"
                                                    href="{{ route('bantuan') }}">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                        class="size-6">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            d="m11.25 11.25.041-.02a.75.75 0 0 1 1.063.852l-.708 2.836a.75.75 0 0 0 1.063.853l.041-.021M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9-3.75h.008v.008H12V8.25Z" />
                                                    </svg>

                                                    <div>Help</div>
                                                </a>
                                            </div>
                                        </h2>
                                    </div>
                                </div>


                                <div class="accordion-item" style="border: none; background: transparent;"
                                    x-data="logoutWithNps()" x-init="init()">
                                    <h2 class="accordion-header" id="sub-headingOne">
                                        <div class="sidebar-icon">
                                            <a class="nav-link {{ request()->routeIs('logouts') ? 'active' : '' }}"
                                                href="#" @click.prevent="handleLogout">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    height="30px" width="30px" title="Logout">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                                                </svg>
                                                <div>Logout</div>
                                            </a>
                                        </div>
                                    </h2>

                                    <form id="logout-form" action="{{ route('logouts') }}" method="POST"
                                        class="d-none">
                                        @csrf
                                    </form>

                                    {{-- Modal NPS --}}
                                    <template x-if="showNpsModal">
                                        <div class="position-fixed top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-dark bg-opacity-50"
                                            style="z-index: 9999;">
                                            <div class="bg-white p-4 rounded shadow"
                                                style="width: 90%; max-width: 500px;">
                                                <div class="text-center">
                                                    <template x-if="!submitted">
                                                        <div>
                                                            <h5 class="mb-3">How helpful and satisfied are you with this system?</h5>
                                                            <div class="d-flex justify-content-center flex-wrap mb-3">
                                                                <template x-for="n in 11" :key="n">
                                                                    <button type="button" class="btn m-1"
                                                                        :class="{ 'btn-primary': score === (n -
                                                                            1), 'btn-outline-primary': score !== (n -
                                                                            1) }"
                                                                        @click="score = n - 1" x-text="n - 1">
                                                                    </button>
                                                                </template>
                                                            </div>

                                                            <div x-show="score !== null" class="mb-3">
                                                                <textarea x-model="comment" class="form-control" placeholder="Leave your comments..." rows="3"></textarea>
                                                            </div>

                                                            <div class="text-danger mb-2" x-text="error"></div>

                                                            <div class="d-flex justify-content-between">
                                                                <button type="button" class="btn btn-secondary"
                                                                    @click="skip()">Skip</button>
                                                                <button type="button" class="btn btn-success"
                                                                    @click="submit()">Send</button>
                                                            </div>
                                                        </div>
                                                    </template>

                                                    <template x-if="submitted">
                                                        <div>
                                                            <h5 class="text-success">Thank you for your feedback! ðŸ™
                                                            </h5>
                                                        </div>
                                                    </template>
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                </div>

                                <script>
                                    function logoutWithNps() {
                                        return {
                                            showNpsModal: false,
                                            score: null,
                                            comment: '',
                                            error: '',
                                            submitted: false,

                                            init() {
                                                // inisialisasi jika perlu
                                            },

                                            handleLogout() {
                                                if (@json($rateLogout)) {
                                                    this.showNpsModal = true;
                                                } else {
                                                    document.getElementById('logout-form').submit();
                                                }
                                            },

                                            skip() {
                                                this.submitted = true;
                                                fetch('/nps-response', {
                                                    method: 'POST',
                                                    headers: {
                                                        'Content-Type': 'application/json',
                                                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                                    },
                                                    body: JSON.stringify({
                                                        skipped: true
                                                    })
                                                }).then(() => {
                                                    setTimeout(() => {
                                                        document.getElementById('logout-form').submit();
                                                    }, 1500);
                                                });
                                            },

                                            submit() {
                                                if (this.score === null) {
                                                    this.error = 'Please select the score first.';
                                                    return;
                                                }
                                                if (this.score < 8 && this.comment.trim() === '') {
                                                    this.error = 'Comments are required for scores below 8.';
                                                    return;
                                                }

                                                this.error = '';
                                                fetch('/nps-response', {
                                                    method: 'POST',
                                                    headers: {
                                                        'Content-Type': 'application/json',
                                                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                                    },
                                                    body: JSON.stringify({
                                                        score: this.score,
                                                        comment: this.comment
                                                    })
                                                }).then(() => {
                                                    this.submitted = true;
                                                    setTimeout(() => {
                                                        document.getElementById('logout-form').submit();
                                                    }, 1500);
                                                });
                                            }
                                        }
                                    }
                                </script>

                            </div>
                        </div>
                    </div>
                @endauth
            </div>

            <div class="container">
                <main>
                    @yield('content')
                    <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>
                    <x-livewire-alert::scripts />
                </main>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.js.iife.js"></script>

    <!-- Include jQuery -->
    <script src="{{ asset('assets/js/jquery-3.7.0.js') }}"></script>
    <!-- Include Bootstrap 5 JS -->
    {{-- <script src="{{ asset('assets/js/bootstrap.bundle.min.js') }}"></script> --}}
    <!-- Include DataTables core script -->
    <script src="{{ asset('assets/js/jquery.dataTables.min.js') }}"></script>
    <!-- Include DataTables Bootstrap 5 extension script -->
    <script src="{{ asset('assets/js/dataTables.bootstrap5.min.js') }}"></script>
    @kasir
    @else
        <script>
            const sidebarToggle = document.getElementById('sidebarToggleBtn');
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('overlay');

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-open');
                overlay.classList.toggle('show');
            }

            sidebarToggle.addEventListener('click', toggleSidebar);

            overlay.addEventListener('click', () => {
                sidebar.classList.remove('sidebar-open');
                overlay.classList.remove('show');
            });

            document.addEventListener('keydown', (event) => {
                if (event.key === '`') {
                    toggleSidebar();

                }
            });
        </script>
    @endkasir
    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keydown(function(e) {
                if (e.ctrlKey && e.which == 32) {
                    e.preventDefault();
                    $('.dataTables_filter input').focus();
                } else if (e.which == 34) {
                    e.preventDefault();
                    table.page('next').draw('page');
                } else if (e.which == 33) {
                    e.preventDefault();
                    table.page('previous').draw('page');
                }
            });
        });




        function navigate(event, url, item) {
            event.preventDefault();
            $.ajax({
                url: '/set-session',
                method: 'POST',
                data: {
                    item: item,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        window.location.href = url;
                    } else {
                        console.error('Failed to set session value.');
                    }
                },
                error: function(xhr) {
                    console.error('AJAX request failed.');
                }
            });
        }

        function navigateToSelectItem(event, url) {
            event.preventDefault();

            $.ajax({
                url: '/set-session-to-url',
                method: 'POST',
                data: {
                    toUrl: url,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        window.location.href = "{{ route('select-warehouse') }}";
                    } else {
                        console.error('Failed to set session value.');
                    }
                },
                error: function(xhr) {
                    console.error('AJAX request failed.');
                }
            });
        }


        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });


        document.addEventListener("DOMContentLoaded", function() {
            const currentTheme = localStorage.getItem('theme') || 'light';

            document.documentElement.setAttribute('data-bs-theme', currentTheme);

            // Set the icon based on the theme
            const themeIcon = document.getElementById('themeIcon');
            if (currentTheme === 'dark') {
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            } else {
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            }
        });

        const toggleThemeButton = document.getElementById('toggleThemeButton');
        toggleThemeButton.addEventListener('click', () => {
            const currentTheme = document.documentElement.getAttribute('data-bs-theme');
            let newTheme = 'dark';

            if (currentTheme === 'dark') {
                newTheme = 'light';
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            } else {
                newTheme = 'dark';
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            }

            document.documentElement.setAttribute('data-bs-theme', newTheme);
            localStorage.setItem('theme', newTheme); // Store the theme in local storage
        });

        document.addEventListener("DOMContentLoaded", function() {
            const myNavbar = document.getElementById('myNavbar');

            // Hide the navbar initially
            myNavbar.style.display = 'none';

            // Listen for the 'keydown' event anywhere on the document
            document.addEventListener('keydown', function(event) {
                // Check if '/' key is pressed (key code 191 for '/')
                if (event.key === '/') {
                    // Toggle the visibility of the navbar
                    myNavbar.style.display = myNavbar.style.display === 'none' ? 'block' : 'none';
                }
            });
        });
        document.addEventListener("DOMContentLoaded", function() {
            var navLinks = document.querySelectorAll('.nav-link');
            var currentPage = window.location.pathname.split('/').pop();

            navLinks.forEach(function(link) {
                if (link.getAttribute('href') === currentPage) {
                    link.classList.add('active');
                }
            });
        });
        reportDropdown
        document.addEventListener('DOMContentLoaded', function() {
            var reportDropdown = document.getElementById('reportDropdown');
            var dropdownMenu = document.getElementById('reportDropdownMenu');
            var content = document.querySelector('.content');

            reportDropdown.addEventListener('click', function(e) {
                e.preventDefault();
                dropdownMenu.classList.toggle('show');

                if (dropdownMenu.classList.contains('show')) {
                    content.style.marginTop = dropdownMenu.clientHeight + 'px';
                } else {
                    content.style.marginTop = '0';
                }
            });

            document.addEventListener('click', function(e) {
                if (!reportDropdown.contains(e.target) && !dropdownMenu.contains(e.target)) {
                    dropdownMenu.classList.remove('show');
                    content.style.marginTop = '0';
                }
            });
        });
        document.getElementById('logoutDropdown').addEventListener('click', function(event) {
            event.preventDefault();
            var logoutDropdownMenu = document.getElementById('logoutDropdownMenu');
            logoutDropdownMenu.style.display = (logoutDropdownMenu.style.display === 'block') ? 'none' : 'block';
        });

        window.addEventListener('click', function(event) {
            var logoutDropdownMenu = document.getElementById('logoutDropdownMenu');

            if (!document.getElementById('logoutDropdown').contains(event.target)) {
                logoutDropdownMenu.style.display = 'none';
            }
        });
    </script>
    @auth
        @if (auth()->user()->tutorials == 'Y')
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    setTimeout(() => {
                        if (document.querySelector('.cashier-page')) {
                            // cashierPopup();
                        } else if (document.querySelector('.member-page')) {
                            memberPopup();
                        } else if (document.querySelector('.goods-receipt-page')) {
                            goodsReceiptsPopup();
                        } else if (document.querySelector('.goods-return-page')) {
                            goodsReturnPopup();
                        } else if (document.querySelector('.it-page')) {
                            itemTransferPopup();
                        } else if (document.querySelector('.dashboard-page')) {
                            dashboardPopup();
                        } else if (document.querySelector('.warehouse-page')) {
                            warehousePopup();
                        } else if (document.querySelector('.supplier-page')) {
                            supplierPopup();
                        } else if (document.querySelector('.sales-emp-page')) {
                            salesEmpPopup();
                        } else if (document.querySelector('.brand-page')) {
                            brandPopup();
                            // } else if (document.querySelector('.pricelist-page')) {
                            //     pricelistPopup();
                        } else if (document.querySelector('.product-page')) {
                            productPopup();
                        } else if (document.querySelector('.promo-page')) {
                            promoPopup();
                        }
                    }, 1000);
                });
            </script>
        @endif

    @endauth
    @stack('scripts')
</body>

</html>
