@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="it-page">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Item Transfer') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                        {{-- <a href="{{ route('welcome.dashboard') }}" class="btn badge btn-primary">POS</a> --}}
                    </div>
                    <div class="card-body">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        <livewire:pos.item-transfer.index />

                    </div>
                </div>
            </div>
        </div>
    </div>
    @if ($istutorials)
        <script>
            const itemTransferPopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver({
                    showProgress: true,
                    steps: [
                        {
                            element: '.create-it-in-pop',
                            popover: {
                                description: 'Click this button to create an "IT In" record for receiving items into inventory.'
                            }
                        },
                        {
                            element: '.create-it-out-pop',
                            popover: {
                                description: 'Click this button to create an "IT Out" record for transferring items out of inventory.'
                            }
                        },
                        {
                            element: '.it-detail-pop',
                            popover: {
                                description: 'Click this button to view the details of the item transfer.'
                            }
                        },
                        {
                            element: '.filter-it-pop',
                            popover: {
                                description: 'Click here to filter the list by All Items, IT In, or IT Out.'
                            },
                            onDeselected: () => {
                                $.ajax({
                                    type: "POST",
                                    url: '/update-status-driver',
                                    data: {
                                        menu: "Item Transfer",
                                        _token: '{{ csrf_token() }}'
                                    },
                                    success: function(data) {
                                    },
                                    error: function(data, textStatus, errorThrown) {
                                    },
                                });
                            }
                        },
                    ]
                });

                driverObj.drive();
            }

        </script>
    @endif
@endsection
