<html>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link type="text/css" rel="stylesheet" href="resources/sheet.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/sheet.css') }}">

<div class="ritz grid-container" dir="ltr">
    <table>
        <thead>
            <tr></tr>
        </thead>
        <tbody>
            <td></td>
        </tbody>
    </table>
    <table class="waffle" cellspacing="0" cellpadding="0">
        <thead>
            <tr style="height: 20px">
                <th class="s1"></th>
                <th class="s2" style="font-weight: bold;" dir="ltr">ItemCode</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">CodeBars</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">ItemName</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">Price</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">Qty</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">Subtotal</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">Discount</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">Grand Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($invoices as $invoice)
            @php
                $firstDetail = $invoice->detailInvoices->first();
                $salesName = $firstDetail ? $firstDetail->sales->name ?? '-' : null;
            @endphp
            <tr style="height: 20px">
                <td class="s1"></td>
                <td class="s3" dir="ltr" style="text-align: left; font-weight: bold;" colspan="3">{{ $invoice->no }} - {{ $invoice->created_at }}</td>
                <td class="s3" dir="ltr" colspan="3">User : {{ $invoice->user->username }}</td>
                <td class="s5" dir="ltr" colspan="2">Staff : {{ $salesName }}</td>
            </tr>   
            @forelse ($invoice->detailInvoices as $detail)
            <tr style="height: 20px">
                <td class="s1"></td>
                <td class="s4" dir="ltr">{{ $detail->code }}</td>
                <td class="s4" dir="ltr">{{ optional($detail->item)->barcode }}</td>
                <td class="s4" dir="ltr">{{ $detail->name }}</td>
                <td class="s6" dir="ltr">{{ $detail->nprice }}</td>
                <td class="s7" dir="ltr">{{ $detail->qty }}</td>
                <td class="s7" dir="ltr">{{ $detail->nprice * $detail->qty }}</td>
                <td class="s7" dir="ltr">{{ ($detail->nprice - $detail->price) * abs($detail->qty) }}</td>
                <td class="s8" dir="ltr">{{ $detail->total_price }}</td>
            </tr>
            @empty
            -
            @endforelse
            <tr style="height: 20px">
                <td class="s1"></td>
                <td class="s9" style="text-align: left; font-weight: bold;" colspan="4" dir="ltr">Subtotal</td>
                <td class="s7" style="font-weight: bold;" dir="ltr">{{ $invoice->detailInvoices->sum('qty') }}</td>
                <td class="s7" style="font-weight: bold;" dir="ltr">{{ $invoice->detailInvoices->sum('total_price') }}</td>
                <td class="s7" style="font-weight: bold;" dir="ltr">0</td>
                <td class="s8" style="font-weight: bold;" dir="ltr">{{ $invoice->detailInvoices->sum('total_price') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
</html>